//
//  FullScreenViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/20.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "FullScreenViewController.h"
#import "FullScreenViewCell.h"


@interface FullScreenViewController ()


/**
 *  返回View
 */
@property (nonatomic,strong) UIView *backView;

@end

@implementation FullScreenViewController

static NSString * const reuseIdentifier = @"Cell";



#pragma mark -初始化
- (instancetype)init
{
    // 创建一个流水布局
    UICollectionViewFlowLayout *layout = [[UICollectionViewFlowLayout alloc] init];
    
    // 设置cell的尺寸
    layout.itemSize = [UIScreen mainScreen].bounds.size;
    
    // 设置滚动的方向
    layout.scrollDirection = UICollectionViewScrollDirectionHorizontal;
    
    // 行间距
    layout.minimumLineSpacing = 0;
    
    // 设置cell之间的间距
    layout.minimumInteritemSpacing = 0;
    //
    //    // 组间距
    //    layout.sectionInset = UIEdgeInsetsMake(100, 20, 0, 30);
    
    return [super initWithCollectionViewLayout:layout];
}



- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self uiConfigAction];
    [self CreateBackView];
}


#pragma amrk 返回View
- (void)CreateBackView
{
    self.backView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, ScreenWidth, 64)];
    self.backView.backgroundColor = kMainGrayColor;
    [self.view addSubview:self.backView];
    
    //返回按钮
    UIButton *backButton = [UIButton buttonWithType:UIButtonTypeCustom];
    backButton.frame = CGRectMake(50, 0, 100, 64);
    [backButton setTitle:@"返回" forState:UIControlStateNormal];
    
    [backButton addTarget:self action:@selector(BackButtonClick) forControlEvents:UIControlEventTouchUpInside];
    [self.backView addSubview:backButton];
    //随心配
}

#pragma mark -返回
- (void)BackButtonClick
{
    [self dismissViewControllerAnimated:YES completion:nil];
}



#pragma mark -UI
- (void)uiConfigAction
{
    self.collectionView.pagingEnabled = YES;
    [self.collectionView registerClass:[FullScreenViewCell class] forCellWithReuseIdentifier:reuseIdentifier];
}


#pragma mark <UICollectionViewDataSource>

- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section {
    return 10;
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath {
    
    FullScreenViewCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:reuseIdentifier forIndexPath:indexPath];
    return cell;
}

- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    NSLog(@"%ld",indexPath.item);
}

#pragma mark <UICollectionViewDelegate>

/*
// Uncomment this method to specify if the specified item should be highlighted during tracking
- (BOOL)collectionView:(UICollectionView *)collectionView shouldHighlightItemAtIndexPath:(NSIndexPath *)indexPath {
	return YES;
}
*/

/*
// Uncomment this method to specify if the specified item should be selected
- (BOOL)collectionView:(UICollectionView *)collectionView shouldSelectItemAtIndexPath:(NSIndexPath *)indexPath {
    return YES;
}
*/

/*
// Uncomment these methods to specify if an action menu should be displayed for the specified item, and react to actions performed on the item
- (BOOL)collectionView:(UICollectionView *)collectionView shouldShowMenuForItemAtIndexPath:(NSIndexPath *)indexPath {
	return NO;
}

- (BOOL)collectionView:(UICollectionView *)collectionView canPerformAction:(SEL)action forItemAtIndexPath:(NSIndexPath *)indexPath withSender:(id)sender {
	return NO;
}

- (void)collectionView:(UICollectionView *)collectionView performAction:(SEL)action forItemAtIndexPath:(NSIndexPath *)indexPath withSender:(id)sender {
	
}
*/

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
 #pragma mark - Navigation
 
 // In a storyboard-based application, you will often want to do a little preparation before navigation
 - (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
 // Get the new view controller using [segue destinationViewController].
 // Pass the selected object to the new view controller.
 }
 */

@end
