//
//  ShoppingTableViewCell.m
//  Lighting
//
//  Created by 曹云霄 on 16/4/29.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "ShoppingTableViewCell.h"

@implementation ShoppingTableViewCell

- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
    
    [self uiConfigAction];
}


#pragma mark -UI
- (void)uiConfigAction
{
    self.ClinchPriceBackView.layer.masksToBounds = YES;
    self.ClinchPriceBackView.layer.cornerRadius = kCornerRadius;
    self.clinchTextfield.delegate = self;
}

#pragma mark -赋值
- (void)setModel:(ShopcarModel *)model
{
    _model = model;
    self.selectedButton.selected = _model.isSelected;
    [self.goodsImageView sd_setImageWithURL:[NSURL URLWithString:_model.goods.pictures] placeholderImage:ReplaceImage];
    self.goodsInformationLabe.text = _model.goods.name;
    self.tagsPriceLabe.text = [_model.goods.tagPrice stringValue];
    self.clinchTextfield.text = [_model.goods.costPrice stringValue];
    self.goodsNumbersLabe.text = [NSString stringWithFormat:@"%d",_model.goodsNum];
    self.productPriceLabe.text = [NSString stringWithFormat:@"￥%ld",[self.goodsNumbersLabe.text integerValue]*[_model.goods.costPrice integerValue]];;
}

#pragma mark -增加或者减少商品
- (IBAction)reduceAndaddButtonClick:(UIButton *)sender {
    
    //sender.tag == 100   减少
    //sender.tag == 101   增加
    NSLog(@"%ld",sender.tag);
    
    
    NSInteger goodsNumber = [self.goodsNumbersLabe.text integerValue];
    switch (sender.tag) {
        case 100://减少
        {
            if (goodsNumber <= 1) {
                
                if (self.promptStringBlock) {
                    self.promptStringBlock(@"个数不能小于1");
                }
                //不能小于1
                return;
            }
            goodsNumber --;
            self.goodsNumbersLabe.text = [NSString stringWithFormat:@"%ld",goodsNumber];
            
        }
            break;
        case 101://增加
        {
            if (goodsNumber >= [_model.goods.number integerValue]) {
                
                //不能大于库存
                if (self.promptStringBlock) {
                    self.promptStringBlock(@"个数不能大于库存");
                }
                return;
            }
            goodsNumber ++;
            self.goodsNumbersLabe.text = [NSString stringWithFormat:@"%ld",goodsNumber];
            
        }
            break;
            
        default:
            break;
    }
    //改变价格
    self.productPriceLabe.text = [NSString stringWithFormat:@"￥%ld",[self.goodsNumbersLabe.text integerValue]*[_model.goods.costPrice integerValue]];
    
    if ([self.delegate respondsToSelector:@selector(ChangeGoodsNumber:WithcostPrice:Withcellindex:)]) {
        [self.delegate ChangeGoodsNumber:[self.goodsNumbersLabe.text intValue] WithcostPrice:[self.clinchTextfield.text intValue]Withcellindex:_cellindex];
    }
}


#pragma mark -商品选中
- (IBAction)selectedButtonClick:(UIButton *)sender {
    
    if (self.returnCellblock) {
        
        self.returnCellblock(_cellindex);
    }
    sender.selected = !sender.selected;
}


#pragma mark -成交价完成修改
- (BOOL)textFieldShouldEndEditing:(UITextField *)textField
{
    if (![self isPureInt:textField.text]) {
        if (self.promptStringBlock) {
            self.promptStringBlock(@"输入格式错误");
            return NO;
        }
    }
    //改变价格
    self.productPriceLabe.text = [NSString stringWithFormat:@"￥%ld",[self.goodsNumbersLabe.text integerValue]*[textField.text integerValue]];
    
    if ([self.delegate respondsToSelector:@selector(ChangeGoodsNumber:WithcostPrice:Withcellindex:)]) {
        [self.delegate ChangeGoodsNumber:[self.goodsNumbersLabe.text intValue] WithcostPrice:[self.clinchTextfield.text intValue]Withcellindex:_cellindex];
    }
    return YES;
}


#pragma mark - 判断是否是纯数字
- (BOOL)isPureInt:(NSString*)string{
    NSScanner* scan = [NSScanner scannerWithString:string];
    int val;
    return[scan scanInt:&val] && [scan isAtEnd];
}






- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
