//
//  ShoppingTableViewCell.m
//  Lighting
//
//  Created by 曹云霄 on 16/4/29.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "ShoppingTableViewCell.h"

@implementation ShoppingTableViewCell

- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
    
    [self uiConfigAction];
}


#pragma mark -UI
- (void)uiConfigAction
{
    self.ClinchPriceBackView.layer.masksToBounds = YES;
    self.ClinchPriceBackView.layer.cornerRadius = kCornerRadius;
    self.clinchTextfield.delegate = self;
}

#pragma mark -赋值
- (void)setModel:(ShopcarModel *)model
{
    _model = model;
    self.selectedButton.selected = _model.isSelected;
    NSArray *images = [_model.goods.pictures componentsSeparatedByString:@","];
    [self.goodsImageView sd_setImageWithURL:[NSURL URLWithString:[images firstObject]] placeholderImage:REPLACEIMAGE];
    self.goodsInformationLabe.text = _model.goods.name;
    self.specifications.text = _model.goods.spec;
    self.goodsCode.text = _model.goods.code;
    self.tagsPriceLabe.text = [_model.goods.tagPrice stringValue];
    self.clinchTextfield.text = [NSString stringWithFormat:@"%.2f",[_model.costPrice floatValue]?[_model.costPrice floatValue]:[_model.goods.tagPrice floatValue]];
    self.goodsNumbersLabe.text = [NSString stringWithFormat:@"%ld",_model.goodsNum];
    if ([_model.costPrice integerValue] == 0) {
        _model.costPrice = _model.goods.tagPrice;
    }
    self.productPriceLabe.text = [NSString stringWithFormat:@"￥%.2f",[self.goodsNumbersLabe.text integerValue]*[_model.costPrice floatValue]];;
}

#pragma mark -增加或者减少商品
- (IBAction)reduceAndaddButtonClick:(UIButton *)sender {
    
    //sender.tag == 100   减少
    //sender.tag == 101   增加
    NSInteger goodsNumber = [self.goodsNumbersLabe.text integerValue];
    switch (sender.tag) {
        case 100://减少
        {
            if (goodsNumber <= 1) {
                if (self.promptStringBlock) {
                    self.promptStringBlock(@"个数不能小于1");
                }
                //不能小于1
                return;
            }
            goodsNumber --;
        }
            break;
        case 101://增加
        {
            if (goodsNumber >= [_model.goods.number integerValue]) {
                //不能大于库存
                if (self.promptStringBlock) {
                    self.promptStringBlock(@"个数不能大于库存");
                }
                return;
            }
            goodsNumber ++;
        }
            break;
        default:
            break;
    }
    //改变价格
    WS(weakSelf);
    if ([self.delegate respondsToSelector:@selector(ChangeGoodsNumber:WithcostPrice:Withcellindex:returnValue:)]) {
        [self.delegate ChangeGoodsNumber:goodsNumber WithcostPrice:[self.clinchTextfield.text floatValue]Withcellindex:_cellindex returnValue:^(id value) {
            if ([value isKindOfClass:[NSDictionary class]]) {
                if ([value[@"code"] isEqualToNumber:@0]) {
                  weakSelf.goodsNumbersLabe.text = [NSString stringWithFormat:@"%ld",goodsNumber];
                  weakSelf.productPriceLabe.text = [NSString stringWithFormat:@"￥%.2f",[self.goodsNumbersLabe.text integerValue]*[self.clinchTextfield.text floatValue]];
                }
            }
        }];
    }
}


#pragma mark -商品选中
- (IBAction)selectedButtonClick:(UIButton *)sender {
    
    if (self.returnCellblock) {
        
        self.returnCellblock(_cellindex);
    }
    sender.selected = !sender.selected;
}


#pragma mark -成交价完成修改
- (BOOL)textFieldShouldEndEditing:(UITextField *)textField
{
    Shoppersmanager *user = [Shoppersmanager manager];
    if ([textField.text floatValue] < [user.Shoppers.lowestDiscount floatValue]/100 * [self.model.goods.tagPrice floatValue])
    {
        if (self.promptStringBlock) {
            self.promptStringBlock(@"当前价格低于你的权限范围!");
        }
    }
    else
    {
        //改变价格
        self.productPriceLabe.text = [NSString stringWithFormat:@"￥%.2f",[self.goodsNumbersLabe.text integerValue]*[textField.text floatValue]];
        
        if ([self.delegate respondsToSelector:@selector(ChangeGoodsNumber:WithcostPrice:Withcellindex:returnValue:)]) {
            [self.delegate ChangeGoodsNumber:[self.goodsNumbersLabe.text integerValue] WithcostPrice:[self.clinchTextfield.text floatValue]Withcellindex:_cellindex returnValue:^(id value) {
            }];
        }
    }
    return YES;
}

#pragma mark - <UITextFieldDelegate>
- (BOOL)textField:(UITextField *)textField shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string
{
    NSScanner      *scanner    = [NSScanner scannerWithString:string];
    NSCharacterSet *numbers;
    NSRange        pointRange = [textField.text rangeOfString:@"."];
    if ( (pointRange.length > 0) && (pointRange.location < range.location  || pointRange.location > range.location + range.length) ){
        numbers = [NSCharacterSet characterSetWithCharactersInString:@"0123456789"];
    }else{
        numbers = [NSCharacterSet characterSetWithCharactersInString:@"0123456789."];
    }
    if ( [textField.text isEqualToString:@""] && [string isEqualToString:@"."] ){
        return NO;
    }
    short remain = 2; //保留 number位小数
    NSString *tempStr = [textField.text stringByAppendingString:string];
    NSUInteger strlen = [tempStr length];
    if(pointRange.length > 0 && pointRange.location > 0){ //判断输入框内是否含有“.”。
        if([string isEqualToString:@"."]){ //当输入框内已经含有“.”时，如果再输入“.”则被视为无效。
            return NO;
        }
        if(strlen > 0 && (strlen - pointRange.location) > remain+1){ //当输入框内已经含有“.”，当字符串长度减去小数点前面的字符串长度大于需要要保留的小数点位数，则视当次输入无效。
            return NO;
        }
    }
    NSRange zeroRange = [textField.text rangeOfString:@"0"];
    if(zeroRange.length == 1 && zeroRange.location == 0){ //判断输入框第一个字符是否为“0”
        if(![string isEqualToString:@"0"] && ![string isEqualToString:@"."] && [textField.text length] == 1){ //当输入框只有一个字符并且字符为“0”时，再输入不为“0”或者“.”的字符时，则将此输入替换输入框的这唯一字符。
            textField.text = string;
            return NO;
        }else{
            if(pointRange.length == 0 && pointRange.location > 0){ //当输入框第一个字符为“0”时，并且没有“.”字符时，如果当此输入的字符为“0”，则视当此输入无效。
                if([string isEqualToString:@"0"]){
                    return NO;
                }
            }
        }
    }
    NSString *buffer;
    if ( ![scanner scanCharactersFromSet:numbers intoString:&buffer] && ([string length] != 0) ){
        return NO;
    }else{
        return YES;
    }
}


@end
