//
//  ShoppingViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/4/27.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "ShoppingViewController.h"
#import "ShoppingTableViewCell.h"
#import "AppDelegate.h"
#import "GenerateOrdersViewController.h"
#import "ShopcarModel.h"
#import "AddressModel.h"
#import "ProductDetailsViewController.h"

@interface ShoppingViewController ()<UITableViewDelegate,UITableViewDataSource,ChangeGoodsNumberDelegate,DZNEmptyDataSetSource>


@property (weak, nonatomic) IBOutlet UITableView *shoppingTableview;




/**
 *  购物车数据源
 */
@property (nonatomic,strong) NSMutableArray *shopResponseArray;



@end

@implementation ShoppingViewController


/**
 *  数据源
 */
- (NSMutableArray *)shopResponseArray
{
    if (_shopResponseArray == nil) {
        
        _shopResponseArray = [NSMutableArray array];
    }
    return _shopResponseArray;
}


- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    [self uiConfigAction];
}

#pragma mark -渲染完成
- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    self.navigationController.fd_fullscreenPopGestureRecognizer.enabled = NO;
    if ([self.navigationController respondsToSelector:@selector(interactivePopGestureRecognizer)]) {
        self.navigationController.interactivePopGestureRecognizer.enabled = NO;
    }
    [self.shopResponseArray removeAllObjects];
    [self InitializeState];
    [self getShoppingCardata];
}

#pragma mark -视图即将消失
- (void)viewWillDisappear:(BOOL)animated
{
    [super viewWillDisappear:animated];
    self.navigationController.fd_fullscreenPopGestureRecognizer.enabled = YES;
    if ([self.navigationController respondsToSelector:@selector(interactivePopGestureRecognizer)]) {
        self.navigationController.interactivePopGestureRecognizer.enabled = YES;
    }
}

#pragma mark -初始化状态
- (void)InitializeState
{
    [self.settlementButton setTitle:@"去结算(0)" forState:UIControlStateNormal];
    self.allSelectedButton.selected = NO;
    self.totalpriceLabe.text = nil;
}


#pragma mark - UI
- (void)uiConfigAction
{
    self.settlementButton.layer.masksToBounds = YES;
    self.settlementButton.layer.cornerRadius = kCornerRadius;
    self.view.backgroundColor = kTCColor(238, 238, 238);
    self.shoppingTableview.dataSource = self;
    self.shoppingTableview.delegate = self;
    self.shoppingTableview.backgroundColor = [UIColor clearColor];
    self.shoppingTableview.tableFooterView = [UIView new];
}



#pragma mark -获取购物车商品
- (void)getShoppingCardata
{
    //判断是否需要请求数据-通过当前客户ID
    if (![Shoppersmanager manager].currentCustomer) {
        
        return;
    }
    ShopCartFilter *shopcarNumber = [[ShopCartFilter alloc]init];
    shopcarNumber.consumerId = [Customermanager manager].model.fid;
    DataPage *Newpage = [[DataPage alloc]init];
    Newpage.page = 1;
    Newpage.rows = 99999;
    shopcarNumber.dp = Newpage;
    [self CreateMBProgressHUDLoding];
    WS(weakSelf);
    [[NetworkRequestClassManager Manager] NetworkRequestWithURL:SERVERREQUESTURL(SHOPPINGBAG) WithRequestType:0 WithParameter:shopcarNumber WithReturnValueBlock:^(id returnValue) {
        
        weakSelf.shoppingTableview.emptyDataSetSource = weakSelf;
        [weakSelf endRefreshingForTableView:weakSelf.shoppingTableview];
        [weakSelf RemoveMBProgressHUDLoding];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
  
            ShopCartResponse *shopcar = [[ShopCartResponse alloc]initWithDictionary:returnValue[@"data"] error:nil];
            //自定义属性
            for (TOShopcartEntity *objc in shopcar.shopcart) {
                
                ShopcarModel *model = [[ShopcarModel alloc]init];
                model.goods = objc.goods;
                model.fid = objc.fid;
                model.createName = objc.createName;
                model.createBy = objc.createBy;
                model.createDate = objc.createDate;
                model.updateName = objc.updateName;
                model.updateBy = objc.updateBy;
                model.updateDate = objc.updateDate;
                model.goodsId = objc.goodsId;
                model.goodsNum = objc.goodsNum;
                model.consumerId = objc.consumerId;
                model.costPrice = objc.costPrice;
                [weakSelf.shopResponseArray addObject:model];
            }
            [weakSelf.shoppingTableview reloadData];
        }else
        {
            [weakSelf ErrorMBProgressView:returnValue[@"message"]];
        }
    } WithErrorCodeBlock:^(id errorCodeValue) {
        [weakSelf RemoveMBProgressHUDLoding];
        [weakSelf ErrorMBProgressView:@"无网络"];
    } WithFailureBlock:^(id error) {
        
        [weakSelf RemoveMBProgressHUDLoding];
        [weakSelf endRefreshingForTableView:weakSelf.shoppingTableview];
    }];
}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    ShoppingTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"Shopping" forIndexPath:indexPath];
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    cell.model = [self.shopResponseArray objectAtIndex_opple:indexPath.row];
    cell.delegate = self;
    cell.cellindex = indexPath.row;
    //cell选中回调
    __weak typeof(cell) weakCell = cell;
    WS(weakSelf);
    [cell setReturnCellblock:^(NSInteger index) {
        [weakSelf setSelectedButton:index];
    }];
    //提示框回调
    [cell setPromptStringBlock:^(NSString *string) {
        [weakSelf SHOWPrompttext:string ComcpleteBlock:^{
            [weakCell.clinchTextfield becomeFirstResponder];
        }];
    }];
    return  cell;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.shopResponseArray.count;
}


- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 80;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    ProductDetailsViewController *productDetails = [[self getStoryboardWithName] instantiateViewControllerWithIdentifier:@"productdetails"];
    productDetails.goodsID = [[self.shopResponseArray objectAtIndex_opple:indexPath.row] goodsId];
    [self.navigationController pushViewController:productDetails animated:YES];
}

- (void)tableView:(UITableView *)tableView didDeselectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [self.shoppingTableview deselectRowAtIndexPath:indexPath animated:YES];
}

#pragma mark -选中商品回调
- (void)setSelectedButton:(NSInteger)index;
{
    ShopcarModel *model = [self.shopResponseArray objectAtIndex_opple:index];
    model.isSelected = !model.isSelected;
    
    NSInteger goodsNumber = 0;
    for (ShopcarModel *model in self.shopResponseArray) {
        if (model.isSelected) {
            goodsNumber ++;
        }
    }
    if (goodsNumber == self.shopResponseArray.count) {
        self.allSelectedButton.selected = YES;
    }else
    {
        self.allSelectedButton.selected = NO;
    }
    [self CalculateSelectedGoodsAllprice];
    [self.settlementButton setTitle:[NSString stringWithFormat:@"去结算(%ld)",goodsNumber] forState:UIControlStateNormal];
}


#pragma mark -结算
- (IBAction)settlementButtonClick:(UIButton *)sender {
    
    NSMutableArray *array = [NSMutableArray array];
    for (ShopcarModel *model in self.shopResponseArray) {
        if (model.isSelected) {
            [array addObject:model];
        }
    }
    if (array.count == 0) {
        
        [self ErrorMBProgressView:@"没有选中任何商品"];
        return;
    }
    //商品总信息占位
     ShopcarModel*ZhanweiModel = [[ShopcarModel alloc]init];
    [array addObject:ZhanweiModel];
    
    GenerateOrdersViewController *generateOrder = [[self getStoryboardWithName] instantiateViewControllerWithIdentifier:@"generateorders"];
    generateOrder.settlementGoodsdatas = array;
    //清除已经生成订单的商品
    [generateOrder setDelecteSelectedGoods:^(NSArray *goodsCode) {
        
        DeleteCartRequest *delecteGoods = [[DeleteCartRequest alloc]init];
        delecteGoods.cartIds = goodsCode;
        WS(weakSelf);
        [[NetworkRequestClassManager Manager] NetworkRequestWithURL:SERVERREQUESTURL(REMOVESHOPPINGBAG) WithRequestType:0 WithParameter:delecteGoods WithReturnValueBlock:^(id returnValue) {
            
            [weakSelf RemoveMBProgressHUDLoding];
            if ([returnValue[@"code"] isEqualToNumber:@0]) {
                
                [weakSelf QueryShoppingCarNumber];
                //商品cell
                NSMutableArray *cellArray = [NSMutableArray array];
                //删除商品
                for (int i=0; i<weakSelf.shopResponseArray.count; i++) {
                    ShopcarModel *model = [weakSelf.shopResponseArray objectAtIndex_opple:i];
                    if ([goodsCode containsObject:model.fid]) {
                        [weakSelf.shopResponseArray removeObject:model];
                        NSIndexPath *indexpath = [NSIndexPath indexPathForRow:i inSection:0];
                        [cellArray addObject:indexpath];
                    }
                }
                //删除cell
                [weakSelf.shoppingTableview deleteRowsAtIndexPaths:cellArray withRowAnimation:UITableViewRowAnimationTop];
            }else
            {
                [weakSelf ErrorMBProgressView:returnValue[@"message"]];
            }
            
        } WithErrorCodeBlock:^(id errorCodeValue) {
            [weakSelf RemoveMBProgressHUDLoding];
            [weakSelf ErrorMBProgressView:@"无网络"];
            
        } WithFailureBlock:^(id error) {
            
            [weakSelf RemoveMBProgressHUDLoding];
        }];
    }];
    
    [self.navigationController pushViewController:generateOrder animated:YES];
}

#pragma mark -全选
- (IBAction)allSelectedButtonClick:(UIButton *)sender {
    
    sender.selected = !sender.selected;
    if (sender.selected) {
        
        //全部选中
        for (ShoppingTableViewCell *cell in self.shoppingTableview.visibleCells) {
            
            cell.selectedButton.selected = YES;
        }
        for (ShopcarModel *model in self.shopResponseArray) {
            
            model.isSelected = YES;
        }
        [self.settlementButton setTitle:[NSString stringWithFormat:@"去结算(%ld)",self.shopResponseArray.count] forState:UIControlStateNormal];

    }else
    {
        //取消全部选中
        for (ShoppingTableViewCell *cell in self.shoppingTableview.visibleCells) {
            
            cell.selectedButton.selected = NO;
        }
        for (ShopcarModel *model in self.shopResponseArray) {
            
            model.isSelected = NO;
        }
        [self.settlementButton setTitle:@"去结算(0)" forState:UIControlStateNormal];
    }
    //计算总金额
    [self CalculateSelectedGoodsAllprice];
}

#pragma mark -计算选中后的商品总金额
- (void)CalculateSelectedGoodsAllprice
{
    CGFloat allPrice = 0;
    for (ShopcarModel *model in self.shopResponseArray) {
        if (model.isSelected) {
            allPrice += ([model.costPrice floatValue]?[model.costPrice floatValue]:[model.goods.tagPrice floatValue]) * model.goodsNum;
        }
    }
    self.totalpriceLabe.text = [NSString stringWithFormat:@"￥%.2f",allPrice];
}


#pragma mark -删除选中商品
- (IBAction)delecteSelectedGoods:(UIButton *)sender {

    
    [self CreateMBProgressHUDLoding];
    DeleteCartRequest *delecteGoods = [[DeleteCartRequest alloc]init];
    //code数组
    NSMutableArray *codeArr = [NSMutableArray array];
    //需要删除的cell数组indexpath
    NSMutableArray *delecteArray = [NSMutableArray array];
    //模型数组
    NSMutableArray *delectemodel = [NSMutableArray array];
    for (int i=0; i<self.shopResponseArray.count; i++) {
        
        ShopcarModel *model = [self.shopResponseArray objectAtIndex_opple:i];
        if (model.isSelected) {
            
            [codeArr addObject:model.fid];
            [delectemodel addObject:model];
            NSIndexPath *indexpath = [NSIndexPath indexPathForRow:i inSection:0];
            [delecteArray addObject:indexpath];
        }
    }
    //没有选中任何商品
    if (codeArr.count == 0) {
        [self RemoveMBProgressHUDLoding];
        [self SHOWPrompttext:@"未选中商品"];
        return;
    }
    delecteGoods.cartIds = codeArr;
    WS(weakSelf);
    [[NetworkRequestClassManager Manager] NetworkRequestWithURL:SERVERREQUESTURL(REMOVESHOPPINGBAG) WithRequestType:0 WithParameter:delecteGoods WithReturnValueBlock:^(id returnValue) {
        
        [weakSelf RemoveMBProgressHUDLoding];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            
            [weakSelf QueryShoppingCarNumber];
            //删除商品
            for (ShopcarModel *model in delectemodel) {
                [weakSelf.shopResponseArray removeObject:model];
            }
            [weakSelf.shoppingTableview deleteRowsAtIndexPaths:delecteArray withRowAnimation:UITableViewRowAnimationLeft];
            dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(1 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
                [weakSelf.shoppingTableview reloadData];
            });
            [weakSelf SuccessMBProgressView:@"删除成功"];
            [weakSelf CalculateSelectedGoodsAllprice];
            weakSelf.allSelectedButton.selected = NO;
            [weakSelf.settlementButton setTitle:@"去结算(0)" forState:UIControlStateNormal];
        }else
        {
            [weakSelf ErrorMBProgressView:returnValue[@"message"]];
        }

    } WithErrorCodeBlock:^(id errorCodeValue) {
        [weakSelf RemoveMBProgressHUDLoding];
        [weakSelf ErrorMBProgressView:@"无网络"];
        
    } WithFailureBlock:^(id error) {
        
        [weakSelf RemoveMBProgressHUDLoding];
    }];
}



#pragma mark -改变商品数量
- (void)ChangeGoodsNumber:(NSInteger)goodsNumber WithcostPrice:(CGFloat)costprice Withcellindex:(NSInteger)cellindex returnValue:(void (^)(id))result
{
    [self CreateMBProgressHUDLoding];
    //保存商品数量
    ShopcarModel *model = [self.shopResponseArray objectAtIndex_opple:cellindex];
    model.goodsNum = goodsNumber;
    //保存成交价格
    ShopcarModel *Newmodel = [self.shopResponseArray objectAtIndex_opple:cellindex];
    Newmodel.costPrice = [NSNumber numberWithFloat:costprice];
    //在服务器保存数量、成交价
    //购物车ID
    NSString *carid = [[self.shopResponseArray objectAtIndex_opple:cellindex] fid];
    //商品id
    NSString *goodsis = [[[self.shopResponseArray objectAtIndex_opple:cellindex] goods] fid];
    //成交价
    NSString *costpriceString = [NSString stringWithFormat:@"%.2f",costprice];
    //商品数量
    NSString *goodsNumberString = [NSString stringWithFormat:@"%ld",(long)goodsNumber];
    WS(weakSelf);
    [[NetworkRequestClassManager Manager] NetworkWithDictionaryRequestWithURL:[NSString stringWithFormat:@"%@%@/%@/%@/%@",SERVERREQUESTURL(CHANGESHOPPINGBAGNUMBERPRICE),carid,goodsis,costpriceString,goodsNumberString] WithRequestType:1 WithParameter:nil WithReturnValueBlock:^(id returnValue) {
        
        [weakSelf RemoveMBProgressHUDLoding];
        result(returnValue);//提供是否支持修改的参数
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            NSLog(@"写入服务器成功");
            [weakSelf CalculateSelectedGoodsAllprice];
            [weakSelf QueryShoppingCarNumber];
        }else{
            
            [weakSelf ErrorMBProgressView:returnValue[@"message"]];
        }
        
    } WithErrorCodeBlock:^(id errorCodeValue) {
        [weakSelf RemoveMBProgressHUDLoding];
        [weakSelf ErrorMBProgressView:@"无网络"];
        
    } WithFailureBlock:^(id error) {
        NSLog(@"写入服务器失败");
        [weakSelf RemoveMBProgressHUDLoding];
    }];
}


#pragma mark -友好界面
- (UIImage *)imageForEmptyDataSet:(UIScrollView *)scrollView
{
    return kNoDataImage;
    
}


- (NSAttributedString *)titleForEmptyDataSet:(UIScrollView *)scrollView
{
    return [[NSAttributedString alloc]initWithString:@"暂无数据" attributes:nil];
}


@end
