//
//  WithdrawalTableViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/8/28.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "WithdrawalTableViewController.h"

@interface WithdrawalTableViewController ()

@end

@implementation WithdrawalTableViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self uiConfigAction];
    [self fillDataAction];
}

#pragma mark - UI
- (void)uiConfigAction
{
    self.tableView.tableFooterView = [UIView new];
}

#pragma mark - 填充数据
- (void)fillDataAction
{
    BOOL boolValue = [self.model.billStates isEqualToString:@"到账成功"];
    self.progressImageView.image = boolValue?TCImage(@"finish"):TCImage(@"progress");
    self.appleCompleteTimeLabel.hidden = !boolValue;
    self.appleCompleteTimeLabel.textColor = [self setupLabelColor:self.model.billStates];
    self.appleCompleteTimeLabel.text =  self.model.updateDate;
    self.submitApplyTimeLabel.text = self.model.createDate;
    self.orderTimeLabel.text = self.model.createDate;
    self.orderBillNumberLabel.text = self.model.billNumber;
    self.amountLabel.text = [self.model.applyMoney stringValue];
}


#pragma mark - 设置字体颜色
- (UIColor *)setupLabelColor:(NSString *)text
{
    if ([text isEqualToString:@"到账成功"]) {
        return RGB(89, 172, 220, 1);
    }
    if ([text isEqualToString:@"申请已提交"]) {
        return RGB(128, 189, 51, 1);
    }
    return nil;
}








@end
