//
//  ProductLibraryViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/4.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "ProductLibraryViewController.h"
#import "ProductCollectionViewCell.h"
#import "ProductDetailsViewController.h"
#import "ScreeningView.h"
#import "screeningFirstView.h"
#import "screeningSecondView.h"


@interface ProductLibraryViewController ()<UICollectionViewDelegate,UICollectionViewDataSource,UIGestureRecognizerDelegate>

/**
 *  筛选背景框View
 */
@property (nonatomic,strong) ScreeningView *screenView;


/**
 *  分类View
 */
@property (nonatomic,strong) screeningFirstView *screenFirstView;

/**
 *  筛选View
 */
@property (nonatomic,strong) screeningSecondView *screenSecondView;

@end

@implementation ProductLibraryViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.view.backgroundColor = [UIColor blueColor];
    
    [self uiConfigAction];
    [self getScreeningdatas];
    
}


#pragma mark -获取筛选数据
- (void)getScreeningdatas
{
    
}







#pragma mark -布局
- (void)uiConfigAction
{
    self.productCollectionLayout.itemSize = CGSizeMake((ScreenWidth-100)/3, (ScreenWidth-100)/3);
    self.productCollectionLayout.sectionInset = UIEdgeInsetsMake(20, 30, 20, 30);
    self.productCollectionLayout.minimumLineSpacing = 20;
    self.productCollectionLayout.minimumInteritemSpacing = 20;
    self.productCollectionView.dataSource = self;
    self.productCollectionView.delegate = self;
    
    [self CreatescreeningButton];
}



#pragma mark -筛选按钮
- (void)CreatescreeningButton
{
    UIButton *screeningbutton = [UIButton buttonWithType:UIButtonTypeSystem];
    screeningbutton.frame = CGRectMake(ScreenWidth-100, ScreenHeight*6/10, 50, 50);
    
    //阴影层
    CALayer *layer = [CALayer layer];
    layer.frame = CGRectMake(ScreenWidth-97.5, ScreenHeight*6/10+2.5, 45, 45);//保证layer的size比筛选按钮高宽都短5像素
    layer.backgroundColor = [UIColor blackColor].CGColor;
    layer.shadowOffset = CGSizeMake(0, 8);
    layer.shadowOpacity = 0.7;
    layer.cornerRadius = 25;
    [self.view.layer addSublayer:layer];
    
    //筛选按钮
    screeningbutton.layer.masksToBounds = YES;
    screeningbutton.layer.cornerRadius = 25;
    [screeningbutton setTitle:@"筛选" forState:UIControlStateNormal];
    screeningbutton.titleLabel.font = [UIFont systemFontOfSize:15];
    [screeningbutton setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    [screeningbutton setTitleColor:kMainBlueColor forState:UIControlStateSelected];
    [screeningbutton addTarget:self action:@selector(ScreeningButtonClick) forControlEvents:UIControlEventTouchUpInside];
    screeningbutton.backgroundColor = kMainBlueColor;
    [self.view addSubview:screeningbutton];
    
}


- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    ProductCollectionViewCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:@"productcell" forIndexPath:indexPath];
    
    return cell;
}

- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    return 20;
}

- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    
    UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"StoryboardwithCYX" bundle:nil];
    ProductDetailsViewController *productDetails = [storyboard instantiateViewControllerWithIdentifier:@"productdetails"];
    [self.navigationController pushViewController:productDetails animated:YES];
}



#pragma mark -筛选
- (void)ScreeningButtonClick
{
    self.screenView = [[[NSBundle mainBundle] loadNibNamed:@"ScreeningView" owner:self options:nil]firstObject];
    self.screenView.frame = CGRectMake(0, 0, ScreenWidth, ScreenHeight);
    self.screenView.backgroundColor = [[UIColor blackColor] colorWithAlphaComponent:0.5];
    
    
    
    //点击手势
    UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(DismissScreenView)];
    tap.delegate = self;
    tap.cancelsTouchesInView = NO;
    [self.screenView addGestureRecognizer:tap];
    self.screenView.frame = CGRectMake(0, 0, ScreenWidth, ScreenHeight);
    [self.view.window addSubview:self.screenView];
    self.screenView.alpha = 0;
    
    //监听Segmented菜单
    [self.screenView.sortingSegmented addTarget:self action:@selector(sortingSegmentedClick:) forControlEvents:UIControlEventValueChanged];
    
    [self CreateClassificationView];
    
    [UIView animateWithDuration:0.2 animations:^{
        
        self.screenView.alpha = 1;
        
    }];
}






#pragma mark -分类、筛选view切换
- (void)sortingSegmentedClick:(UISegmentedControl *)sender {
    
    switch (sender.selectedSegmentIndex) {
        case 0://分类
        {
            NSLog(@"分类");
            [self.screenSecondView removeFromSuperview];
            [self CreateClassificationView];
        }
            break;
        case 1://筛选
        {
            NSLog(@"筛选");
            [self.screenFirstView removeFromSuperview];
            [self CreateScreenSubView];
        }
            break;
            
        default:
            break;
    }
}




#pragma mark -创建分类View
- (void)CreateClassificationView
{
    //分类View
    self.screenFirstView = [[[NSBundle mainBundle] loadNibNamed:@"screeningFirstView" owner:self options:nil] firstObject];
    self.screenFirstView.frame = CGRectMake(0, 50, 470, 310);
    [self.screenView.backgroundView addSubview:self.screenFirstView];
}


#pragma mark -创建筛选选项View
- (void)CreateScreenSubView
{
    self.screenSecondView = [[[NSBundle mainBundle] loadNibNamed:@"screeningSecondView" owner:self options:nil] firstObject];
    self.screenSecondView.frame = CGRectMake(0, 50, 470, 310);
    [self.screenView.backgroundView addSubview:self.screenSecondView];
}

#pragma mark -移除筛选框
- (void)DismissScreenView
{
    [UIView animateWithDuration:0.2 animations:^{
        
        self.screenView.alpha = 0;
        
    }completion:^(BOOL finished) {
        
        [self.screenView removeFromSuperview];
        
    }];
}

#pragma mark -UIGestureRecognizerDelegate代理方法
- (BOOL)gestureRecognizer:(UIGestureRecognizer *)gestureRecognizer shouldReceiveTouch:(UITouch *)touch
{
    //取消子视图的的时间穿透，否则子视图的点击无效，会被传递到父视图响应
    if (CGRectContainsPoint(self.screenView.backgroundView.frame, [touch locationInView:self.screenView])) {
        
        return NO;
    }
    return YES;
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
