//
//  PopoverViewController.m
//  Lighting
//
//  Created by 曹云霄 on 16/5/9.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "PopoverViewController.h"

@interface PopoverViewController ()<UITableViewDelegate,UITableViewDataSource>

@property (nonatomic,strong) UITableView *popoverTableView;

@end

@implementation PopoverViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self uiConfigAction];
}


#pragma mark -UI
- (void)uiConfigAction
{
    self.popoverTableView = [[UITableView alloc]initWithFrame:CGRectMake(0, 0, self.contentSize.width, self.contentSize.height) style:UITableViewStylePlain];
    self.popoverTableView.dataSource = self;
    self.popoverTableView.delegate = self;
    self.popoverTableView.tableFooterView = [UIView new];
    [self.view addSubview:self.popoverTableView];
    [self.popoverTableView registerClass:[UITableViewCell class] forCellReuseIdentifier:@"popovercell"];
}


#pragma mark - UITableViewDataSource
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"popovercell" forIndexPath:indexPath];
    cell.textLabel.text = [self.datasArray objectAtIndex_opple:indexPath.row];
    cell.textLabel.textAlignment = NSTextAlignmentCenter;
    return cell;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.datasArray.count;
}


- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    
    if ([self.delegate respondsToSelector:@selector(returnCellindexpathwithrow:)]) {
        
        [self.delegate returnCellindexpathwithrow:indexPath.row];
    }
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


@end
