//
//  BaseViewController.h
//  Palmwms
//
//  Created by 曹云霄 on 16/8/24.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import <UIKit/UIKit.h>



@interface BaseViewController : UIViewController




/**
 *  自定义返回按钮
 *
 *  @param backButtonClick 调用方法
 */
- (void)customBackButton:(SEL)backButtonClick;


/**
 *  保存账号密码
 *
 *  @param account  账号
 *  @param passWord 密码
 */
+ (void)saveAccountAndPassWord:(NSString *)account AndPassword:(NSString *)passWord;

/**
 *  注销删除账号密码
 */
+ (void)deleteAccountAndPassWord;

/**
 *  SheetView确认框
 */
- (void)showSheetViewWithMessage:(NSString *)message complete:(void(^)())finish;

/**
 *  下载离线地图
 */
- (void)downLoadLocationCityMaps;

#pragma mark -获取当前时间之前或之后的时间
- (NSString *)getTimeby:(NSInteger)day;


- (void)CreateMBProgressHUDLoding:(NSString *)text;
- (void)RemoveMBProgressHUDLoding;
- (void)SuccessMBProgressView:(NSString *)successString timeDelay:(NSTimeInterval)time finish:(void(^)())complete;
- (void)ErrorMBProgressView:(NSString *)errorString;
- (void)ShowProgressView:(double)progress withTitle:(NSString *)message;
- (void)SHOWPrompttext:(NSString *)Text;
- (void)SHOWPrompttext:(NSString *)Text ComcpleteBlock:(void(^)())completed;
- (void)endRefreshingForTableView:(UIScrollView *)TableView;
- (UIStoryboard *)getStoryboardWithName;


@end
