//
//  NaviManager.m
//  Palmwms
//
//  Created by 曹云霄 on 2016/10/14.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "NaviManager.h"

@implementation NaviManager


+ (instancetype)manager
{
    static NaviManager *navi = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        navi = [[NaviManager alloc]init];
    });
    return navi;
}

#pragma mark - 规划路线
- (void)planningRouteBeforeStartNaviEndNodePoint:(CLLocationCoordinate2D)end
{
    if ([BNCoreServices_Instance isServicesInited]) {
        NSMutableArray *nodesArray = [[NSMutableArray alloc] initWithCapacity:2];
         CLLocation *myLocation = [BNCoreServices_Location getLastLocation];
        //起点
        BNRoutePlanNode *startNode = [[BNRoutePlanNode alloc] init];
        startNode.pos = [[BNPosition alloc] init];
        startNode.pos.x = myLocation.coordinate.longitude;
        startNode.pos.y = myLocation.coordinate.latitude;
        startNode.pos.eType = BNCoordinate_OriginalGPS;
        [nodesArray addObject:startNode];
        //终点
        BNRoutePlanNode *endNode = [[BNRoutePlanNode alloc] init];
        endNode.pos = [[BNPosition alloc] init];
        endNode.pos.x = end.longitude;
        endNode.pos.y = end.latitude;
        endNode.pos.eType = BNCoordinate_BaiduMapSDK;
        [nodesArray addObject:endNode];
        [BNCoreServices_Strategy setDayNightType:BNDayNight_CFG_Type_Auto];
        [BNCoreServices_RoutePlan startNaviRoutePlan:BNRoutePlanMode_Recommend naviNodes:nodesArray time:nil delegete:self userInfo:nil];
    }else
    {
        [self initializeFailed];
    }
}

#pragma mark - BNNaviRoutePlanDelegate
#pragma mark -路线规划成功
-(void)routePlanDidFinished:(NSDictionary *)userInfo
{
    [BNCoreServices_UI showPage:BNaviUI_NormalNavi delegate:self extParams:nil];
}

#pragma mark - 路径规划失败
- (void)routePlanDidFailedWithError:(NSError *)error andUserInfo:(NSDictionary*)userInfo
{
    if ([self.delegate respondsToSelector:@selector(pathPlanningFailure:)]) {
        switch ([error code]%10000)
        {
            case BNAVI_ROUTEPLAN_ERROR_LOCATIONFAILED:
                [self.delegate pathPlanningFailure:@"暂时无法获取您的位置,请稍后重试"];
                break;
            case BNAVI_ROUTEPLAN_ERROR_ROUTEPLANFAILED:
                [self.delegate pathPlanningFailure:@"无法发起导航"];
                break;
            case BNAVI_ROUTEPLAN_ERROR_LOCATIONSERVICECLOSED:
                [self.delegate pathPlanningFailure:@"定位服务未开启,请到系统设置中打开定位服务。"];
                break;
            case BNAVI_ROUTEPLAN_ERROR_NODESTOONEAR:
                [self.delegate pathPlanningFailure:@"起终点距离起终点太近"];
                break;
            default:
                [self.delegate pathPlanningFailure:@"暂时无法获取您的位置,请稍后重试"];
                break;
        }
    }
}

#pragma mark - 退出导航页面回调
- (void)onExitPage:(BNaviUIType)pageType  extraInfo:(NSDictionary*)extraInfo
{
    if (pageType == BNaviUI_NormalNavi)
    {
        if ([self.delegate respondsToSelector:@selector(exitNaviCallback)]) {
            [self.delegate exitNaviCallback];
        }
    }
}

#pragma mark - 导航服务启动失败
- (void)initializeFailed;
{
    if ([self.delegate respondsToSelector:@selector(servicesFailedToInitialize)]) {
        [self.delegate servicesFailedToInitialize];
    }
}


@end
