//
//  LoginViewController.m
//  Palmwms
//
//  Created by 曹云霄 on 16/8/24.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "LoginViewController.h"
#import "MainViewController.h"
@interface LoginViewController ()<UITextFieldDelegate>

@end

@implementation LoginViewController

- (void)viewWillAppear:(BOOL)animated
{
    //取出账户密码
    self.userNameTextField.text = [SSKeychain passwordForService:SERVICENAME account:SAVEACCOUNT];
    self.passWordTextField.text = [SSKeychain passwordForService:SERVICENAME account:SAVEPASSWORD];
    [self changeColor:[UITextField new]];
    if ([self.userNameTextField.text length]) {
        [self changeColor:self.userNameTextField];
    }
    if ([self.passWordTextField.text length]) {
        [self changeColor:self.passWordTextField];
    }
    self.versionInformation.text = [self getAppVersion];
}


- (NSString*)getAppVersion {
    NSString *ver = [[[NSBundle mainBundle] infoDictionary]
                     objectForKey:@"CFBundleShortVersionString"];
    return [NSString stringWithFormat:@"版本%@",ver];
}


- (void)viewWillDisappear:(BOOL)animated
{
    [UIApplication sharedApplication].statusBarHidden = NO;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self uiConfigAction];
}

#pragma mark - UI
- (void)uiConfigAction
{
    [self.loginButton addCorners];
    [self.userNameTextField addTarget:self action:@selector(userNameTextFieldInput:) forControlEvents:UIControlEventEditingDidBegin | UIControlEventEditingChanged];
    [self.passWordTextField addTarget:self action:@selector(userNameTextFieldInput:) forControlEvents:UIControlEventEditingDidBegin | UIControlEventEditingChanged];
    [self.loginButton addTarget:self action:@selector(loginButtonClickAction:) forControlEvents:UIControlEventTouchUpInside];

}


#pragma mark - 检测实时输入
- (void)userNameTextFieldInput:(UITextField *)textField
{
    [self changeColor:textField];
}

#pragma mark - 改变颜色
- (void)changeColor:(UITextField *)textField
{
    BOOL boolValueOne = [self.userNameTextField.text length];
    boolValueOne?NO:(boolValueOne = [textField isEqual:self.userNameTextField]);
    BOOL boolValueTwo = [self.passWordTextField.text length];
    boolValueTwo?NO:(boolValueTwo = [textField isEqual:self.passWordTextField]);
    self.userNameLine.backgroundColor = boolValueOne?MainColor:[UIColor lightGrayColor];
    self.userNameTitle.textColor = boolValueOne?MainColor:[UIColor lightGrayColor];
    self.passWordLine.backgroundColor = boolValueTwo?MainColor:[UIColor lightGrayColor];
    self.passwordTitle.textColor = boolValueTwo?MainColor:[UIColor lightGrayColor];
    if (boolValueOne && boolValueTwo && [self.passWordTextField.text length] && [self.userNameTextField.text length]) {
        self.loginButton.backgroundColor = MainColor;
        self.loginButton.enabled = YES;
    }else
    {
        self.loginButton.backgroundColor = [UIColor lightGrayColor];
        self.loginButton.enabled = NO;
    }
}

#pragma mark - <UITextFieldDelegate>
- (void)textFieldDidEndEditing:(UITextField *)textField
{
    [self changeColor:[UITextField new]];
}

#pragma mark - 确认登陆
- (void)loginButtonClickAction:(UIButton *)sender
{
    [self CreateMBProgressHUDLoding:@"登录中"];
    NSDictionary *dict = [NSDictionary dictionaryWithObjectsAndKeys:self.userNameTextField.text,@"username",self.passWordTextField.text,@"password", nil];
    WS(weakSelf);
    [[NetworkRequestClassManager Manager] NetworkWithDictionaryRequestWithURL:SERVERREQUESTURL(LOGIN) WithRequestType:0 WithParameter:dict WithReturnValueBlock:^(id returnValue) {
        
        [weakSelf RemoveMBProgressHUDLoding];
        if ([returnValue[@"code"] isEqualToNumber:@0]) {
            NSDictionary *driver = returnValue[@"data"][@"driver"];
            UserInforMation *user = [UserInforMation manager];
            user.userName = driver[@"name"];
            user.userCode = driver[@"code"];
            user.userUUid = driver[@"id"];
            [[weakSelf class] saveAccountAndPassWord:self.userNameTextField.text AndPassword:self.passWordTextField.text];
            [weakSelf SuccessMBProgressView:@"登录成功" timeDelay:1.0f finish:^{
                [weakSelf enterTheMainController];
            }];
        }else
        {
            [weakSelf SHOWPrompttext:returnValue[@"message"]];
        }
        
    } WithErrorCodeBlock:^(id errorCodeValue) {
        [weakSelf RemoveMBProgressHUDLoding];
        [weakSelf SHOWPrompttext:NETWORK];
    } WithFailureBlock:^(NSError *error) {
        [weakSelf RemoveMBProgressHUDLoding];
        [weakSelf SHOWPrompttext:error.localizedDescription];
    }];
}


#pragma mark - 进入主页面
- (void)enterTheMainController
{
    MainViewController *CoordinateVC = [self.getStoryboardWithName instantiateViewControllerWithIdentifier:@"MainViewController"];
    CoordinateVC.modalTransitionStyle = UIModalTransitionStyleFlipHorizontal;
    UINavigationController *CoordinateNav = [[UINavigationController alloc]initWithRootViewController:CoordinateVC];
    [self presentViewController:CoordinateNav animated:YES completion:nil];
}








@end
