//
//  MainViewController.m
//  Palmwms
//
//  Created by 曹云霄 on 16/8/25.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "MainViewController.h"
#import "CoordinateAcquisitionViewController.h"
#import "DeliveryTrackingViewController.h"


@interface MainViewController ()

/**
 *  当前控制器
 */
@property (nonatomic,strong) BaseViewController *currentVC;


@property (nonatomic,strong) CoordinateAcquisitionViewController *coordinateVC;
@property (nonatomic,strong) DeliveryTrackingViewController *DeliveryVC;


/**
 * UISegmentedControl
 */
@property (weak, nonatomic) IBOutlet UISegmentedControl *segmentControl;


@end

@implementation MainViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setupController];
}

#pragma mark - 设置控制器
- (void)setupController
{
    _coordinateVC = [self.getStoryboardWithName instantiateViewControllerWithIdentifier:@"CoordinateAcquisitionViewController"];
    [self addChildViewController:_coordinateVC];
    _DeliveryVC = [self.getStoryboardWithName instantiateViewControllerWithIdentifier:@"DeliveryTrackingViewController"];
    [self addChildViewController:_DeliveryVC];
    [self.view addSubview:_coordinateVC.view];
    self.currentVC = self.coordinateVC;
}


#pragma mark - 切换内容控制器
- (void)changeViewControllerWithNewController:(BaseViewController *)newController
{
    [self transitionFromViewController:self.currentVC toViewController:newController duration:0.3 options:UIViewAnimationOptionTransitionNone animations:nil completion:^(BOOL finished) {
        if (finished) {
            [self.view addSubview:newController.view];
            self.currentVC = newController;
        }
    }];
}


- (IBAction)UISegmentedControlClickAction:(UISegmentedControl *)sender {
    
    if (sender.selectedSegmentIndex) {
        //送货跟踪
        [self changeViewControllerWithNewController:self.DeliveryVC];
    }
    else
    {   //坐标采集
        [self changeViewControllerWithNewController:self.coordinateVC];
    }
}



@end
