//
//  OrderListViewController.m
//  Palmwms
//
//  Created by 曹云霄 on 16/9/13.
//  Copyright © 2016年 上海勾芒科技有限公司. All rights reserved.
//

#import "OrderListViewController.h"
#import "OrderListTableViewCell.h"

#define FINISH @"已完成"

@interface OrderListViewController ()<UITableViewDataSource,UITableViewDelegate>

@end

@implementation OrderListViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.orderTableView.tableFooterView = [UIView new];
    [self uiConfigAction];
}

#pragma mark - UI
- (void)uiConfigAction
{
    NSInteger index = 0;
    for (Busbill *model in self.datasArray) {
        if ([model.state isEqualToString:FINISH]) {
            index ++;
        }
    }
    NSString *indexString = [NSString stringWithFormat:@"%ld",index?index:1];
    NSString *totalCount = [NSString stringWithFormat:@"%ld",self.datasArray.count];
    NSMutableAttributedString *attributedString = [[NSMutableAttributedString alloc]initWithString:[NSString stringWithFormat:@"今日订单%ld,已完成订单%ld",self.datasArray.count,index]];
    [attributedString addAttribute:NSForegroundColorAttributeName value:[UIColor blackColor] range:NSMakeRange(attributedString.length-([indexString length] + 6 + totalCount.length), totalCount.length)];
    [attributedString addAttribute:NSForegroundColorAttributeName value:[UIColor greenColor] range:NSMakeRange(attributedString.length-[indexString length], [indexString length])];
    self.orderTitleLabel.attributedText = attributedString;
    //选中状态
    [self.orderTableView selectRowAtIndexPath:self.indexPath animated:NO scrollPosition:UITableViewScrollPositionNone];
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    OrderListTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"OrderListTableViewCell" forIndexPath:indexPath];
    Busbill *model = self.datasArray[indexPath.row];
    cell.orderBillStateLabel.text = model.state;
    cell.orderBillStateLabel.textColor = [self returnColorFromOrderBillState:model.state];
    cell.orderTitleLabel.text = [NSString stringWithFormat:@"单号:%@",model.billNumber];
    
    return cell;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.datasArray.count;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 50;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (self.SelectOrderClickBlock) {
        self.SelectOrderClickBlock(self.datasArray[indexPath.row],indexPath);
    }
}

#pragma mark - 关闭
- (IBAction)turnoffButtonClickAction:(UIButton *)sender {
    
    if (self.ReturnoffButtonClickBlock) {
        self.ReturnoffButtonClickBlock();
    }
}


#pragma mark - 通过状态返回不同的颜色
- (UIColor *)returnColorFromOrderBillState:(NSString *)state
{
    UIColor *color = nil;
    if ([state isEqualToString:@"已完成"]) {
        color = [UIColor greenColor];
    }else if ([state isEqualToString:@"送货中"]){
        color = MainColor;
    }else if ([state isEqualToString:@"未出货"])
    {
        color = [UIColor redColor];
    }
    return color;
}










@end
