//
//  AnnoDetailViewController.m
//  redstar
//
//  Created by admin on 15/11/30.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "AnnoDetailViewController.h"
#import "AnnounceDetailHeadView.h"
#import "AnnoContentTableViewCell.h"
#import "AnnounceDetailFootView.h"

#import "HttpClient.h"

#import "AnnounceDetailModel.h"

#define kAnnounceContentCell @"AnnoContentTableViewCell"

@interface AnnoDetailViewController ()<UITableViewDataSource, UITableViewDelegate>

@property (nonatomic, strong) UITableView *tableView;
@property (nonatomic, strong) AnnounceDetailHeadView *headerView;
@property (nonatomic, strong) AnnounceDetailFootView *footerView;
@property (nonatomic, strong) AnnounceDetailModel *annoDetail;
@end

@implementation AnnoDetailViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
    
    [self setNav];
    
    [self requestAnnoDetail];
    
    [self settingYetRead];
}

- (void)requestAnnoDetail
{
    NSString *url = [NSString stringWithFormat:@"%@%@%@", kRedStarURL, kAnnounceDetailURL, self.affiche_uuid];
    HttpClient *httpCilent = [[HttpClient alloc] initWithUrl:url];
    [httpCilent getAnnounceDetailWithCompletion:^(id response, NSError *error) {
        NSLog(@"anno详情 = %@", response);
        NSDictionary *dict = response[@"data"];
        AnnounceDetailModel *annoDetail = [AnnounceDetailModel announceDetailModelWithDict:dict];
        _annoDetail = annoDetail;
        
        self.tableView.delegate = self;
        self.tableView.dataSource = self;
    }];
}

- (void)settingYetRead
{
    NSString *user_uuid = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_uuid"];
    
    NSDate *date = [NSDate date];
    NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
    [dateFormatter setDateFormat:@"YYYY-MM-dd hh:mm:ss"];
    NSString *dateString = [dateFormatter stringFromDate:date];
    NSString *url = [NSString stringWithFormat:@"%@%@%@?user_uuid=%@&read_time=%@", kRedStarURL, kAnnounceYetReadURL, self.affiche_uuid, user_uuid, dateString];
    url = [url stringByAddingPercentEscapesUsingEncoding: NSUTF8StringEncoding];

    HttpClient *httpCilent = [[HttpClient alloc] initWithUrl:url];
    NSLog(@"uuurl = %@", url);
    [httpCilent settingAnnounceYetReadWithCompletion:^(id response, NSError *error) {
        NSLog(@"已读 response = %@", response);
    }];
}

// 返回上一页面
- (void)doBack:(UIBarButtonItem *)sender
{
    [self.navigationController popViewControllerAnimated:YES];
}

- (void)setNav
{
    UILabel *customLab = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 40, 30)];
    [customLab setTextColor:[UIColor whiteColor]];
    [customLab setText:@"公告"];
    customLab.font = [UIFont boldSystemFontOfSize:19];
    self.navigationItem.titleView = customLab;
    
    UIButton *backBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    backBtn.frame = CGRectMake(0, 0, 30, 44);
    [backBtn setImage:[UIImage imageNamed:@"back_btn"] forState:UIControlStateNormal];
    [backBtn addTarget:self action:@selector(doBack:) forControlEvents:UIControlEventTouchUpInside];
    UIBarButtonItem *backItem = [[UIBarButtonItem alloc] initWithCustomView:backBtn];
    self.navigationItem.leftBarButtonItem = backItem;
    
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - UITableView Delegate/DataSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 1;
}

// cell显示的内容
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    
    AnnoContentTableViewCell *cell=[tableView dequeueReusableCellWithIdentifier:kAnnounceContentCell];
    if (!cell) {
        cell = [[AnnoContentTableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kAnnounceContentCell];
    }
    cell.titleLabel.text = @"内容";
    
    NSString *str = [NSString stringWithFormat:@"<style> html{ font-size: 15px; color: #444444 } </style>%@", _annoDetail.content];
    NSAttributedString * attrStr = [[NSAttributedString alloc] initWithData:[str dataUsingEncoding:NSUnicodeStringEncoding] options:@{ NSDocumentTypeDocumentAttribute: NSHTMLTextDocumentType} documentAttributes:nil error:nil];
    cell.contentLabel.attributedText = attrStr;
    
    cell.backgroundColor = kAnnounceHeaderColor;
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    return cell;
    
}


- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc] initWithFrame:CGRectZero style:UITableViewStylePlain];
        _tableView.translatesAutoresizingMaskIntoConstraints = NO;
        _tableView.showsVerticalScrollIndicator = NO;
        _tableView.showsHorizontalScrollIndicator = NO;
        _tableView.tableFooterView = [[UIView alloc] init];
        _tableView.rowHeight = UITableViewAutomaticDimension;
        _tableView.estimatedRowHeight = 100.0;
        _tableView.tableHeaderView = self.headerView;
        _tableView.tableFooterView = self.footerView;
        [_tableView registerClass:[AnnoContentTableViewCell class] forCellReuseIdentifier:kAnnounceContentCell];
        
        [self.view addSubview:_tableView];
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.view addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _tableView;
}

- (AnnounceDetailHeadView *)headerView
{
    if (!_headerView) {
        _headerView = [[AnnounceDetailHeadView alloc] initWithFrame:CGRectMake(0, 0, kScreenWidth, 120)];
        _headerView.backgroundColor = kAnnounceHeaderColor;
        _headerView.annoDetail = _annoDetail;
        }
    return _headerView;
}

- (AnnounceDetailFootView *)footerView
{
    if (!_footerView) {
        _footerView = [[AnnounceDetailFootView alloc] initWithFrame:CGRectMake(0, 0, kScreenWidth, 120)];
        _footerView.backgroundColor = [UIColor whiteColor];
    }
    return _footerView;
}

@end
