//
//  TreeNodeCell.m
//  redstar
//
//  Created by admin on 15/12/18.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "TreeNodeCell.h"
#import "CheckBoxButton.h"

@interface TreeNodeCell ()

@end

@implementation TreeNodeCell

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

#pragma mark - 初始化函数
-(instancetype)init {
    self = [super init];
    if (self) {
        [self configSelf];
    }
    return self;
}

-(id)initWithCoder:(NSCoder *)aDecoder {
    self = [super initWithCoder:aDecoder];
    if (self) {
        [self configSelf];
    }
    return self;
}

-(instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        [self configSelf];
    }
    return self;
}

-(instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier {
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self configSelf];
    }
    return self;
}

-(void)configSelf {
    
}

#pragma mark - 属性
-(void)setNodeData:(TreeNodeModel *)nodeData {
    _nodeData = nodeData;
    [self configFoldButton];
    [self configTitleButton];
}

#pragma mark - 折叠按钮


- (void)configFoldButton {
    if (self.foldButton == nil) {
        self.foldButton = [UIButton buttonWithType:UIButtonTypeCustom];
        _foldButton.translatesAutoresizingMaskIntoConstraints = NO;
        [self.foldButton addTarget:self action:@selector(actionFoldButton:) forControlEvents:UIControlEventTouchUpInside];
        [self.contentView addSubview:self.foldButton];
        
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_foldButton attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.contentView addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_foldButton attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.contentView addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_foldButton attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.contentView addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_foldButton attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.contentView addConstraint:tableBottom];


        NSLayoutConstraint *tableHeight = [NSLayoutConstraint constraintWithItem:_foldButton attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:50];
        [self.contentView addConstraint:tableHeight];
    }
    self.foldButton.selected = self.nodeData.expand;
}

-(void)actionFoldButton:(UIButton *)sender {
    if ([self.nodeDelegate respondsToSelector:@selector(shouldClickFoldButtonAtNode:)]) {
        if ([self.nodeDelegate shouldClickFoldButtonAtNode:self] == NO) {
            return;
        }
    }
    
    sender.selected = ! sender.selected;
    self.nodeData.expand = sender.selected;
    
    if ([self.nodeDelegate respondsToSelector:@selector(didClickFoldButtonAtNode:)]) {
        [self.nodeDelegate didClickFoldButtonAtNode:self];
    }
}

#pragma mark - 标题按钮
-(void)configTitleButton {
    [self.titleButton removeFromSuperview];
    self.titleButton = [[CheckBoxButton alloc] init];
    _titleButton.translatesAutoresizingMaskIntoConstraints = NO;
    self.titleButton.contentHorizontalAlignment = UIControlContentHorizontalAlignmentLeft;
    [self.titleButton addTarget:self action:@selector(actionTitleButton:) forControlEvents:UIControlEventTouchUpInside];
    [_titleButton setImage:[UIImage imageNamed:@"uncheck_box"] forState:UIControlStateNormal];
    [_titleButton setImage:[UIImage imageNamed:@"check_box"] forState:UIControlStateSelected];
    [self.titleButton setTitle:self.nodeData.name forState:UIControlStateNormal];
    [self.titleButton setTitleColor:kLightBlack forState:UIControlStateNormal];
    [self.titleButton setTitleColor:kSelectStoreColor forState:UIControlStateSelected];
    self.titleButton.titleLabel.font = [UIFont systemFontOfSize:16.0];
    [self addSubview:self.titleButton];
    
    //CGFloat x = 20 + self.nodeData.levelDeep * 22;
    CGFloat x = self.nodeData.levelDeep * 22;
    NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_titleButton attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
    [self addConstraint:tableTop];
    
    NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_titleButton attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:x];
    [self addConstraint:tableLeft];
    
    NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_titleButton attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    [self addConstraint:tableBottom];

}

-(void)actionTitleButton:(UIButton *)sender {
    if ([self.nodeDelegate respondsToSelector:@selector(didClickTitleAtNode:)]) {
        [self.nodeDelegate didClickTitleAtNode:self];
    }
}


@end
