//
//  PictureDetailTableCell.m
//  redstar
//
//  Created by admin on 15/12/11.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "PictureDetailTableCell.h"

@implementation PictureDetailTableCell

#pragma mark - lazy loading

- (UILabel *)titleLabel
{
    if (!_titleLabel) {
        _titleLabel = [[UILabel alloc] init];
        _titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView addSubview:_titleLabel];
        
        // 顶端
        NSLayoutConstraint *stateTop = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:10];
        [self.contentView addConstraint:stateTop];
        
        // 左边
        NSLayoutConstraint *stateLeft = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:stateLeft];
        
        // 右边
        NSLayoutConstraint *stateRight = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.thumbBtn attribute:NSLayoutAttributeLeft multiplier:1.0 constant:-5];
        [self.contentView addConstraint:stateRight];
        
        // 高度
        NSLayoutConstraint *stateHeight = [NSLayoutConstraint constraintWithItem:_titleLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [self.contentView addConstraint:stateHeight];
    }
    return _titleLabel;
}


- (UILabel *)contentLabel
{
    if (!_contentLabel) {
        _contentLabel = [[UILabel alloc] init];
        _contentLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _contentLabel.numberOfLines = 0;
        [self.contentView addSubview:_contentLabel];
        
        // 顶端
        NSLayoutConstraint *stateTop = [NSLayoutConstraint constraintWithItem:_contentLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.titleLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:3];
        [self.contentView addConstraint:stateTop];
        
        // 左边
        NSLayoutConstraint *stateLeft = [NSLayoutConstraint constraintWithItem:_contentLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:stateLeft];
        
        // 右边
        NSLayoutConstraint *stateRight = [NSLayoutConstraint constraintWithItem:_contentLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:stateRight];
        
        // 高度
        NSLayoutConstraint *stateBotom = [NSLayoutConstraint constraintWithItem:_contentLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-10];
        [self.contentView addConstraint:stateBotom];
    }
    return _contentLabel;
}

- (ZanButton *)thumbBtn
{
    if (!_thumbBtn) {
        _thumbBtn = [[ZanButton alloc] init];
        [_thumbBtn setImage:[UIImage imageNamed:@"commend"] forState:UIControlStateNormal];
        [_thumbBtn setImage:[UIImage imageNamed:@"commend_after"] forState:UIControlStateSelected];
        _thumbBtn.translatesAutoresizingMaskIntoConstraints = NO;
        _thumbBtn.titleLabel.font = [UIFont systemFontOfSize:16.0];
        [_thumbBtn setTitleColor:kNavigationBarColor forState:UIControlStateNormal];
        [self.contentView addSubview:_thumbBtn];
        
        // 顶端
        NSLayoutConstraint *thumbTop = [NSLayoutConstraint constraintWithItem:_thumbBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:12];
        [self.contentView addConstraint:thumbTop];
        
        //        // 左边
        NSLayoutConstraint *thumbWidth = [NSLayoutConstraint constraintWithItem:_thumbBtn attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:75];
        [self.contentView addConstraint:thumbWidth];
        
        // 右边
        NSLayoutConstraint *thumbRight = [NSLayoutConstraint constraintWithItem:_thumbBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-10];
        [self.contentView addConstraint:thumbRight];
        
        // 高度
        NSLayoutConstraint *thumbHeight = [NSLayoutConstraint constraintWithItem:_thumbBtn attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:20];
        [self.contentView addConstraint:thumbHeight];
    }
    return _thumbBtn;
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
