//
//  CategoryTableView.m
//  redstar
//
//  Created by admin on 15/12/6.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "CategoryTableView.h"
#import "HttpClient.h"

@interface CategoryTableView ()<UITableViewDelegate, UITableViewDataSource>
@property (nonatomic, strong) NSMutableArray *titleArray;
@property (nonatomic, strong) NSMutableArray *categoryArray;

@end
@implementation CategoryTableView

- (instancetype)init
{
    self = [super init];
    if (self) {
        [self setup];
    }
    return self;
}


- (instancetype)initWithFrame:(CGRect)frame style:(UITableViewStyle)style
{
    self = [super initWithFrame:frame style:style];
    if (self) {
        [self setup];
    }
    return self;
}

- (void)setup
{
    self.delegate = self;
    self.dataSource = self;
    self.titleArray = [NSMutableArray array];
    self.categoryArray = [NSMutableArray array];
    
    NSInteger selectedIndex = 0;
    NSIndexPath *selectedIndexPath = [NSIndexPath indexPathForRow:selectedIndex inSection:0];
    [self selectRowAtIndexPath:selectedIndexPath animated:NO scrollPosition:UITableViewScrollPositionNone];
    
    //注册通知
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(reloadCurrentTableView:) name:kQuestionGroupNotification object:nil];
}

- (void)reloadCurrentTableView:(NSNotification *)notification
{
    NSString *url = [NSString stringWithFormat:@"%@%@%@",kRedStarURL, kQuestionCategoryURL, notification.userInfo[@"groupName"]];
    HttpClient *http = [[HttpClient alloc] initWithUrl:url];
    [http getQuestionCategoryWithCompletion:^(id response, NSError *error) {
        NSLog(@"分类categaory response= %@", response);
        if (response[@"success"]) {
            NSDictionary *dictData = response[@"data"];
            NSArray *array = dictData[@"records"];
            NSMutableArray *groupArray = [NSMutableArray array];
            NSMutableArray *categoryArray = [NSMutableArray array];
            for (NSDictionary *dict in array) {
                NSString *category = [NSString stringWithFormat:@"%@", dict[@"name"]];
                NSString *group = [NSString stringWithFormat:@"%@", dict[@"groupName"]];
                [categoryArray addObject:category];
                [groupArray addObject:group];

            }
            _titleArray = categoryArray;
            _categoryArray = categoryArray;
            [self reloadData];
        }
    }];
}

- (void)dealloc
{
    [[NSNotificationCenter defaultCenter] removeObserver:self name:kQuestionGroupNotification object:nil];
}


#pragma mark - TableView Delegate/DataSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return _titleArray.count;
}


// cell显示的内容
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"categoryCell"];
    if (!cell) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:@"categoryCell"];
    }
    cell.textLabel.text = _titleArray[indexPath.row];
    cell.textLabel.font = [UIFont systemFontOfSize:14.0];

    return cell;
}

// cell点击事件
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    NSString *cateName = _categoryArray[indexPath.row];
    NSString *group = _titleArray[indexPath.row];
    if (_categroyDeleagte && [_categroyDeleagte respondsToSelector:@selector(categoryTableViewClick:GroupTitle:)]) {
        [_categroyDeleagte categoryTableViewClick:cateName GroupTitle:group];
    }
}


// section高度
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return CGFLOAT_MIN;
}

- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    return CGFLOAT_MIN;
}


@end
