//
//  RankDetailTableCell.m
//  redstar
//
//  Created by admin on 15/11/12.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "RankDetailTableCell.h"

@implementation RankDetailTableCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self setup];
    }
    return self;
}

- (void)setup
{
    self.arrowImageView.image = [UIImage imageNamed:@"grey-trilateral_right"];
    self.mainTitleBtn.titleLabel.font = [UIFont systemFontOfSize:15.0];
    self.scoreLabel.textColor = kDateButtonTextColor;
}

#pragma mark - Lazy Loading
- (UIImageView *)arrowImageView
{
    if (!_arrowImageView) {
        _arrowImageView = [[UIImageView alloc] init];
        _arrowImageView.translatesAutoresizingMaskIntoConstraints = NO;
        [self.contentView insertSubview:_arrowImageView aboveSubview:self.mainTitleBtn];
        
        NSLayoutConstraint *shoppingTop = [NSLayoutConstraint constraintWithItem:_arrowImageView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:18];
        [self.contentView addConstraint:shoppingTop];
        
        NSLayoutConstraint *shoppingLeft = [NSLayoutConstraint constraintWithItem:_arrowImageView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.contentView addConstraint:shoppingLeft];
        
        NSLayoutConstraint *shoppingWidth = [NSLayoutConstraint constraintWithItem:_arrowImageView attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:8];
        [self.contentView addConstraint:shoppingWidth];
        
        NSLayoutConstraint *shoppingHeight = [NSLayoutConstraint constraintWithItem:_arrowImageView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:12];
        [self.contentView addConstraint:shoppingHeight];
    }
    return _arrowImageView;
}

- (UIButton *)mainTitleBtn
{
    if (!_mainTitleBtn) {
        _mainTitleBtn = [[UIButton alloc] init];
        _mainTitleBtn.contentHorizontalAlignment = UIControlContentHorizontalAlignmentLeft ;
        _mainTitleBtn.translatesAutoresizingMaskIntoConstraints = NO;
        [_mainTitleBtn setTitleColor:kShopNameTextColor forState:UIControlStateNormal];
        [self.contentView addSubview:_mainTitleBtn];
        
        NSLayoutConstraint *shoppingTop = [NSLayoutConstraint constraintWithItem:_mainTitleBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:2];
        [self.contentView addConstraint:shoppingTop];
        
        NSLayoutConstraint *shoppingLeft = [NSLayoutConstraint constraintWithItem:_mainTitleBtn attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:37];
        [self.contentView addConstraint:shoppingLeft];
        
        NSLayoutConstraint *shoppingRight = [NSLayoutConstraint constraintWithItem:_mainTitleBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.scoreLabel attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.contentView addConstraint:shoppingRight];
        
        NSLayoutConstraint *shoppingHeight = [NSLayoutConstraint constraintWithItem:_mainTitleBtn attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:42];
        [self.contentView addConstraint:shoppingHeight];
        
        
    }
    return _mainTitleBtn;
}

- (UILabel *)scoreLabel
{
    if (!_scoreLabel) {
        _scoreLabel = [[UILabel alloc] init];
        _scoreLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _scoreLabel.textAlignment = NSTextAlignmentLeft;
        _scoreLabel.font = [UIFont systemFontOfSize:17.0];
        
        [self.contentView addSubview:_scoreLabel];
        NSLayoutConstraint *scoreTop = [NSLayoutConstraint constraintWithItem:_scoreLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeTop multiplier:1.0 constant:2];
        [self.contentView addConstraint:scoreTop];
        
        NSLayoutConstraint *scoreRight = [NSLayoutConstraint constraintWithItem:_scoreLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.contentView addConstraint:scoreRight];
        
        NSLayoutConstraint *scoreWidth = [NSLayoutConstraint constraintWithItem:_scoreLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:60];
        [self.contentView addConstraint:scoreWidth];
        
        NSLayoutConstraint *scoreHeight = [NSLayoutConstraint constraintWithItem:_scoreLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:42];
        [self.contentView addConstraint:scoreHeight];
    }
    return _scoreLabel;
}



- (void)awakeFromNib {
    // Initialization code
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
