//
//  RankListModel.h
//  redstar
//
//  Created by admin on 15/11/18.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface RankListModel : NSObject

@property (nonatomic,copy) NSString *uuid;
@property (nonatomic,copy) NSString *store_uuid;
@property (nonatomic,copy) NSString *store_code;
@property (nonatomic,copy) NSString *store_name;
@property (nonatomic, assign) CGFloat score;

@property (nonatomic,copy) NSString *reported;
@property (nonatomic,copy) NSString *commentId;
@property (nonatomic,copy) NSString *ranking;
@property (nonatomic,copy) NSString *storePath;
@property (nonatomic,copy) NSString *storeAddress;
@property (nonatomic,strong) NSArray *storePictures;

@property (nonatomic, assign, getter = isOpened) BOOL opened;

@property (nonatomic,strong) NSArray *comments;

+ (instancetype)rankListModelWithDict:(NSDictionary *)dict;
- (instancetype)initWithDict:(NSDictionary *)dict;

@property (nonatomic, assign) int index;
@end
