//
//  NoDataView.m
//  redstar
//
//  Created by admin on 15/11/20.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "NoDataView.h"

#define kImageWidth 91
#define kImageHeight 91
@implementation NoDataView

- (instancetype)init
{
    self = [super init];
    if (self) {
        [self setup];
    }
    return self;
}

- (void)setup
{
    UIImageView *imageView = [[UIImageView alloc] init];
    imageView.translatesAutoresizingMaskIntoConstraints = NO;
    imageView.image = [UIImage imageNamed:@"空白页_icon"];
    [self addSubview:imageView];
    
    NSLayoutConstraint *imageViewTop = [NSLayoutConstraint constraintWithItem:imageView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeCenterY multiplier:1.0 constant:-30];
    [self addConstraint:imageViewTop];
    
    NSLayoutConstraint *imageViewLeft = [NSLayoutConstraint constraintWithItem:imageView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:(kScreenWidth - kImageWidth) / 2];
    [self addConstraint:imageViewLeft];
    
    NSLayoutConstraint *imageViewHeight = [NSLayoutConstraint constraintWithItem:imageView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:kImageHeight];
    [self addConstraint:imageViewHeight];
    
    NSLayoutConstraint *imageViewWidth = [NSLayoutConstraint constraintWithItem:imageView attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:kImageWidth];
    [self addConstraint:imageViewWidth];
    
    UILabel *label = [[UILabel alloc] init];
    label.text = @"很抱歉，暂无数据！";
    label.translatesAutoresizingMaskIntoConstraints = NO;
    label.font = [UIFont boldSystemFontOfSize:30.0];
    label.textAlignment = NSTextAlignmentCenter;
    label.textColor = [UIColor colorWithRed:189/255.0 green:224/255.0 blue:246/255.0 alpha:1.0];
    [self addSubview:label];
    
    
    NSLayoutConstraint *labelTop = [NSLayoutConstraint constraintWithItem:label attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:imageView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:10];
    [self addConstraint:labelTop];
    
    NSLayoutConstraint *labelLeft = [NSLayoutConstraint constraintWithItem:label attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
    [self addConstraint:labelLeft];
    
    NSLayoutConstraint *labelRight = [NSLayoutConstraint constraintWithItem:label attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
    [self addConstraint:labelRight];
    
    NSLayoutConstraint *labelHeight = [NSLayoutConstraint constraintWithItem:label attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:40];
    [self addConstraint:labelHeight];
}

@end
