//
//  HomeViewController.m
//  redstar
//
//  Created by admin on 15/10/23.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "HomeViewController.h"
#import "HomeHeaderView.h"


#import "InspectListViewController.h"
#import "RankingListViewController.h"
#import "OnLineViewController.h"
#import "PictureViewController.h"
#import "QuestionViewController.h"

#import "HomeCellItem.h"

#import "PictureTableCell.h"
#define kHomePictureListCell @"homePictureListCell"
#import "PictureStoryViewController.h"

#import "HomeTitleTableCell.h"
#define kHomeTitleTableCell @"homeTitleTableCell"
#import "RankingListCell.h"
#define kHomeRankingListCell @"homeRankingListsCell"
#import "RankDetailViewController.h"
#import "RankListModel.h"

#import "QuestionListTableCell.h"
#define kHomeQuestionListTableCell @"homeQuestionListTableCell"
#import "QuestionModel.h"
#import "QuestionDetailViewController.h"
#define kQuestionTag 387428

#import "InspectListCell.h"
#define kHomeInspectListCell @"homeInspectListsCell"
#import "InspectTaskViewController.h"
#import "TaskListModel.h"

#import "HttpClient.h"
#import <MBProgressHUD.h>

@interface HomeViewController () <UITableViewDelegate, UITableViewDataSource, UIScrollViewDelegate, UITextFieldDelegate>
@property (nonatomic, strong) UIImageView *bgImageView; // 背景
@property (nonatomic, strong) UITextField *searchTextField; // 搜索框
@property (nonatomic, strong) UILabel *shopnameLabel; // 店名
@property (nonatomic, strong) UILabel *nameLabel; // 用户姓名


// 当前视图
@property (nonatomic, strong) UITableView *tableView;
@property (nonatomic, strong) HomeHeaderView *headView;

@property (nonatomic, strong) NSArray *titleArray; // section标题
@property (nonatomic, strong) NSArray *btnTitleArray; // section标题
@property (nonatomic, strong) NSArray *announeArray; // 公告内容

@property (nonatomic, strong) NSArray *test1Array; // section标题
@property (nonatomic, strong) NSArray *test2Array; // section标题
@property (nonatomic, strong) NSArray *test3Array; // section标题


@property (nonatomic, strong) NSArray *test4Array;
@property (nonatomic, strong) NSArray *test5Array;
@property (nonatomic, strong) NSArray *test6Array;
@property (nonatomic, strong) NSArray *test7Array;
@property (nonatomic, strong) NSArray *test8Array;
@property (nonatomic, strong) NSArray *test9Array;
// rank cell
@property (nonatomic, strong) NSMutableDictionary *selectedIndexes;

@property (nonatomic, strong) NSMutableArray *allQuestionArray; // 问题与知识
@property (nonatomic, strong) NSMutableArray *taskListDataArray; // 问题与知识
@property (nonatomic, strong) NSMutableArray *allRankListArray;
@end

@implementation HomeViewController
#pragma mark - ViewDidLoad
- (void)viewDidLoad
{
    [super viewDidLoad];
    
    
    UILabel *customLab = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 40, 30)];
    [customLab setTextColor:[UIColor whiteColor]];
    [customLab setText:@"首页"];
    customLab.font = [UIFont boldSystemFontOfSize:19];
    self.navigationItem.titleView = customLab;
    
    // 初始化容器
    self.titleArray = [NSArray arrayWithObjects:@"图说口碑", @"8月口碑巡检",@"问题与知识",@"口碑任务", nil];
    self.btnTitleArray = [NSArray arrayWithObjects:@"在线抽查", @"口碑巡检",@"口碑标准",@"图说口碑",@"问题与知识",@"优秀案例", nil];
    self.announeArray = [NSArray arrayWithObjects:@"关于展开10月口碑巡检的说明", @"迎2015十一大促活动启动", @"9月口碑巡检结果排名已公布", nil];
    
    // 初始化
    self.test1Array = [NSArray arrayWithObjects:@"【服务口碑现场】第二期",@"讲述红星人自己的故事",@"【服务口碑现场】第一期", nil];
    self.test2Array = [NSArray arrayWithObjects:@"把第一次客户投诉变成商场服务提升的契机，变成商场服务提升的契机。",@"变成商场服务提升的契机，变成商场服务提升的契机。",@"把第一次客户投诉变成商场服务提升的契机，变成商场服务提升的契机。", nil];
    self.test3Array = [NSArray arrayWithObjects:@"2015-08-26",@"2015-08-09",@"2015-07-31", nil];
    
    self.test7Array = [NSArray arrayWithObjects:@"2015年9月口碑巡检",@"2015年9月卫生专项巡检",@"2015年9月真北店安全临时巡检",@"2015年10月卫生专项巡检",@"2015年10月设备安全巡检", nil];
    self.test8Array = [NSArray arrayWithObjects:@"2015-09-01 10:28:52",@"2015-09-08 12:47:32",@"2015-10-21 07:58:22",@"2015-10-09 19:08:52",@"2015-09-01 14:19:52", nil];
    self.test9Array = [NSArray arrayWithObjects:@"2015-09-03",@"2015-09-15",@"2015-10-22",@"2015-11-02",@"2015-11-05", nil];
    self.test4Array = [NSArray arrayWithObjects:@"2",@"3",@"1",@"2",@"1", nil];
    self.test5Array = [NSArray arrayWithObjects:@(5),@(12),@(0),@(8),@(20), nil];
    self.test6Array = [NSArray arrayWithObjects:@(16),@(25),@(20),@(100),@(20), nil];
    
    [self setupNav];
    [self setupTableView];
    
    // 初始化容器
    self.selectedIndexes = [[NSMutableDictionary alloc] init];
    
    [MBProgressHUD showHUDAddedTo:self.view animated:YES];
    
    self.allRankListArray = [NSMutableArray array];
    self.taskListDataArray = [NSMutableArray array];
    self.allQuestionArray = [NSMutableArray array];

    self.tableView.tableHeaderView = self.headView;

    //
    [self requestRankingList];
    // 巡检列表
    [self requestInspectList];
    
    // 问题与知识
    [self requestQuestionList];
    
}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    self.tabBarController.tabBar.hidden = NO;
    self.navigationController.navigationBar.hidden = YES;
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}

#pragma mark - 请求
- (void)requestRankingList
{
    
    NSString *url = [NSString stringWithFormat:@"%@%@", kRedStarURL, kRankingListURL];
    HttpClient *httpCilent = [[HttpClient alloc] initWithUrl:url];
    NSDictionary *parameters = @{
                                 @"queryOrders":@[@{@"direction":@"asc"}],
                                 @"pageNumber":@(0),
                                 @"pageSize":@(3)
                                 };
    __block HomeViewController *weakSelf = self;
    [httpCilent getRankingListWithParameters:parameters completion:^(id response, NSError *error) {
        NSLog(@"口碑排名response = %@", response);
        NSDictionary *dataDict = response[@"data"];
        NSArray *dataArray = dataDict[@"records"];
        for (NSDictionary *ListDict in dataArray) {
            RankListModel *rankList = [RankListModel rankListModelWithDict:ListDict];
            [weakSelf.allRankListArray addObject:rankList];
        }
        [self.tableView reloadData];
        [MBProgressHUD hideHUDForView:self.view animated:YES];
            
    }];
}



- (void)requestInspectList
{
    
    NSString *url = [NSString stringWithFormat:@"%@%@", kRedStarURL, kInspectListURL];
    HttpClient *httpCilent = [[HttpClient alloc] initWithUrl:url];
    NSDictionary *parameters = @{@"userUuid":@"",
                                 @"queryOrders":@[@{@"field":@"lastModifyInfo"}],
                                 @"pageNumber":@(0),
                                 @"pageSize":@(2)
                                 };
    
    [httpCilent getInspectListWithParameters:parameters completion:^(id response, NSError *error) {
        
        NSLog(@"巡检列表%@", response);
        
        NSDictionary *dataDict = response[@"data"];
        NSArray *dataArray = dataDict[@"records"];
        for (NSDictionary *dict in dataArray) {
            TaskListModel *taskList = [[TaskListModel alloc] init];
            [taskList setValuesForKeysWithDictionary:dict];
            [_taskListDataArray addObject:taskList];
        }
        [self.tableView reloadData];
        [MBProgressHUD hideHUDForView:self.view animated:YES];

    }];

}


- (void)requestQuestionList
{
    // 初始化数组
    // 请求地址
    NSString *urlStr = [NSString stringWithFormat:@"%@%@", kRedStarURL, kQuestionListURL];
    NSString *user_uuid = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_uuid"];
    // 请求参数
    NSDictionary *parameters = @{
                                 @"user":user_uuid,
                                 @"scope":@"all",
                                 @"pageNumber":@(0),
                                 @"pageSize":@(2)
                                 };
    
    // 发起请求
    HttpClient *httpClient = [[HttpClient alloc] initWithUrl:urlStr];
    //
    __block HomeViewController *weakSelf = self;
    
    // 请求问题列表
    [httpClient getQuestionListWithParameters:parameters completion:^(id response, NSError *error) {
        NSDictionary *dataDict = (NSDictionary *)response[@"data"];
        NSDictionary *recordsDict = (NSDictionary *)dataDict[@"records"];
        NSLog(@"问题与知识列表recods = %@", response);
        for (NSDictionary *questionDict in recordsDict) {
            QuestionModel *question = [[QuestionModel alloc] init];
            [question setValuesForKeysWithDictionary:questionDict];
            [weakSelf.allQuestionArray addObject:question];
        }
        [self.tableView reloadData];

        self.tableView.tableHeaderView = self.headView;
        [MBProgressHUD hideHUDForView:self.view animated:YES];
    }];
}


#pragma mark - Private Methods
- (void)setupNav
{
    UIEdgeInsets insets = UIEdgeInsetsMake( 0, 199, 0, 175);
    UIImage *image = [[UIImage imageNamed:@"home_title"] resizableImageWithCapInsets:insets resizingMode:UIImageResizingModeStretch];
    self.bgImageView.image = image;
    self.searchTextField.backgroundColor = [UIColor clearColor];
    self.nameLabel.backgroundColor = [UIColor clearColor];
    _nameLabel.text = @"东方明珠，你好!";
    self.shopnameLabel.backgroundColor = [UIColor clearColor];
    _shopnameLabel.text = @"上海真北店";

}

- (void)setupTableView
{
    self.headView = [[HomeHeaderView alloc] initWithFrame:CGRectMake(0, 0, kScreenWidth, 115)];
    
    self.headView.scrollView.contentSize = CGSizeMake(2 * kScreenWidth, 85);
    CGFloat itemW = kScreenWidth / 4;
    CGFloat itemH = self.headView.scrollView.frame.size.height;
    
    for (int i = 0; i < 6; i++) {
        HomeCellItem *item = [[HomeCellItem alloc] init];
        item.frame = CGRectMake(i * itemW, 0, itemW, itemH);
        UIImage *image = [UIImage imageNamed:[NSString stringWithFormat:@"task_0%d", i]];
        [item setImage:image forState:UIControlStateNormal];
        [item setTitleColor:kPictureCellDetailsColor forState:UIControlStateNormal];
        [item setTitle:[NSString stringWithFormat:@"%@", self.btnTitleArray[i]] forState:UIControlStateNormal];
        [item addTarget:self action:@selector(itemClick:) forControlEvents:UIControlEventTouchUpInside];
        [self.headView.scrollView addSubview:item];
    }
}

// 更多按钮点击事件
- (void)moreButtonClick:(UIButton *)sender
{
    UIButton *button = (UIButton *)sender;
    UINavigationController *nav;

    if (button.tag - 332892 == 0) {
        PictureViewController *pictureVC = [[PictureViewController alloc] init];
        nav = [[UINavigationController alloc] initWithRootViewController:pictureVC];
    } else if (button.tag - 332892 == 1) {
        RankingListViewController *rankingListVC = [[RankingListViewController alloc] init];
        nav = [[UINavigationController alloc] initWithRootViewController:rankingListVC];
    } else if (button.tag - 332892 == 2) {
        QuestionViewController *questionVC = [[QuestionViewController alloc] init];
        nav = [[UINavigationController alloc] initWithRootViewController:questionVC];

    } else {
        InspectListViewController *inspectListVC = [[InspectListViewController alloc] init];
        nav = [[UINavigationController alloc] initWithRootViewController:inspectListVC];
    }
    
    [nav.navigationBar setBarTintColor:kNavigationBarColor];
    [nav.navigationBar setTitleTextAttributes:[NSDictionary dictionaryWithObjectsAndKeys:[UIColor whiteColor],NSForegroundColorAttributeName,nil]];
    [self presentViewController:nav animated:YES completion:nil];
}

- (void)itemClick:(HomeCellItem *)sender
{
    HomeCellItem *item = (HomeCellItem *)sender;
    UINavigationController *nav;
    if ([item.titleLabel.text isEqualToString:@"在线抽查"]) {
        return;
    } else if ([item.titleLabel.text isEqualToString:@"口碑巡检"]) {
        InspectListViewController *inspectListVC = [[InspectListViewController alloc] init];
        nav = [[UINavigationController alloc] initWithRootViewController:inspectListVC];
    } else if ([item.titleLabel.text isEqualToString:@"口碑标准"]) {
        return;
    } else if ([item.titleLabel.text isEqualToString:@"图说口碑"]) {
        PictureViewController *pictureVC = [[PictureViewController alloc] init];
        nav = [[UINavigationController alloc] initWithRootViewController:pictureVC];
    } else if ([item.titleLabel.text isEqualToString:@"问题与知识"]) {
        QuestionViewController *questionVC = [[QuestionViewController alloc] init];
        nav = [[UINavigationController alloc] initWithRootViewController:questionVC];
    } else if ([item.titleLabel.text isEqualToString:@"优秀案例"]) {
        RankingListViewController *rankingListVC = [[RankingListViewController alloc] init];
        nav = [[UINavigationController alloc] initWithRootViewController:rankingListVC];
    } else {
        return;
    }
    
    [nav.navigationBar setBarTintColor:kNavigationBarColor];
    [nav.navigationBar setTitleTextAttributes:[NSDictionary dictionaryWithObjectsAndKeys:[UIColor whiteColor],NSForegroundColorAttributeName,nil]];
    [self presentViewController:nav animated:YES completion:nil];
}


// rank Cell
- (BOOL)cellIsSelected:(NSIndexPath *)indexPath {
    // Return whether the cell at the specified index path is selected or not
    NSNumber *selectedIndex = [_selectedIndexes objectForKey:indexPath];
    return selectedIndex == nil ? FALSE : [selectedIndex boolValue];
}

- (void)loadMoreInfo:(UIButton *)sender
{
    RankingListCell * cell = (RankingListCell *)[[sender superview] superview];
    cell.isDrop = !cell.isDrop;
    NSIndexPath * path = [self.tableView indexPathForCell:cell];
    
    [_tableView deselectRowAtIndexPath:path animated:TRUE];
    
    BOOL isSelected = ![self cellIsSelected:path];
    
    NSNumber *selectedIndex = [NSNumber numberWithBool:isSelected];
    [_selectedIndexes setObject:selectedIndex forKey:path];
    
    
    if (cell.isDrop) {
        
        [UIView animateWithDuration:0.2 animations:^{
            cell.arrowImageView.transform = CGAffineTransformIdentity;
            cell.arrowImageView.transform = CGAffineTransformMakeRotation(M_PI / 2);
        }];
        
        
        cell.someoneLabel = [[UILabel alloc] init];
        cell.someoneLabel.text = @"集团领导某总";
        cell.someoneLabel.font = [UIFont systemFontOfSize:15.0];
        cell.someoneLabel.textAlignment = NSTextAlignmentCenter;
        cell.someoneLabel.textColor = kRankHeadTitleTextColor;
        cell.someoneLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [cell.contentView addSubview:cell.someoneLabel];
        
        cell.dateLabel = [[UILabel alloc] init];
        cell.dateLabel.text = @"2015-09-25 12:12:09";
        cell.dateLabel.font = [UIFont systemFontOfSize:15.0];
        cell.dateLabel.textAlignment = NSTextAlignmentCenter;
        cell.dateLabel.textColor = kRankHeadTitleTextColor;
        cell.dateLabel.translatesAutoresizingMaskIntoConstraints = NO;
        [cell.contentView addSubview:cell.dateLabel];
        
        cell.remarkLabel = [[UILabel alloc] init];
        cell.remarkLabel.translatesAutoresizingMaskIntoConstraints = NO;
        cell.remarkLabel.text = @"评语:该店进步非常大，值得大家一起学习！";
        cell.remarkLabel.font = [UIFont systemFontOfSize:15.0];
        cell.remarkLabel.textColor = kRankHeadTitleTextColor;
        [cell.contentView addSubview:cell.remarkLabel];
        
        NSLayoutConstraint *someoneTop = [NSLayoutConstraint constraintWithItem:cell.someoneLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:cell.shopNameButton attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [cell.contentView addConstraint:someoneTop];
        
        NSLayoutConstraint *someoneCenterX = [NSLayoutConstraint constraintWithItem:cell.someoneLabel attribute:NSLayoutAttributeCenterX relatedBy:NSLayoutRelationEqual toItem:cell.shopNameButton attribute:NSLayoutAttributeCenterX multiplier:1.0 constant:5];
        [cell.contentView addConstraint:someoneCenterX];
        
        NSLayoutConstraint *someoneWidth = [NSLayoutConstraint constraintWithItem:cell.someoneLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:100];
        [cell.contentView addConstraint:someoneWidth];
        
        NSLayoutConstraint *someoneHeight = [NSLayoutConstraint constraintWithItem:cell.someoneLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [cell.contentView addConstraint:someoneHeight];
        
        //
        NSLayoutConstraint *dateTop = [NSLayoutConstraint constraintWithItem:cell.dateLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:cell.shopNameButton attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [cell.contentView addConstraint:dateTop];
        
        NSLayoutConstraint *dateLeft = [NSLayoutConstraint constraintWithItem:cell.dateLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:cell.someoneLabel attribute:NSLayoutAttributeRight multiplier:1.0 constant:10];
        [cell.contentView addConstraint:dateLeft];
        
        NSLayoutConstraint *dateRight = [NSLayoutConstraint constraintWithItem:cell.dateLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:cell.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [cell.contentView addConstraint:dateRight];
        
        NSLayoutConstraint *dateHeight = [NSLayoutConstraint constraintWithItem:cell.dateLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [cell.contentView addConstraint:dateHeight];
        
        //
        NSLayoutConstraint *remarkTop = [NSLayoutConstraint constraintWithItem:cell.remarkLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:cell.someoneLabel attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [cell.contentView addConstraint:remarkTop];
        
        NSLayoutConstraint *remarkLeft = [NSLayoutConstraint constraintWithItem:cell.remarkLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:cell.someoneLabel attribute:NSLayoutAttributeLeft multiplier:1.0 constant:5];
        [cell.contentView addConstraint:remarkLeft];
        
        NSLayoutConstraint *remarkRight = [NSLayoutConstraint constraintWithItem:cell.remarkLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:cell.contentView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [cell.contentView addConstraint:remarkRight];
        
        NSLayoutConstraint *remarkHeight = [NSLayoutConstraint constraintWithItem:cell.remarkLabel attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:25];
        [cell.contentView addConstraint:remarkHeight];
        
    } else {
        
        [UIView animateWithDuration:0.2 animations:^{
            cell.arrowImageView.transform = CGAffineTransformIdentity;
            cell.arrowImageView.transform = CGAffineTransformMakeRotation(0);
        }];
        
        if (cell.someoneLabel) {
            [cell.someoneLabel removeFromSuperview];
            cell.someoneLabel = nil;
        }
        
        if (cell.dateLabel) {
            [cell.dateLabel removeFromSuperview];
            cell.dateLabel = nil;
        }
        
        if (cell.remarkLabel) {
            [cell.remarkLabel removeFromSuperview];
            cell.remarkLabel = nil;
        }
    }
    
    [_tableView beginUpdates];
    [_tableView endUpdates];
}





#pragma mark - TableView Delegate/DataSource
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return _titleArray.count;
}


- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    if (section == 0) {
        return 2;
    } else if (section == 1) {
        return _allRankListArray.count + 1;
    } else if (section == 2) {
        return _allQuestionArray.count;
    } else{
        return _taskListDataArray.count;
    }
}

// cell显示的内容
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    
    if (indexPath.section == 0) {
        
        // 图说口碑
        
        PictureTableCell *cell=[tableView dequeueReusableCellWithIdentifier:kHomePictureListCell];
        if (!cell) {
            cell = [[PictureTableCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kHomePictureListCell];
        }
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        cell.titleLabel.text = _test1Array[indexPath.row];
        cell.detailsLabel.text = _test2Array[indexPath.row];
        cell.dateLabel.text = [NSString stringWithFormat:@"发布时间: %@", _test3Array[indexPath.row]];
        [cell.thumbBtn setTitle:@"220" forState:UIControlStateNormal];
        [cell.commentBtn setTitle:@"18" forState:UIControlStateNormal];
        return cell;
    } else if (indexPath.section == 1) {
        
        // 口碑巡检
        
        if (indexPath.row == 0) {
            HomeTitleTableCell *cell=[tableView dequeueReusableCellWithIdentifier:kHomeTitleTableCell];
            if (!cell) {
                cell = [[HomeTitleTableCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kHomeTitleTableCell];
            }
            cell.selectionStyle = UITableViewCellSelectionStyleNone;
            return cell;
        } else {
            RankingListCell *cell=[tableView dequeueReusableCellWithIdentifier:kHomeRankingListCell];
            if (!cell) {
                cell = [[RankingListCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kHomeRankingListCell];
            }
            
            RankListModel *rankList = _allRankListArray[indexPath.row - 1];
            cell.rankList = rankList;
            cell.selectionStyle = UITableViewCellSelectionStyleNone;
            cell.scoreState = ScoreStateHigh;
            NSString *imageName = [NSString stringWithFormat:@"medal_0%ld", (long)(indexPath.row)];
            cell.gradeImageView.image = [UIImage imageNamed:imageName];            // 添加点击事件
            [cell.shopNameButton addTarget:self action:@selector(loadMoreInfo:) forControlEvents:UIControlEventTouchUpInside];
            return cell;
        }
    } else if (indexPath.section == 2) {
        // 问题与知识
        QuestionListTableCell *cell = [tableView dequeueReusableCellWithIdentifier:kHomeQuestionListTableCell];
        if (!cell) {
            cell = [[QuestionListTableCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kHomeQuestionListTableCell];
        }
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        QuestionModel *question = _allQuestionArray[indexPath.row];
        cell.question = question;
        return cell;

    } else {
        InspectListCell *cell=[tableView dequeueReusableCellWithIdentifier:kHomeInspectListCell];
        if (!cell) {
            cell = [[InspectListCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kHomeInspectListCell];
        }
        TaskListModel *taskList = _taskListDataArray[indexPath.row];
        cell.taskList = taskList;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        cell.allView.backgroundColor = kProgressViewAllBackColor;
        UIImage *image = [UIImage imageNamed:@"progress-bar"];
        image = [image resizableImageWithCapInsets:UIEdgeInsetsZero resizingMode:UIImageResizingModeTile];
        cell.alreadyView.image = image;
        return cell;
    }
}

// cell点击事件
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.section == 0) {
        PictureStoryViewController *storyVC = [[PictureStoryViewController alloc] init];
        UINavigationController *nav = [[UINavigationController alloc] initWithRootViewController:storyVC];
        [nav.navigationBar setBarTintColor:kNavigationBarColor];
        [nav.navigationBar setTitleTextAttributes:[NSDictionary dictionaryWithObjectsAndKeys:[UIColor whiteColor],NSForegroundColorAttributeName,nil]];
        [self presentViewController:nav animated:YES completion:nil];
    } else if (indexPath.section == 1) {
        if (indexPath.row != 0) {
            RankDetailViewController *rankDetailVC = [[RankDetailViewController alloc] init];
            RankListModel *rankModel = _allRankListArray[indexPath.row - 1];
            rankDetailVC.indexRow = indexPath.row - 1;
            rankDetailVC.uuid = rankModel.uuid;
            rankDetailVC.store_uuid = rankModel.store_uuid;
            self.hidesBottomBarWhenPushed = YES;
            [self.navigationController pushViewController:rankDetailVC animated:YES];
        }
    } else if (indexPath.section == 2) {
        QuestionDetailViewController *questionDetailVC = [[QuestionDetailViewController alloc] init];
        QuestionModel *question = self.allQuestionArray[indexPath.row];
        questionDetailVC.questionUuid = question.uuid;
        self.hidesBottomBarWhenPushed = YES;
        [self.navigationController pushViewController:questionDetailVC animated:YES];

    } else {
    
        InspectTaskViewController *inspectTaskVC = [[InspectTaskViewController alloc] init];
        TaskListModel *taskList = self.taskListDataArray[indexPath.row];
        inspectTaskVC.uuid = taskList.uuid;
        inspectTaskVC.store_uuid = taskList.store_uuid;
        inspectTaskVC.multiplier = (CGFloat)taskList.reportCount / taskList.questionCount ;
        self.hidesBottomBarWhenPushed = YES;
        [self.navigationController pushViewController:inspectTaskVC animated:YES];
        
    }
}

// cell的高度
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.section == 0) {
        return 123;
    } else if (indexPath.section == 1) {
        if (indexPath.row == 0) {
            return 40;
        } else {
            if([self cellIsSelected:indexPath]) {
               return 108;
            }
            return 50;
        }
    } else if (indexPath.section == 2) {
        return 120;
    } else {
        return 145;
    }
}

// section高度
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 36;
}

- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    return 10;
}

// 自定义section
- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
   
    
    
    
    // 创建sectionView
    UIView *sectionView = [[UIView alloc] init];
    sectionView.userInteractionEnabled = YES;
    sectionView.backgroundColor = [UIColor whiteColor];
    
    UIView *lineView = [[UIView alloc] init];
    lineView.translatesAutoresizingMaskIntoConstraints = NO;
    lineView.backgroundColor = kSeparateLineColor;
    [sectionView addSubview:lineView];
    
    NSLayoutConstraint *lineTop = [NSLayoutConstraint constraintWithItem:lineView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
    [sectionView addConstraint:lineTop];
    
    NSLayoutConstraint *lineLeft = [NSLayoutConstraint constraintWithItem:lineView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
    [sectionView addConstraint:lineLeft];
    
    NSLayoutConstraint *lineRight = [NSLayoutConstraint constraintWithItem:lineView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
    [sectionView addConstraint:lineRight];
    
    NSLayoutConstraint *lineHeight = [NSLayoutConstraint constraintWithItem:lineView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:0.5];
    [sectionView addConstraint:lineHeight];
    
    // 创建标题label
    UILabel *titleLabel = [[UILabel alloc] init];
    titleLabel.translatesAutoresizingMaskIntoConstraints = NO;
    titleLabel.textColor = kPictureCellDetailsColor;
    titleLabel.font = [UIFont systemFontOfSize:17.0];
    titleLabel.text = _titleArray[section];
    [sectionView addSubview:titleLabel];
    
    
    // 查看更多按钮
    UIButton *moreButton = [[UIButton alloc] init];
    moreButton.tag = 332892 + section;
    moreButton.translatesAutoresizingMaskIntoConstraints = NO;
    [moreButton setTitle:@"更多" forState:UIControlStateNormal];
    [moreButton setTitleColor:kMoreButtonTextColor forState:UIControlStateNormal];
    [moreButton addTarget:self action:@selector(moreButtonClick:) forControlEvents:UIControlEventTouchUpInside];
    moreButton.titleLabel.font = [UIFont systemFontOfSize:13.0];
    [sectionView addSubview:moreButton];
    
    // 箭头Iamge
    UIImageView *arrowIamgeView = [[UIImageView alloc] init];
    arrowIamgeView.image = [UIImage imageNamed:@"arrow_right"];
    arrowIamgeView.translatesAutoresizingMaskIntoConstraints = NO;
    [sectionView addSubview:arrowIamgeView];
    
    NSLayoutConstraint *titleLabelTop = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:3];
    [sectionView addConstraint:titleLabelTop];
    
    NSLayoutConstraint *titleLabelLeft = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
    [sectionView addConstraint:titleLabelLeft];
    
    NSLayoutConstraint *titleLabelRight = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:moreButton attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
    [sectionView addConstraint:titleLabelRight];
    
    NSLayoutConstraint *titleLabelBottom = [NSLayoutConstraint constraintWithItem:titleLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    [sectionView addConstraint:titleLabelBottom];
    
    
    
    
    
    // moreButton布局
    NSLayoutConstraint *moreButtonTop = [NSLayoutConstraint constraintWithItem:moreButton attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:3];
    [sectionView addConstraint:moreButtonTop];
    
    NSLayoutConstraint *moreButtonRight = [NSLayoutConstraint constraintWithItem:moreButton attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:arrowIamgeView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
    [sectionView addConstraint:moreButtonRight];
    
    NSLayoutConstraint *moreButtonWidth = [NSLayoutConstraint constraintWithItem:moreButton attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:35];
    [sectionView addConstraint:moreButtonWidth];
    
    NSLayoutConstraint *moreButtonBottom = [NSLayoutConstraint constraintWithItem:moreButton attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    [sectionView addConstraint:moreButtonBottom];
    
    // arrowIamgeView布局
    NSLayoutConstraint *arrowIamgeViewTop = [NSLayoutConstraint constraintWithItem:arrowIamgeView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeTop multiplier:1.0 constant:13];
    [sectionView addConstraint:arrowIamgeViewTop];
    
    NSLayoutConstraint *arrowIamgeViewRight = [NSLayoutConstraint constraintWithItem:arrowIamgeView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:sectionView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
    [sectionView addConstraint:arrowIamgeViewRight];
    
    NSLayoutConstraint *arrowIamgeViewWidth = [NSLayoutConstraint constraintWithItem:arrowIamgeView attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:7];
    [sectionView addConstraint:arrowIamgeViewWidth];
    
    NSLayoutConstraint *arrowIamgeViewHeight = [NSLayoutConstraint constraintWithItem:arrowIamgeView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:12];
    [sectionView addConstraint:arrowIamgeViewHeight];
    
    
    return sectionView;
}

#pragma mark - lazy loading
- (UIImageView *)bgImageView
{
    if (!_bgImageView) {
        _bgImageView = [[UIImageView alloc] init];
        _bgImageView.translatesAutoresizingMaskIntoConstraints = NO;
        _bgImageView.userInteractionEnabled = YES;
        [self.view addSubview:_bgImageView];
        
        NSLayoutConstraint *bgImageTop = [NSLayoutConstraint constraintWithItem:_bgImageView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
        [self.view addConstraint:bgImageTop];
        
        NSLayoutConstraint *bgImageLeft = [NSLayoutConstraint constraintWithItem:_bgImageView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:bgImageLeft];
        
        NSLayoutConstraint *bgImageHeight = [NSLayoutConstraint constraintWithItem:_bgImageView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:95];
        [self.view addConstraint:bgImageHeight];
        
        NSLayoutConstraint *bgImageRight = [NSLayoutConstraint constraintWithItem:_bgImageView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:bgImageRight];
    }
    return _bgImageView;
}

- (UITextField *)searchTextField
{
    if (!_searchTextField) {
        _searchTextField = [[UITextField alloc] init];
        _searchTextField.translatesAutoresizingMaskIntoConstraints = NO;
        _searchTextField.font = [UIFont systemFontOfSize:13.0];
        _searchTextField.textAlignment = NSTextAlignmentCenter;
        _searchTextField.layer.cornerRadius = 4.0;
        _searchTextField.textColor = [UIColor whiteColor];
        _searchTextField.layer.borderColor = [[UIColor whiteColor] CGColor];
        _searchTextField.layer.borderWidth = 0.5;
        _searchTextField.placeholder = @"查询";
        _searchTextField.delegate = self;
        [_searchTextField setValue:[UIColor whiteColor] forKeyPath:@"_placeholderLabel.textColor"];
        UIButton *imageV = [[UIButton alloc] init];
        imageV.frame = CGRectMake(0, 0, 28, 28);
        [imageV setImage:[UIImage imageNamed:@"search"] forState:UIControlStateNormal];
        [imageV addTarget:self action:@selector(searchClick:) forControlEvents:UIControlEventTouchUpInside];
        imageV.contentMode = UIViewContentModeCenter;
        imageV.width += 10;
        _searchTextField.rightView = imageV;
        _searchTextField.rightViewMode = UITextFieldViewModeAlways;
        [self.bgImageView addSubview:_searchTextField];
        
        NSLayoutConstraint *bgImageTop = [NSLayoutConstraint constraintWithItem:_searchTextField attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.bgImageView attribute:NSLayoutAttributeTop multiplier:1.0 constant:35];
        [self.bgImageView addConstraint:bgImageTop];
        
        NSLayoutConstraint *bgImageRight = [NSLayoutConstraint constraintWithItem:_searchTextField attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.bgImageView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.bgImageView addConstraint:bgImageRight];
        
        NSLayoutConstraint *bgImageHeight = [NSLayoutConstraint constraintWithItem:_searchTextField attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:28];
        [self.bgImageView addConstraint:bgImageHeight];
        
        NSLayoutConstraint *bgImageWidth = [NSLayoutConstraint constraintWithItem:_searchTextField attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:100];
        [self.bgImageView addConstraint:bgImageWidth];
    }
    return _searchTextField;
}

- (UILabel *)nameLabel
{
    if (!_nameLabel) {
        _nameLabel = [[UILabel alloc] init];
        _nameLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _nameLabel.font = [UIFont systemFontOfSize:13.0];
        _nameLabel.textAlignment = NSTextAlignmentRight;
        _nameLabel.textColor = [UIColor whiteColor];
        [self.bgImageView addSubview:_nameLabel];
        
        NSLayoutConstraint *bgImageTop = [NSLayoutConstraint constraintWithItem:_nameLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.searchTextField attribute:NSLayoutAttributeBottom multiplier:1.0 constant:3];
        [self.bgImageView addConstraint:bgImageTop];
        
        NSLayoutConstraint *bgImageRight = [NSLayoutConstraint constraintWithItem:_nameLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.bgImageView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.bgImageView addConstraint:bgImageRight];
        
        NSLayoutConstraint *bgImageBottom = [NSLayoutConstraint constraintWithItem:_nameLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.bgImageView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.bgImageView addConstraint:bgImageBottom];
        
        NSLayoutConstraint *bgImageWidth = [NSLayoutConstraint constraintWithItem:_nameLabel attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:nil attribute:NSLayoutAttributeNotAnAttribute multiplier:1.0 constant:95];
        [self.bgImageView addConstraint:bgImageWidth];
    }
    return _nameLabel;
}

- (UILabel *)shopnameLabel
{
    if (!_shopnameLabel) {
        _shopnameLabel = [[UILabel alloc] init];
        _shopnameLabel.translatesAutoresizingMaskIntoConstraints = NO;
        _shopnameLabel.font = [UIFont systemFontOfSize:13.0];
        _shopnameLabel.textAlignment = NSTextAlignmentRight;
        _shopnameLabel.textColor = [UIColor whiteColor];
        [self.bgImageView addSubview:_shopnameLabel];
        
        NSLayoutConstraint *bgImageTop = [NSLayoutConstraint constraintWithItem:_shopnameLabel attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.searchTextField attribute:NSLayoutAttributeBottom multiplier:1.0 constant:3];
        [self.bgImageView addConstraint:bgImageTop];
        
        NSLayoutConstraint *bgImageRight = [NSLayoutConstraint constraintWithItem:_shopnameLabel attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.nameLabel attribute:NSLayoutAttributeLeft multiplier:1.0 constant:-10];
        [self.bgImageView addConstraint:bgImageRight];
        
        NSLayoutConstraint *bgImageBottom = [NSLayoutConstraint constraintWithItem:_shopnameLabel attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.bgImageView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.bgImageView addConstraint:bgImageBottom];
        
        NSLayoutConstraint *bgImageLeft = [NSLayoutConstraint constraintWithItem:_shopnameLabel attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.bgImageView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.bgImageView addConstraint:bgImageLeft];
    }
    return _shopnameLabel;
}


- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc] initWithFrame:CGRectZero style:UITableViewStyleGrouped];
        _tableView.translatesAutoresizingMaskIntoConstraints = NO;
        _tableView.delegate = self;
        _tableView.dataSource = self;
        _tableView.showsVerticalScrollIndicator = NO;
        _tableView.showsHorizontalScrollIndicator = NO;
        _tableView.tableFooterView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, kScreenWidth, 40)];
        [_tableView registerClass:[PictureTableCell class] forCellReuseIdentifier:kHomePictureListCell];
        [_tableView registerClass:[HomeTitleTableCell class] forCellReuseIdentifier:kHomeTitleTableCell];
        [_tableView registerClass:[RankingListCell class] forCellReuseIdentifier:kHomeRankingListCell];
        [_tableView registerClass:[QuestionListTableCell class] forCellReuseIdentifier:kHomeQuestionListTableCell];

        [self.view addSubview:_tableView];
        
        NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:95];
        [self.view addConstraint:tableTop];
        
        NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self.view addConstraint:tableLeft];
        
        NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self.view addConstraint:tableRight];
        
        NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self.view addConstraint:tableBottom];
    }
    return _tableView;
}

- (void)searchClick:(UIButton *)sender
{
    [MBProgressHUD showHUDAddedTo:self.view animated:YES];
    // 口碑巡检
    NSString *url1 = [NSString stringWithFormat:@"%@%@", kRedStarURL, kRankingListURL];
    HttpClient *httpCilent1 = [[HttpClient alloc] initWithUrl:url1];
    NSDictionary *parameters1 = @{
                                 @"keyword":_searchTextField.text,
                                 @"queryOrders":@[@{@"direction":@"asc"}],
                                 @"pageNumber":@(0),
                                 @"pageSize":@(3)
                                 };
    __block HomeViewController *weakSelf = self;
    [httpCilent1 getRankingListWithParameters:parameters1 completion:^(id response, NSError *error) {
        NSLog(@"口碑排名response = %@", response);
        NSDictionary *dataDict = response[@"data"];
        NSArray *dataArray = dataDict[@"records"];
        
        NSMutableArray *rankTempArr = [NSMutableArray array];
        for (NSDictionary *ListDict in dataArray) {
            RankListModel *rankList = [RankListModel rankListModelWithDict:ListDict];
            [rankTempArr addObject:rankList];
        }
        weakSelf.allRankListArray = rankTempArr;
        [self.tableView reloadData];
        [MBProgressHUD hideHUDForView:self.view animated:YES];
    }];

    
    // 问题与知识
    NSString *url2 = [NSString stringWithFormat:@"%@%@", kRedStarURL, kQuestionListURL];
    NSString *user_uuid = [[NSUserDefaults standardUserDefaults] objectForKey:@"user_uuid"];
    NSDictionary *parameters2 = @{
                                 @"keyword":_searchTextField.text,
                                 @"user":user_uuid,
                                 @"scope":@"all",
                                 @"pageNumber":@(0),
                                 @"pageSize":@(2)
                                 };
    
    HttpClient *httpClient2 = [[HttpClient alloc] initWithUrl:url2];
    [httpClient2 getQuestionListWithParameters:parameters2 completion:^(id response, NSError *error) {
        NSDictionary *dataDict = (NSDictionary *)response[@"data"];
        NSDictionary *recordsDict = (NSDictionary *)dataDict[@"records"];
        NSLog(@"问题与知识列表recods = %@", response);
        
        NSMutableArray *questionTempArr = [NSMutableArray array];
        
        for (NSDictionary *questionDict in recordsDict) {
            QuestionModel *question = [[QuestionModel alloc] init];
            [question setValuesForKeysWithDictionary:questionDict];
            [questionTempArr addObject:question];
        }
        weakSelf.allQuestionArray = questionTempArr;
        [self.tableView reloadData];
        [MBProgressHUD hideHUDForView:self.view animated:YES];
    }];

    
    // 口碑任务
    NSString *url3 = [NSString stringWithFormat:@"%@%@", kRedStarURL, kInspectListURL];
    HttpClient *httpCilent3 = [[HttpClient alloc] initWithUrl:url3];
    NSDictionary *parameters3 = @{
                                 @"keyword":_searchTextField.text,
                                 @"userUuid":@"",
                                 @"queryOrders":@[@{@"field":@"lastModifyInfo"}],
                                 @"pageNumber":@(0),
                                 @"pageSize":@(2)
                                 };
    
    [httpCilent3 getInspectListWithParameters:parameters3 completion:^(id response, NSError *error) {
        NSLog(@"巡检列表%@", response);
        NSDictionary *dataDict = response[@"data"];
        NSArray *dataArray = dataDict[@"records"];
        NSMutableArray *inspectTempArr = [NSMutableArray array];
        for (NSDictionary *dict in dataArray) {
            TaskListModel *taskList = [[TaskListModel alloc] init];
            [taskList setValuesForKeysWithDictionary:dict];
            [inspectTempArr addObject:taskList];
        }
        _taskListDataArray = inspectTempArr;
        [self.tableView reloadData];
        [MBProgressHUD hideHUDForView:self.view animated:YES];
        
    }];

}

- (void)touchesEnded:(NSSet *)touches withEvent:(UIEvent *)event {
    [self.view endEditing:YES];
}

- (BOOL)textFieldShouldReturn:(UITextField *)textField
{
    if ([textField resignFirstResponder]) {
        return YES;
    }
    return NO;
}

@end
