//
//  MineViewController.m
//  redstar
//
//  Created by admin on 15/10/23.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "MineViewController.h"
#import "MineTableHeaderView.h"
#import "MineTableFooterView.h"
#define kMineTableViewCell @"mineTableViewCell"

@interface MineViewController () <UITableViewDelegate, UITableViewDataSource>

@property (nonatomic, strong) UITableView *tableView;
@property (nonatomic, strong) NSMutableArray *titleArray;

@property (nonatomic, strong) UIButton *quitButton;

@property (nonatomic, strong) MineTableHeaderView *headView;
@property (nonatomic, strong) MineTableFooterView *footView;
@end

@implementation MineViewController
#pragma mark - ViewDidLoad
- (void)viewDidLoad
{
    [super viewDidLoad];
    
    UILabel *customLab = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 40, 30)];
    [customLab setTextColor:[UIColor whiteColor]];
    [customLab setText:@"我的"];
    customLab.font = [UIFont boldSystemFontOfSize:19];
    self.navigationItem.titleView = customLab;
    
    UIButton *backBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    backBtn.frame = CGRectMake(0, 0, 30, 44);
    [backBtn setImage:[UIImage imageNamed:@"back_btn"] forState:UIControlStateNormal];
    [backBtn addTarget:self action:@selector(doBack:) forControlEvents:UIControlEventTouchUpInside];
    UIBarButtonItem *backItem = [[UIBarButtonItem alloc] initWithCustomView:backBtn];
    self.navigationItem.leftBarButtonItem = backItem;
    
    
    
    self.view.backgroundColor = kSectionBackGroundColor;
    self.titleArray = [NSMutableArray arrayWithObjects:@"修改密码",@"配置",@"帮助与反馈",@"关于",@"检查版本更新", nil];
    
    
    [self setupTableView];
}



- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


#pragma mark - Prative Methods

// 返回上一页面
- (void)doBack:(UIBarButtonItem *)sender
{
    [self dismissViewControllerAnimated:YES completion:nil];
}

- (void)setupTableView
{
    [self.tableView registerClass:[UITableViewCell class] forCellReuseIdentifier:kMineTableViewCell];
    
    _tableView.tableFooterView = self.footView;
    _tableView.tableHeaderView = self.headView;
    [_footView.quitButton addTarget:self action:@selector(quitLoginClick:) forControlEvents:UIControlEventTouchUpInside];
}



- (void)quitLoginClick:(UIButton *)sender
{
    NSUserDefaults *userDefault = [NSUserDefaults standardUserDefaults];
    [userDefault removeObjectForKey:@"loginMessage"];
    [userDefault removeObjectForKey:@"username"];
    [userDefault removeObjectForKey:@"password"];

    [self.tabBarController dismissViewControllerAnimated:YES completion:nil];
}

#pragma mark - TableView Delegate/DataSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return _titleArray.count;
}

// cell显示的内容
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell=[tableView dequeueReusableCellWithIdentifier:kMineTableViewCell];
    if (!cell) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kMineTableViewCell];
    }
    // 设置cell右边有个小箭头
    cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
    cell.textLabel.text = _titleArray[indexPath.row];
    cell.textLabel.font = [UIFont systemFontOfSize:15.0];
    cell.textLabel.textColor = kLightBlack;
    return cell;
}

// cell的高度
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return 45;
}

// section高度
- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 20;
}

#pragma mark - lazy loading
- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc] init];
    }
    _tableView.delegate = self;
    _tableView.dataSource = self;
    _tableView.translatesAutoresizingMaskIntoConstraints = NO;
    _tableView.backgroundColor = kMineBackGroundColor;
    [self.view addSubview:_tableView];
    
    NSLayoutConstraint *tableTop = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeTop multiplier:1.0 constant:0];
    [self.view addConstraint:tableTop];
    
    NSLayoutConstraint *tableLeft = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
    [self.view addConstraint:tableLeft];
    
    NSLayoutConstraint *tableRight = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
    [self.view addConstraint:tableRight];
    
    NSLayoutConstraint *tableBottom = [NSLayoutConstraint constraintWithItem:_tableView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.view attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
    [self.view addConstraint:tableBottom];
    
    return _tableView;
}


- (MineTableHeaderView *)headView
{
    if (!_headView) {
        _headView = [[MineTableHeaderView alloc] initWithFrame:CGRectMake(0, 0, kScreenWidth, 150)];
    }
    return _headView;
}

- (MineTableFooterView *)footView
{
    if (!_footView) {
        _footView = [[MineTableFooterView alloc] initWithFrame:CGRectMake(0, 0, kScreenWidth, kScreenHeight - 64 - 150 - 20 - 45 * 5)];
    }
    return _footView;
}





@end
