//
//  HttpClient.h
//  redstar
//
//  Created by admin on 15/11/7.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <AFNetworking.h>

typedef void (^completionBlock) (id response, NSError *error);


@interface HttpClient : NSObject
// 初始化
- (id)initWithUrl:(NSString *)url;

// 登陆初始化
- (id)initWithLogin;

// 登陆
- (void)loginWithUsername:(NSString *)username password:(NSString *)password completion:(completionBlock)completion;

// 获取问题列表
- (void)getQuestionListWithParameters:(id)parameters completion:(completionBlock)completion;

// 获取问题详情
- (void)getQuestionDetailWithParameters:(id)parameters completion:(completionBlock)completion;

// 获取巡检列表
- (void)getInspectListWithParameters:(id)parameters completion:(completionBlock)completion;

// 获取巡检排名
- (void)getRankingListWithParameters:(id)parameters completion:(completionBlock)completion;

// 获取口碑巡检明细
- (void)getPraiseDetailWithParameters:(id)parameters completion:(completionBlock)completion;

// 提交评论
- (void)submitCommentWithParameters:(id)parameters completion:(completionBlock)completion;

// 提交评论
- (void)likeCountWithParameters:(id)parameters completion:(completionBlock)completion;

// 取消点赞
- (void)cancelLikeCountWithParameters:(id)parameters completion:(completionBlock)completion;

// 上传新问题
- (void)uploadNewQuestionWithParameters:(id)parameters completion:(completionBlock)completion;

@end
