//
//  ScreenView.m
//  redstar
//
//  Created by admin on 15/11/11.
//  Copyright © 2015年 ZWF. All rights reserved.
//

#import "ScreenView.h"
#import "GroupItems.h"

#define SELECTED_VIEW_CONTROLLER_TAG 98456345
#define kScreenTabelViewCell @"screenTableViewCell"

@interface ScreenView () <GroupTabBarDelegate, UITableViewDelegate, UITableViewDataSource, UITextViewDelegate>
@property (nonatomic, strong) UILabel *placeholderLabel1;

@property (nonatomic, strong) NSArray *testArray;

@property (nonatomic, strong) UIView *backView;
@end

@implementation ScreenView

- (instancetype)initWithTitleArray:(NSArray *)titleArray
{
    self = [super init];
    if (self) {
        [self setupWithTitleArray:titleArray];
    }
    return self;
}

- (instancetype)initWithFrame:(CGRect)frame titleArray:(NSArray *)titleArray
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setupWithTitleArray:titleArray];
    }
    return self;
}

- (void)setupWithTitleArray:(NSArray *)titleArray;
{
    self.testArray = [NSArray arrayWithObjects:@"一周", @"一个月",@"三个月",@"一年",@"历史更多",nil];

    
    self.groupTabBar = [[GroupTabBar alloc] initWithFrame:CGRectMake(0, 0, 100, 180)];
    _groupTabBar.delegate = self;
    [self addSubview:_groupTabBar];
    
    self.inspectTableView = [[InspectTableView alloc] initWithTitleArray:titleArray];
    NSInteger inspectIndex = 0;
    NSIndexPath *inspectIndexPath = [NSIndexPath indexPathForRow:inspectIndex inSection:0];
    [_inspectTableView selectRowAtIndexPath:inspectIndexPath animated:NO scrollPosition:UITableViewScrollPositionNone];
    GroupItems *cyanItem = [[GroupItems alloc] initWithTitle:@"状态等于" view:_inspectTableView];
    
    self.textView = [[UITextView alloc] init];
    _textView.delegate = self;
    self.placeholderLabel1 = [[UILabel alloc] initWithFrame:CGRectMake(5, 0, 100, 30)];
    self.placeholderLabel1.text = @"请输入标题...";
    self.placeholderLabel1.font = [UIFont systemFontOfSize:15.0];
    self.placeholderLabel1.textColor = kOnLineCellDetailColor;
    [self.textView addSubview:self.placeholderLabel1];
    
    GroupItems *textItem = [[GroupItems alloc] initWithTitle:@"标题类似于" view:_textView];
    
    

    self.tableView = [[UITableView alloc] init];
    _tableView.delegate = self;
    _tableView.dataSource = self;
    NSInteger selectedIndex = 0;
    NSIndexPath *selectedIndexPath = [NSIndexPath indexPathForRow:selectedIndex inSection:0];
    [_tableView selectRowAtIndexPath:selectedIndexPath animated:NO scrollPosition:UITableViewScrollPositionNone];
    GroupItems *tableItem = [[GroupItems alloc] initWithTitle:@"时间范围" view:_tableView];

    [self insertSubview:_inspectTableView belowSubview:_groupTabBar];
    [self insertSubview:_textView belowSubview:_groupTabBar];
    [self insertSubview:_tableView belowSubview:_groupTabBar];
    
    _groupTabBar.items = @[cyanItem, textItem, tableItem];
    [_groupTabBar showIndex:0];
    
    self.backView.backgroundColor = [UIColor whiteColor];
    [self.resetBtn setTitle:@"重置" forState:UIControlStateNormal];
    [self.submitBtn setTitle:@"提交" forState:UIControlStateNormal];

}

#pragma mark - UITabelViewDelgate / DataSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return _testArray.count;
}

// cell显示的内容
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:kScreenTabelViewCell];
    if (!cell) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleValue1 reuseIdentifier:kScreenTabelViewCell];
    }
    
    cell.textLabel.text = _testArray[indexPath.row];
    cell.textLabel.font = [UIFont systemFontOfSize:14.0];
    
    UIImageView *imageView = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"iconfont-duigou2"]];
    imageView.frame = CGRectMake(kScreenWidth - self.groupTabBar.frame.size.width-30 , 15, 19, 14);
    [cell.contentView addSubview:imageView];
    
    return cell;
}

// cell的点击事件
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    
    if (_delegate) {
        [_delegate tableViewDidSelectRow:indexPath.row];
    }
}

#pragma mark - UITextView Delegate
- (BOOL)textView:(UITextView *)textView shouldChangeTextInRange:(NSRange)range replacementText:(NSString *)text {
    if (![text isEqualToString:@""]) {
        _placeholderLabel1.hidden = YES;
        
    }
    
    if ([text isEqualToString:@""] && range.location == 0 && range.length == 1) {
        _placeholderLabel1.hidden = NO;
        
    }
    
    return YES;
}



- (void)switchView:(UIView *)view
{
    UIView *currentView = [self viewWithTag:SELECTED_VIEW_CONTROLLER_TAG];
    [currentView removeFromSuperview];
    currentView = nil;
    
    view.frame = CGRectMake(self.groupTabBar.frame.size.width,0,kScreenWidth - self.groupTabBar.frame.size.width, self.groupTabBar.size.height);
    
    view.tag = SELECTED_VIEW_CONTROLLER_TAG;
    
    [self insertSubview:view belowSubview:_groupTabBar];
    
}

- (UIView *)backView
{
    if (!_backView) {
        _backView = [[UIView alloc] init];
        _backView.translatesAutoresizingMaskIntoConstraints = NO;
        [self addSubview:_backView];
        
        NSLayoutConstraint *lineViewTop = [NSLayoutConstraint constraintWithItem:_backView attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.groupTabBar attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self addConstraint:lineViewTop];
        
        NSLayoutConstraint *lineViewRight = [NSLayoutConstraint constraintWithItem:_backView attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeRight multiplier:1.0 constant:0];
        [self addConstraint:lineViewRight];
        
        NSLayoutConstraint *lineViewBottom = [NSLayoutConstraint constraintWithItem:_backView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeBottom multiplier:1.0 constant:0];
        [self addConstraint:lineViewBottom];
        
        NSLayoutConstraint *lineViewLeft = [NSLayoutConstraint constraintWithItem:_backView attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self attribute:NSLayoutAttributeLeft multiplier:1.0 constant:0];
        [self addConstraint:lineViewLeft];
    }
    return _backView;
}

- (UIButton *)resetBtn
{
    if (!_resetBtn) {
        _resetBtn = [[UIButton alloc] init];
        _resetBtn.backgroundColor = [UIColor grayColor];
        _resetBtn.translatesAutoresizingMaskIntoConstraints = NO;
        _resetBtn.layer.cornerRadius = 4.0;
        [self.backView addSubview:_resetBtn];
        
        NSLayoutConstraint *lineViewTop = [NSLayoutConstraint constraintWithItem:_resetBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.backView attribute:NSLayoutAttributeTop multiplier:1.0 constant:7.5];
        [self.backView addConstraint:lineViewTop];
        
        NSLayoutConstraint *lineViewRight = [NSLayoutConstraint constraintWithItem:_resetBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.backView attribute:NSLayoutAttributeCenterX multiplier:1.0 constant:-20];
        [self.backView addConstraint:lineViewRight];
        
        NSLayoutConstraint *lineViewBottom = [NSLayoutConstraint constraintWithItem:_resetBtn attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.backView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-7.5];
        [self.backView addConstraint:lineViewBottom];
        
        NSLayoutConstraint *lineViewLeft = [NSLayoutConstraint constraintWithItem:_resetBtn attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.backView attribute:NSLayoutAttributeLeft multiplier:1.0 constant:20];
        [self.backView addConstraint:lineViewLeft];
    }
    return _resetBtn;
}

- (UIButton *)submitBtn
{
    if (!_submitBtn) {
        _submitBtn = [[UIButton alloc] init];
        _submitBtn.backgroundColor = kNavigationBarColor;
        _submitBtn.translatesAutoresizingMaskIntoConstraints = NO;
        _submitBtn.layer.cornerRadius = 4.0;
        [self.backView addSubview:_submitBtn];
        
        NSLayoutConstraint *lineViewTop = [NSLayoutConstraint constraintWithItem:_submitBtn attribute:NSLayoutAttributeTop relatedBy:NSLayoutRelationEqual toItem:self.backView attribute:NSLayoutAttributeTop multiplier:1.0 constant:7.5];
        [self.backView addConstraint:lineViewTop];
        
        NSLayoutConstraint *lineViewRight = [NSLayoutConstraint constraintWithItem:_submitBtn attribute:NSLayoutAttributeRight relatedBy:NSLayoutRelationEqual toItem:self.backView attribute:NSLayoutAttributeRight multiplier:1.0 constant:-20];
        [self.backView addConstraint:lineViewRight];
        
        NSLayoutConstraint *lineViewBottom = [NSLayoutConstraint constraintWithItem:_submitBtn attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:self.backView attribute:NSLayoutAttributeBottom multiplier:1.0 constant:-7.5];
        [self.backView addConstraint:lineViewBottom];
        
        NSLayoutConstraint *lineViewLeft = [NSLayoutConstraint constraintWithItem:_submitBtn attribute:NSLayoutAttributeLeft relatedBy:NSLayoutRelationEqual toItem:self.backView attribute:NSLayoutAttributeCenterX multiplier:1.0 constant:20];
        [self.backView addConstraint:lineViewLeft];
    }
    return _submitBtn;
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
