//
//  CustomPageControl.m
//  Parking
//
//  Created by admin on 15/9/16.
//  Copyright (c) 2015年 moobox. All rights reserved.
//

#import "CustomPageControl.h"

#define kDotDiameter	4.0f
#define kDotSpace		12.0f

@implementation CustomPageControl

@synthesize numberOfPages ;
@synthesize currentPage ;
@synthesize hidesForSinglePage ;
@synthesize defersCurrentPageDisplay ;

@synthesize onColor ;
@synthesize offColor ;
@synthesize indicatorDiameter ;
@synthesize indicatorSpace ;

#pragma mark - init
- (id)init {
    self = [self initWithFrame:CGRectZero] ;
    return self ;
}

- (id)initWithFrame:(CGRect)frame {
    if ((self = [super initWithFrame:CGRectZero])) {
        self.backgroundColor = [UIColor clearColor] ;
    }
    return self ;
}

#pragma mark - drawRect
- (void)drawRect:(CGRect)rect {
    // 获取上下文
    CGContextRef context = UIGraphicsGetCurrentContext() ;
    CGContextSaveGState(context) ;
    CGContextSetAllowsAntialiasing(context, TRUE) ;
    
    // 判断小点点直径 间距
    CGFloat diameter = (indicatorDiameter > 0) ? indicatorDiameter : kDotDiameter ;
    CGFloat space = (indicatorSpace > 0) ? indicatorSpace : kDotSpace ;
    
    // 整个pageControl的bounds
    CGRect currentBounds = self.bounds;
    CGFloat dotsWidth = self.numberOfPages * diameter + MAX(0, self.numberOfPages - 1) * space;
    CGFloat x = CGRectGetMidX(currentBounds) - dotsWidth / 2;
    CGFloat y = CGRectGetMidY(currentBounds) - diameter / 2;
    
    // 设置选中和未选中的小点点的颜色
    CGColorRef onColorCG = onColor ? onColor.CGColor : [UIColor colorWithWhite: 1.0f alpha: 1.0f].CGColor ;
    CGColorRef offColorCG = offColor ? offColor.CGColor : [UIColor colorWithWhite: 0.7f alpha: 0.5f].CGColor ;
    
    // 遍历画（draw）点
    for (int i = 0 ; i < numberOfPages ; i++)
    {
        CGRect dotRect = CGRectMake(x, y, diameter, diameter) ;
        if (i == currentPage) {
            CGContextSetFillColorWithColor(context, onColorCG) ;
            CGContextFillEllipseInRect(context, CGRectInset(dotRect, -0.5f, -0.5f)) ;
        } else {
            CGContextSetStrokeColorWithColor(context, offColorCG) ;
            CGContextStrokeEllipseInRect(context, dotRect) ;
        }
        x += diameter + space ;
    }
    
    // 恢复画板
    CGContextRestoreGState(context) ;
}

#pragma mark - 重写setter方法
- (void)setCurrentPage:(NSInteger)pageNumber {
    if (currentPage == pageNumber) {
        return;
    }
    currentPage = MIN(MAX(0, pageNumber), numberOfPages - 1);
    
    if (self.defersCurrentPageDisplay == NO) {
        [self setNeedsDisplay];
    }
}

- (void)setNumberOfPages:(NSInteger)numOfPages {
    numberOfPages = MAX(0, numOfPages);
    currentPage = MIN(MAX(0, currentPage), numberOfPages - 1);
    self.bounds = self.bounds;
    
    [self setNeedsDisplay];
    
    if (hidesForSinglePage && (numOfPages < 2)) {
        [self setHidden: YES];
    } else {
        [self setHidden: NO];
    }
}

- (void)setHidesForSinglePage:(BOOL)hide {
    hidesForSinglePage = hide ;
    if (hidesForSinglePage && (numberOfPages < 2)){
        [self setHidden:YES];
    }
}

- (void)setDefersCurrentPageDisplay:(BOOL)defers {
    defersCurrentPageDisplay = defers ;
}


- (void)setOnColor:(UIColor *)aColor {
    onColor = aColor;
    [self setNeedsDisplay];
}

- (void)setOffColor:(UIColor *)aColor {
    offColor = aColor;
    [self setNeedsDisplay];
}

- (void)setIndicatorDiameter:(CGFloat)aDiameter {
    indicatorDiameter = aDiameter;
    self.bounds = self.bounds;
    [self setNeedsDisplay];
}

- (void)setIndicatorSpace:(CGFloat)aSpace {
    indicatorSpace = aSpace;
    self.bounds = self.bounds;
    [self setNeedsDisplay];
}

- (void)setFrame:(CGRect)aFrame {
    aFrame.size = [self sizeForNumberOfPages:numberOfPages];
    super.frame = aFrame;
}

- (void)setBounds:(CGRect)aBounds {
    aBounds.size = [self sizeForNumberOfPages: numberOfPages];
    super.bounds = aBounds;
}

#pragma mark UIPageControl methods
- (void)updateCurrentPageDisplay {
    if (self.defersCurrentPageDisplay == NO) {
        return;
    }
    [self setNeedsDisplay] ;
}

- (CGSize)sizeForNumberOfPages:(NSInteger)pageCount {
    CGFloat diameter = (indicatorDiameter > 0) ? indicatorDiameter : kDotDiameter;
    CGFloat space = (indicatorSpace > 0) ? indicatorSpace : kDotSpace;
    
    return CGSizeMake(pageCount * diameter + (pageCount - 1) * space + 44.0f, MAX(44.0f, diameter + 4.0f));
}


#pragma mark - Touches handlers
- (void)touchesEnded:(NSSet *)touches withEvent:(UIEvent *)event {
    // 获取触摸的地方
    UITouch *theTouch = [touches anyObject] ;
    CGPoint touchLocation = [theTouch locationInView: self] ;
    
    // 检测触摸的方向
    if (touchLocation.x < (self.bounds.size.width / 2)) {
        self.currentPage = MAX(self.currentPage - 1, 0);
    } else {
        self.currentPage = MIN(self.currentPage + 1, numberOfPages - 1);
    }
    [self sendActionsForControlEvents: UIControlEventValueChanged] ;
}


@end
