//
//  LanguageCell.swift
//  BreastFeedingDemo
//
//  Created by jzhang on 2022/9/26.
//

import UIKit
//import ZJTableViewManager

class LanguageCellItem: ZJTableViewItem {
    var language: ViewModel.Language!
    convenience init(language: ViewModel.Language) {
        self.init()
        self.language = language
    }
}

class LanguageCell: UITableViewCell, ZJCellProtocol {
    typealias ZJCellItemClass = LanguageCellItem
    var item: LanguageCellItem!
    @IBOutlet var titleL: UILabel!
    @IBOutlet var selectImageV: UIImageView!

    func cellWillAppear() {
        titleL.text = item.language.rawValue
    }

    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated _: Bool) {
//        super.setSelected(selected, animated: animated)
        selectImageV.isHidden = !selected
        titleL.textColor = selected ? mainColor : blackColor
    }
}
