//
//  BaseLandingVC.swift
//  BreastFeedingDemo
//
//  Created by Jie Zhang on 2022/10/7.
//

import AVFoundation
import Flutter
import UIKit

class BaseLandingVC: UIViewController {
    override func viewDidLoad() {
        super.viewDidLoad()

        viewModel.teachingEndHandler = { [weak self] in
            self?.navigationController?.popToRootViewController(animated: true)
        }

        viewModel.completeHandler = { [weak self] in
            self?.toCompleteVC()
        }
        // Do any additional setup after loading the view.
    }

    /// 检查权限
    /// - Returns: 是否有相机权限
    func checkCameraPermission() -> Bool? {
        let cameraAuthorizationStatus = AVCaptureDevice.authorizationStatus(for: .video)

        switch cameraAuthorizationStatus {
        case .notDetermined:
            return nil
        case .authorized:
            return true
        default:
            showPermissionChalenge()
            return false
        }
    }

    /// 提示权限问题
    func showPermissionChalenge() {
        let sb = UIStoryboard(name: "Main", bundle: nil)
        let vc = sb.instantiateViewController(withIdentifier: "PermissionAlertVC") as! PermissionAlertVC

        vc.modalPresentationStyle = .overCurrentContext
        present(vc, animated: true)
    }

    func toCompleteVC() {
        let sb = UIStoryboard(name: "Main", bundle: nil)
        let vc = sb.instantiateViewController(withIdentifier: "CompleteVC") as! CompleteVC
        navigationController?.pushViewController(vc, animated: true)
    }

    func showFlutterScreen() {
        let scanVC = FlutterViewController(engine: viewModel.flutterEngine, nibName: nil, bundle: nil)
        scanVC.modalPresentationStyle = .overFullScreen
        navigationController?.pushViewController(scanVC, animated: true)
    }

    @IBAction func startAction(_: Any) {
        if checkCameraPermission() == false {
            return
        }

        if !viewModel.isFirstLoad {
            viewModel.methodChannel?.invokeMethod("reload", arguments: nil)
        } else{
            FlutterViewController(engine: viewModel.flutterEngine, nibName: nil, bundle: nil).pushRoute("/camera")
        }
        viewModel.isFirstLoad = false
        showFlutterScreen()
    }
}
