//
//  DemoViewController.swift
//  BreastFeedingDemo
//
//  Created by jzhang on 2022/9/26.
//

import AVFoundation
import Flutter
import UIKit

class DemoViewController: UIViewController {
    fileprivate var popover: Popover!
    fileprivate var manager: ZJTableViewManager!
    @IBOutlet var titleL: UILabel!
    @IBOutlet var stepL1: UILabel!
    @IBOutlet var stepL2: UILabel!
    @IBOutlet var stepL3: UILabel!
    @IBOutlet var scrollView: UIScrollView!

    @IBOutlet weak var sittingTitleL: UILabel!
    @IBOutlet weak var sittingSubtitleL: UILabel!

    @IBOutlet weak var lyingTitleL: UILabel!
    @IBOutlet weak var lyingSubtitleL: UILabel!
    @IBOutlet weak var topConstraint: NSLayoutConstraint!

    override func viewDidLoad() {
        super.viewDidLoad()
        overrideUserInterfaceStyle = .light
        UIApplication.shared.isIdleTimerDisabled = true
        navigationController?.setNavigationBarHidden(true, animated: false)
        scrollView.automaticallyAdjustsScrollIndicatorInsets = false
        scrollView.contentInsetAdjustmentBehavior = .never
        updateUI()
    }

    override func viewDidAppear(_ animated: Bool) {
        super.viewDidAppear(animated)
        topConstraint.constant = view.safeAreaInsets.top
    }

    fileprivate func updateUI() {
        titleL.text = getString().homeTitle
        stepL1.text = getString().homeText1
        stepL2.text = getString().homeText2
        stepL3.text = getString().homeText3

        sittingTitleL.text = getString().sittingGesture.title
        sittingSubtitleL.text = getString().sittingGesture.subTitle
        lyingTitleL.text = getString().lyingGesture.title
        lyingSubtitleL.text = getString().lyingGesture.subTitle
    }

    /// 切换根据选择的语言更新UI
    /// - Parameter language: 语言
    fileprivate func updateUI(language: ViewModel.Language) {
        viewModel.language = language
        updateUI()
    }

    func toSideLyingLandingVC() {
        let sb = UIStoryboard(name: "Main", bundle: nil)
        let vc = sb.instantiateViewController(withIdentifier: "SideLyingLandingVC") as! SideLyingLandingVC
        navigationController?.pushViewController(vc, animated: true)
    }

    func toCradleHoldLandingVC() {
        let sb = UIStoryboard(name: "Main", bundle: nil)
        let vc = sb.instantiateViewController(withIdentifier: "CradleHoldLandingVC") as! CradleHoldLandingVC
        navigationController?.pushViewController(vc, animated: true)
    }

    @IBAction func sideLyingAction(_ sender: Any) {
        viewModel.posture = .lying

        toSideLyingLandingVC()
    }

    @IBAction func cradleHold(_: Any) {
        viewModel.posture = .cradle
        toCradleHoldLandingVC()
    }
}

extension DemoViewController {
    /// 切换语言
    @IBAction func switchLanguageAction(_ sender: UIButton) {
        let tableView = UITableView(frame: CGRect(x: 0, y: 0, width: 100, height: 135))
        tableView.isScrollEnabled = false
        if #available(iOS 15.0, *) {
            tableView.sectionHeaderTopPadding = 0
        } else {
            // Fallback on earlier versions
        }
        manager = ZJTableViewManager(tableView: tableView)
        manager.register(LanguageCell.self, LanguageCellItem.self)
        let section = ZJTableViewSection(headerHeight: 15, color: .clear)
        manager.add(section: section)
        var currentItem: LanguageCellItem?
        for i in ViewModel.Language.allCases {
            let item = LanguageCellItem(language: i)
            section.add(item: item)
            if i == viewModel.language {
                currentItem = item
            }
            item.setSelectionHandler { [weak self] (callBackItem: LanguageCellItem) in
                self?.popover.dismiss()
                self?.updateUI(language: callBackItem.language)
            }
        }
        currentItem?.select()

        popover = Popover(options: [.type(.down), .blackOverlayColor(UIColor(white: 0.0, alpha: 0.6))])
        popover.show(tableView, fromView: sender)
    }
}
