//
//  PermissionAlertVC.swift
//  BreastFeedingDemo
//
//  Created by jzhang on 2022/9/27.
//

import UIKit

class PermissionAlertVC: UIViewController {
    @IBOutlet var permissionPanel: UIView!
    @IBOutlet var permissionTitle: UILabel!
    @IBOutlet var permissionText: UILabel!
    @IBOutlet var permissionOKBtn: UIButton!

    override func viewDidLoad() {
        super.viewDidLoad()
        overrideUserInterfaceStyle = .light
        permissionText.text = getString().cameraText1
        permissionTitle.text = getString().cameraText
        permissionOKBtn.setTitle(getString().cameraButtonText, for: .normal)

        permissionPanel.layer.cornerRadius = 8
        permissionPanel.clipsToBounds = true

        // Do any additional setup after loading the view.
    }

    @IBAction func dismissAction(_: Any) {
        dismiss(animated: true)
        if let appSettingsURL = URL(string: UIApplication.openSettingsURLString) {
            UIApplication.shared.open(appSettingsURL)
        }
    }

    /*
     // MARK: - Navigation

     // In a storyboard-based application, you will often want to do a little preparation before navigation
     override func prepare(for segue: UIStoryboardSegue, sender: Any?) {
         // Get the new view controller using segue.destination.
         // Pass the selected object to the new view controller.
     }
     */
}
