//
//  MyTools.swift
//  BreastFeedingDemo
//
//  Created by jzhang on 2022/9/27.
//

import Foundation
import UIKit

protocol XibLoadable: UIView {
    static func xibLoad() -> Self
}

extension XibLoadable {
    static func xibLoad() -> Self {
        return Bundle.main.loadNibNamed("\(Self.self)", owner: nil, options: nil)?.first as! Self
    }
}

func hexStringToUIColor(hex: String) -> UIColor {
    var cString: String = hex.trimmingCharacters(in: .whitespacesAndNewlines).uppercased()

    if cString.hasPrefix("#") {
        cString.remove(at: cString.startIndex)
    }

    if (cString.count) != 6 {
        return UIColor.gray
    }

    var rgbValue: UInt64 = 0
    Scanner(string: cString).scanHexInt64(&rgbValue)

    return UIColor(
        red: CGFloat((rgbValue & 0xFF0000) >> 16) / 255.0,
        green: CGFloat((rgbValue & 0x00FF00) >> 8) / 255.0,
        blue: CGFloat(rgbValue & 0x0000FF) / 255.0,
        alpha: CGFloat(1.0)
    )
}

extension UIApplication {
    var keyWindow: UIWindow? {
        self.connectedScenes
            .filter { $0.activationState == .foregroundActive }
            .compactMap { $0 as? UIWindowScene }.first?.windows
            .filter { $0.isKeyWindow }.first
    }
}

let viewModel = ViewModel.init()
func getString() -> StringModel {
    return viewModel.string!
}
let mainColor = hexStringToUIColor(hex: "F58685")
let blackColor = hexStringToUIColor(hex: "322D31")

