  //
//  FirstViewController.m
//  红
//
//  Created by 焦钟培 on 15/12/14.
//  Copyright © 2015年 焦钟培. All rights reserved.
//

#import "FirstViewController.h"

@interface FirstViewController ()<UIScrollViewDelegate>
@property (strong, nonatomic) IBOutlet UIScrollView *scroll;
@property (strong, nonatomic) IBOutlet UIButton *button;
@property (strong, nonatomic) IBOutlet UIPageControl *control;
@end

@implementation FirstViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    _scroll.pagingEnabled = YES;
    _scroll.contentSize = CGSizeMake(KWidth * 4, 0);
    for (int i = 0; i < 4; i++) {
        UIView *view = [[UIView alloc] initWithFrame:CGRectMake(i * KWidth, 0, KWidth, KHeight)];
        [_scroll addSubview:view];
        UIImageView *imageView = [[UIImageView alloc] initWithFrame:CGRectMake(0, 0, KWidth, KHeight)];
        imageView.image = [UIImage imageNamed:[NSString stringWithFormat:@"page_%d",i]];
        [view addSubview:imageView];
    }
    _scroll.bounces = NO;
    // Do any additional setup after loading the view.
}
- (void)scrollViewDidScroll:(UIScrollView *)scrollView {
}
- (void)scrollViewDidEndDecelerating:(UIScrollView *)scrollView {
    if (scrollView.contentOffset.x == KWidth * 3) {
        _button.enabled = YES;
    } else {
        _button.enabled = NO;
    }
    _control.currentPage = scrollView.contentOffset.x/KWidth;
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


/*
#pragma mark - Navigation
  
// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
