//
//  LoginPasswordViewController.m
//  红
//
//  Created by 焦钟培 on 15/12/28.
//  Copyright © 2015年 焦钟培. All rights reserved.
//

#import "LoginPasswordViewController.h"
#import "AFNetworking.h"
#import "NSString+CommentString.h"

@interface LoginPasswordViewController ()<UITextFieldDelegate>
@property (strong, nonatomic) IBOutlet UITextField *usedPassword;
@property (strong, nonatomic) IBOutlet UITextField *firstPassword;
@property (strong, nonatomic) IBOutlet UITextField *lastPassword;
@property (strong, nonatomic) UIActivityIndicatorView *activityIndicator;

@end

@implementation LoginPasswordViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.activityIndicator = [[UIActivityIndicatorView alloc] initWithFrame:CGRectMake(100, 100, 100, 100)];
    [self.view addSubview:self.activityIndicator];
    self.activityIndicator.center = CGPointMake(KWidth/2, KHeight/2);
    self.activityIndicator.activityIndicatorViewStyle = UIActivityIndicatorViewStyleGray;
    
    _firstPassword.delegate = self;
    _lastPassword.delegate = self;
    _usedPassword.delegate = self;
    // Do any additional setup after loading the view.
}
- (BOOL)textFieldShouldReturn:(UITextField *)textField {
    [self.lastPassword resignFirstResponder];
    [self.firstPassword resignFirstResponder];
    [self.usedPassword resignFirstResponder];

    return NO;
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/
- (IBAction)buttonAction:(id)sender {
    
    if ([_usedPassword.text isEqualToString:[[NSUserDefaults standardUserDefaults] objectForKey:@"password"]]) {
        if ([_lastPassword.text isEqualToString:_firstPassword.text] && _lastPassword.text.length != 0 && _firstPassword.text.length != 0) {
            [self startHTTP];
        } else {
            NSString *cancelButtonTitle = NSLocalizedString(@"确定", nil);
            UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"提示" message:@"请输入正确的新密码" preferredStyle:UIAlertControllerStyleAlert];
            // Create the actions.
            UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:cancelButtonTitle style:UIAlertActionStyleDefault handler:^(UIAlertAction *action) {
            }];
            [alertController addAction:cancelAction];
            //弹出提示框；
            [self presentViewController:alertController animated:true completion:nil];
        }
    } else {
        NSString *cancelButtonTitle = NSLocalizedString(@"确定", nil);
        UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"提示" message:@"请输入正确的旧密码" preferredStyle:UIAlertControllerStyleAlert];
        // Create the actions.
        UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:cancelButtonTitle style:UIAlertActionStyleDefault handler:^(UIAlertAction *action) {
            
        }];
        [alertController addAction:cancelAction];
        //弹出提示框；
        [self presentViewController:alertController animated:true completion:nil];
    }
}
- (void)startHTTP {
    [self.activityIndicator startAnimating];
    AFHTTPRequestOperationManager *manager = [AFHTTPRequestOperationManager manager];
    // 设置请求格式
    manager.requestSerializer = [AFJSONRequestSerializer serializer];
    [manager.requestSerializer setValue:@"application/json" forHTTPHeaderField:@"Content-Type"];
    // 设置返回格式
    manager.responseSerializer = [AFHTTPResponseSerializer serializer];
    [manager POST:UPDATE parameters:@{@"phone":[[NSUserDefaults standardUserDefaults] objectForKey:@"phoneNum"],@"newPassword":[_firstPassword.text md5String]} success:^(AFHTTPRequestOperation *operation, id responseObject) {
        [self.activityIndicator stopAnimating];

        NSDictionary *dic = [NSJSONSerialization JSONObjectWithData:responseObject options:NSJSONReadingMutableContainers error:nil];
        NSLog(@"%@",dic);
//        NSString *result = [[NSString alloc] initWithData:responseObject encoding:NSUTF8StringEncoding];
//        id message = [dic objectForKey:@"message"];
        [self.navigationController popViewControllerAnimated:YES];
        
    } failure:^(AFHTTPRequestOperation *operation, NSError *error) {
        [self.activityIndicator stopAnimating];
        NSString *cancelButtonTitle = NSLocalizedString(@"确定", nil);
        UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"提示" message:@"网络异常" preferredStyle:UIAlertControllerStyleAlert];
        // Create the actions.
        UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:cancelButtonTitle style:UIAlertActionStyleDefault handler:^(UIAlertAction *action) {
            
        }];
        [alertController addAction:cancelAction];
        //弹出提示框；
        [self presentViewController:alertController animated:true completion:nil];
    }];
}

@end
