//
//  MainViewController.m
//  红
//
//  Created by 焦钟培 on 16/1/7.
//  Copyright © 2016年 焦钟培. All rights reserved.
//

#import "MainViewController.h"
#import "AFNetworking.h"
#import "LoginViewController.h"
#import "NSString+CommentString.h"
#import "UserSheet.h"
#import "ScrollImageView.h"
#import "CCLocationManager.h"
#import "UIImageView+WebCache.h"
#import "BannersViewController.h"
#import "AppDelegate.h"
#import "LowCostViewController.h"
#import "NoCostViewController.h"

#define IS_IOS7 ([[[UIDevice currentDevice] systemVersion] floatValue] >= 7)
#define IS_IOS8 ([[[UIDevice currentDevice] systemVersion] floatValue] >= 8)

@interface MainViewController ()<ScrollViewCycleImageDelegate, UIPickerViewDataSource, UIPickerViewDelegate, doneSelect,CLLocationManagerDelegate>{
    CLLocationManager *locationmanager;
}

@property (strong, nonatomic) IBOutlet ScrollImageView *scrollImage;
@property (strong, nonatomic) IBOutlet UIScrollView *scroll;
@property (nonatomic, strong) NSMutableArray *provincesArray;
@property (nonatomic, strong) NSMutableArray *citysArray;
@property (strong, nonatomic) IBOutlet UIView *selectView;
@property (nonatomic, strong) NSMutableArray *nameArray;
@property (nonatomic, strong) NSMutableArray *picArray;
@property (nonatomic, strong) UIView *CPView;
@property (strong, nonatomic) UIButton *selectButton;
@property (nonatomic, strong) UIPickerView *picker;
@property (strong, nonatomic) UIActivityIndicatorView *activityIndicator;
@property (nonatomic, strong)NSString *storeId;



@end

@implementation MainViewController



- (void)viewDidLoad {
    [super viewDidLoad];
    self.picArray = [NSMutableArray array];
    self.provincesArray = [NSMutableArray array];
    self.citysArray = [NSMutableArray array];
    self.nameArray = [NSMutableArray array];
    
    self.activityIndicator = [[UIActivityIndicatorView alloc] initWithFrame:CGRectMake(100, 100, 100, 100)];
    [self.view addSubview:self.activityIndicator];
    self.activityIndicator.center = CGPointMake(KWidth/2, KHeight/2);
    self.activityIndicator.activityIndicatorViewStyle = UIActivityIndicatorViewStyleGray;
    
    
    UILabel *navL = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 100, 44)];
    navL.font = [UIFont systemFontOfSize:16];
    navL.text = @"星易家居贷";
    self.navigationItem.title = @"";
    self.navigationItem.titleView = navL;
    
    self.picker = [[UIPickerView alloc] initWithFrame:CGRectMake(0, 0, KWidth, 200)];
    self.picker.dataSource = self;
    self.picker.delegate = self;
    
    [self creatScrollView];
    [self diwei];
    [self creatProScrollView];
    self.CPView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, 100, 36)];
    [self.selectView addSubview:_CPView];
    _CPView.center = CGPointMake(KWidth/2, 18);
    self.selectButton = [[UIButton alloc] initWithFrame:CGRectMake(0, 0, KWidth, 36)];
    [_selectButton addTarget:self action:@selector(selectButtonAction:) forControlEvents:UIControlEventTouchUpInside];
    [_selectView addSubview:_selectButton];
}
- (void)diwei {
    if (IS_IOS8) {
        [UIApplication sharedApplication].idleTimerDisabled = TRUE;
        locationmanager = [[CLLocationManager alloc] init];
        [locationmanager requestAlwaysAuthorization];        //NSLocationAlwaysUsageDescription
        [locationmanager requestWhenInUseAuthorization];     //NSLocationWhenInUseDescription
        locationmanager.delegate = self;
    }
    if (IS_IOS8) {
        [[CCLocationManager shareLocation] getLocationCoordinate:^(CLLocationCoordinate2D locationCorrrdinate) {
            NSLog(@"====%f %f",locationCorrrdinate.latitude,locationCorrrdinate.longitude);
            CLGeocoder *gecoder = [[CLGeocoder alloc] init];
            [gecoder reverseGeocodeLocation:[[CLLocation alloc] initWithLatitude:locationCorrrdinate.latitude longitude:locationCorrrdinate.longitude] completionHandler:^(NSArray *placemarks, NSError *error) {
                if ([placemarks count] > 0)
                {
                    for (CLPlacemark *placeMark in placemarks)
                    {
                        AppDelegate *myDelegate = [[UIApplication sharedApplication] delegate];
                        if (![myDelegate.city isEqualToString:@"城市"]) {
                            return ;
                        }
                        NSDictionary *addressDic=placeMark.addressDictionary;
                        myDelegate.city = [addressDic objectForKey:@"City"];
                        myDelegate.state = [addressDic objectForKey:@"State"];
                        [self createSelect];

                    }
                }
            }];
        }];
    }
}
- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [self.navigationController.navigationBar setBackgroundImage:[UIImage imageNamed:@""] forBarMetrics:UIBarMetricsDefault];
    self.navigationController.navigationBar.barStyle = UIBarStyleDefault;
    [self.navigationController.navigationBar setTintColor:[Comment getColor:@"4999F5"]];
    
    [self createSelect];
}
- (void)creatProScrollView {
//    23 28 225
    UIImageView *noImage = [[UIImageView alloc] initWithFrame:CGRectMake(0, 12, KWidth, KWidth/375 * 112.5)];
    noImage.image = [UIImage imageNamed:@"零利息"];
    noImage.contentMode = UIViewContentModeScaleAspectFit;
    noImage.backgroundColor = [UIColor whiteColor];
    [_scroll addSubview:noImage];
    UIView *noV = [[UIView alloc] initWithFrame:CGRectMake(0, 12 + KWidth/375 * 112.5, KWidth, 1)];
    noV.backgroundColor = [Comment getColor:@"CECFD0"];
    [_scroll addSubview:noV];
    UIButton *noButton = [[UIButton alloc] initWithFrame:noImage.frame];
    [noButton addTarget:self action:@selector(pushNoCost) forControlEvents:UIControlEventTouchUpInside];
    [_scroll addSubview:noButton];
    
    
    UIImageView *lowImage = [[UIImageView alloc] initWithFrame:CGRectMake(0, 27 + KWidth/375 * 112.5, KWidth, KWidth/375 * 112.5)];
    lowImage.image = [UIImage imageNamed:@"低利息"];
    lowImage.backgroundColor = [UIColor whiteColor];

    lowImage.contentMode = UIViewContentModeScaleAspectFit;
    [_scroll addSubview:lowImage];
    UIView *lowV = [[UIView alloc] initWithFrame:CGRectMake(0, 27 + KWidth/375 * 225, KWidth, 1)];
    lowV.backgroundColor = [Comment getColor:@"CECFD0"];
    [_scroll addSubview:lowV];
    UIButton *lowButton = [[UIButton alloc] initWithFrame:lowImage.frame];
    [lowButton addTarget:self action:@selector(pushlowCost) forControlEvents:UIControlEventTouchUpInside];
    [_scroll addSubview:lowButton];
    _scroll.contentSize = CGSizeMake(KWidth, 28 + KWidth/375 * 225);
}

- (void)pushlowCost {
    if (![self judgeStoreId]) {
        return;
    }

    UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"Main" bundle:nil];
    LowCostViewController *dev = [storyboard instantiateViewControllerWithIdentifier:@"LowCostViewController"];
    dev.storeId = self.storeId;
    [self.navigationController pushViewController:dev animated:YES];
}
- (void)pushNoCost {
    if (![self judgeStoreId]) {
        return;
    }
    UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"Main" bundle:nil];
    NoCostViewController *dev = [storyboard instantiateViewControllerWithIdentifier:@"NoCostViewController"];
    dev.storeId = self.storeId;
    [self.navigationController pushViewController:dev animated:YES];
    
}
- (BOOL)judgeStoreId {
    if (_storeId.length == 0) {
        
        NSString *cancelButtonTitle = NSLocalizedString(@"确定", nil);
        UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"提示" message:@"请选择商场" preferredStyle:UIAlertControllerStyleAlert];
        // Create the actions.
        UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:cancelButtonTitle style:UIAlertActionStyleDefault handler:^(UIAlertAction *action) {
            
        }];
        [alertController addAction:cancelAction];
        //弹出提示框；
        [self presentViewController:alertController animated:true completion:nil];
        return NO;
    } else {
        return YES;
    }
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}
- (void)creatScrollView{
    _scrollImage.numberImage = 1;//图片张数
    _scrollImage.pageControlPosition = PageControlPosition_Center;//pagecontrol样式
    self.scrollImage.delegate = self;//设置代理人
    [_scrollImage creatScroll];
}

- (void)getValue {
    NSFileManager * file = [NSFileManager defaultManager];
    NSArray * array = NSSearchPathForDirectoriesInDomains(NSLibraryDirectory, NSUserDomainMask, YES);
    NSString * string = [NSString stringWithFormat:@"%@/%@",[array firstObject],[GETSTORES stringByReplacingOccurrencesOfString:@"/" withString:@""]];
    BOOL judge = [file fileExistsAtPath:string];
    //判断一个文件是否存在
    if (judge) {
        NSData * data = [NSData dataWithContentsOfFile:string];
        NSDictionary *dic = [NSKeyedUnarchiver unarchiveObjectWithData:data];
        [self.provincesArray addObjectsFromArray:[dic objectForKey:@"provinces"]];
        [_citysArray addObjectsFromArray:[[_provincesArray objectAtIndex:0] objectForKey:@"citys"]];
        [_nameArray addObjectsFromArray:[[_citysArray objectAtIndex:0] objectForKey:@"stores"]];
        UserSheet *sheet = [[UserSheet alloc] initWithView:_picker AndHeight:244];
        sheet.doneDelegate = self;
        [self selectPicker];
        [sheet showInView:self.view];
    } else {
        [self.activityIndicator startAnimating];
        NSString *postUrl = GETSTORES;
        AFHTTPRequestOperationManager *manager = [AFHTTPRequestOperationManager manager];
        // 设置请求格式
        manager.requestSerializer = [AFJSONRequestSerializer serializer];
        [manager.requestSerializer setValue:@"application/json" forHTTPHeaderField:@"Content-Type"];
        // 设置返回格式
        manager.responseSerializer = [AFHTTPResponseSerializer serializer];
        [manager POST:postUrl parameters:nil success:^(AFHTTPRequestOperation *operation, id responseObject) {
            [self.activityIndicator stopAnimating];
            NSDictionary *dic = [NSJSONSerialization JSONObjectWithData:responseObject options:NSJSONReadingMutableContainers error:nil];
            NSLog(@"%@",dic);
            NSString *result = [[NSString alloc] initWithData:responseObject encoding:NSUTF8StringEncoding];
            NSLog(@"%@", result);
            NSData *data = [NSKeyedArchiver archivedDataWithRootObject:dic];
            NSArray *dataArray = NSSearchPathForDirectoriesInDomains(NSLibraryDirectory, NSUserDomainMask, YES);
            NSString * string = [NSString stringWithFormat:@"%@/%@",[dataArray firstObject],[GETSTORES stringByReplacingOccurrencesOfString:@"/" withString:@""]];
            [data writeToFile:string atomically:YES];
            
            [self.provincesArray removeAllObjects];
            [self.provincesArray addObjectsFromArray:[dic objectForKey:@"provinces"]];
            UserSheet *sheet = [[UserSheet alloc] initWithView:_picker AndHeight:244];
            sheet.doneDelegate = self;
            [self selectPicker];
            [sheet showInView:self.view];
        } failure:^(AFHTTPRequestOperation *operation, NSError *error) {
            [self.activityIndicator stopAnimating];
            NSString *cancelButtonTitle = NSLocalizedString(@"确定", nil);
            UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"提示" message:@"网络异常请重试" preferredStyle:UIAlertControllerStyleAlert];
            // Create the actions.
            UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:cancelButtonTitle style:UIAlertActionStyleDefault handler:^(UIAlertAction *action) {
                
            }];
            [alertController addAction:cancelAction];
            //弹出提示框；
            [self presentViewController:alertController animated:true completion:nil];
        }];
    }
}

//设置图片
-(void)scrollImagePlayerView:(ScrollImageView *)imagePlayerView loadImageForImageView:(UIImageView *)imageView index:(NSInteger)index{
    imageView.image = [UIImage imageNamed:@"首页banner最终"];
    imageView.contentMode = UIViewContentModeScaleAspectFill;
}
//图片点击事件
- (void)scrollImagePlayerView:(ScrollImageView *)imagePlayerView didTapAtIndex:(NSInteger)index{
}
- (IBAction)selectButtonAction:(id)sender {
    [self getValue];
}
- (void)selectPicker {
    AppDelegate *myDelegate = [[UIApplication sharedApplication] delegate];
    for (int i = 0; i < [_provincesArray count]; i++) {
        if ([myDelegate.city isEqualToString:@"城市" ]) {
            return;
        }
        if ([myDelegate.state isEqualToString:[[_provincesArray objectAtIndex:i] objectForKey:@"provinceName"]]) {
            [_picker selectRow:i inComponent:0 animated:YES];
            
            [_citysArray removeAllObjects];
            [_citysArray addObjectsFromArray:[[_provincesArray objectAtIndex:i] objectForKey:@"citys"]];
            [_picker reloadComponent:1];
            [_nameArray removeAllObjects];
            [_nameArray addObjectsFromArray:[[_citysArray objectAtIndex:0] objectForKey:@"stores"]];
            [_picker reloadComponent:2];
            
            NSArray *array = [[_provincesArray objectAtIndex:i] objectForKey:@"citys"];
            for (int j = 0; j < [array count]; j++) {
                if ([myDelegate.city isEqualToString:[[array objectAtIndex:j] objectForKey:@"cityName"]]) {
                    [_picker selectRow:j inComponent:1 animated:YES];
                    [_nameArray removeAllObjects];
                    [_nameArray addObjectsFromArray:[[_citysArray objectAtIndex:j] objectForKey:@"stores"]];
                    [_picker reloadComponent:2];
                }
            }
        }
    }
}

- (void)createSelect {
    for (UIView *view in _CPView.subviews) {
        [view removeFromSuperview];
    }
    AppDelegate *myDelegate = [[UIApplication sharedApplication] delegate];
    UILabel *cityL = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 10, 36)];
    cityL.font = [UIFont systemFontOfSize:14];
    cityL.text = myDelegate.city;
    [cityL sizeToFit];
    cityL.center = CGPointMake(cityL.center.x, 18);
    [_CPView addSubview:cityL];
    
    UIView *backView = [[UIView alloc] initWithFrame:CGRectMake(cityL.frame.size.width + 15, 6, 2, 24)];
    backView.backgroundColor = [Comment getColor:@"CECFD0"];
    [_CPView addSubview:backView];
    
    UILabel *shopL = [[UILabel alloc] initWithFrame:CGRectMake(cityL.frame.size.width + 32, 0, 10, 36)];
    shopL.font = [UIFont systemFontOfSize:14];
    shopL.text = myDelegate.shop;
    [shopL sizeToFit];
    shopL.center = CGPointMake(shopL.center.x, 18);
    [_CPView addSubview:shopL];
    
    UIImageView *imageView = [[UIImageView alloc] initWithFrame:CGRectMake(cityL.frame.size.width + 37 + shopL.frame.size.width, 13, 15, 8)];
    imageView.image = [UIImage imageNamed:@"三角图标"];
    [_CPView addSubview:imageView];
    cityL.textColor = [Comment getColor:@"666666"];
    shopL.textColor = [Comment getColor:@"666666"];
    _CPView.frame =CGRectMake(0, 0, cityL.frame.size.width + 37 + shopL.frame.size.width + 15, 36);
    _CPView.center = CGPointMake(KWidth/2, 18);
    
}

- (NSInteger)numberOfComponentsInPickerView:(UIPickerView*)pickerView {
    return 3;
}

- (NSInteger)pickerView:(UIPickerView *)pickerView numberOfRowsInComponent:(NSInteger)component {
    if (component == 0) {
        return [_provincesArray count];
    }
    if (component == 1) {
        return [_citysArray count];
    }
    return [_nameArray count];
}

- (NSString *)pickerView:(UIPickerView *)pickerView titleForRow:(NSInteger)row forComponent:(NSInteger)component {
    if (component == 0) {
        return [[_provincesArray objectAtIndex:row] objectForKey:@"provinceName"];
    }
    if (component == 1) {
        return [[_citysArray objectAtIndex:row] objectForKey:@"cityName"];
    }
    return [[_nameArray objectAtIndex:row] objectForKey:@"name"];
}
- (void)pickerView:(UIPickerView *)pickerView didSelectRow: (NSInteger)row inComponent:(NSInteger)component {
    if (component == 0) {
        NSInteger selecRow = [_picker selectedRowInComponent:0];
        [_citysArray removeAllObjects];
        [_citysArray addObjectsFromArray:[[_provincesArray objectAtIndex:selecRow] objectForKey:@"citys"]];
        [pickerView reloadComponent:1];
        [_nameArray removeAllObjects];
        [_nameArray addObjectsFromArray:[[_citysArray objectAtIndex:0] objectForKey:@"stores"]];
        [pickerView reloadComponent:2];
    }
    if (component == 1) {
        NSInteger selecRow = [_picker selectedRowInComponent:1];
        [_nameArray removeAllObjects];
        [_nameArray addObjectsFromArray:[[_citysArray objectAtIndex:selecRow] objectForKey:@"stores"]];
        [pickerView reloadComponent:2];
    }
}
- (void)done {
    NSInteger selecRowP = [_picker selectedRowInComponent:0];
    NSInteger selecRowC = [_picker selectedRowInComponent:1];
    NSInteger selecRowN = [_picker selectedRowInComponent:2];
    AppDelegate *myDelegate = [[UIApplication sharedApplication] delegate];
    myDelegate.state = [[_provincesArray objectAtIndex:selecRowP] objectForKey:@"provinceName"];
    
    myDelegate.city = [[[[_provincesArray objectAtIndex:selecRowP] objectForKey:@"citys"] objectAtIndex:selecRowC] objectForKey:@"cityName"];
    myDelegate.shop = [[[[[[_provincesArray objectAtIndex:selecRowP] objectForKey:@"citys"] objectAtIndex:selecRowC] objectForKey:@"stores"] objectAtIndex:selecRowN] objectForKey:@"name"];
    myDelegate.shopId = [[[[[[_provincesArray objectAtIndex:selecRowP] objectForKey:@"citys"] objectAtIndex:selecRowC] objectForKey:@"stores"] objectAtIndex:selecRowN] objectForKey:@"id"];
    
    myDelegate.shopAddress = [[[[[[_provincesArray objectAtIndex:selecRowP] objectForKey:@"citys"] objectAtIndex:selecRowC] objectForKey:@"stores"] objectAtIndex:selecRowN] objectForKey:@"address"];
    _storeId = [NSString stringWithFormat:@"%@",[[[[[[_provincesArray objectAtIndex:selecRowP] objectForKey:@"citys"] objectAtIndex:selecRowC] objectForKey:@"stores"] objectAtIndex:selecRowN] objectForKey:@"id"]];
    [self createSelect];

}

- (UIView *)pickerView:(UIPickerView *)pickerView viewForRow:(NSInteger)row forComponent:(NSInteger)component reusingView:(UIView *)view{
    UILabel* pickerLabel = (UILabel*)view;
    if (!pickerLabel){
        pickerLabel = [[UILabel alloc] init];
        pickerLabel.adjustsFontSizeToFitWidth = YES;
        pickerLabel.textAlignment = NSTextAlignmentCenter;
        [pickerLabel setBackgroundColor:[UIColor clearColor]];
        [pickerLabel setFont:[UIFont boldSystemFontOfSize:15]];
    }
    // Fill the label text here
    pickerLabel.text=[self pickerView:pickerView titleForRow:row forComponent:component];
    return pickerLabel;
}
@end
