//
//  NHViewController.m
//  红
//
//  Created by 焦钟培 on 16/5/9.
//  Copyright © 2016年 焦钟培. All rights reserved.
//

#import "NHViewController.h"
#import "AFNetworking.h"
#import "LoanTableViewCell.h"
#import "WebViewController.h"

@interface NHViewController ()<UITableViewDelegate, UITableViewDataSource>
@property (strong, nonatomic) IBOutlet UITableView *table;
@property (strong, nonnull) NSMutableArray *tableArray;
@property (strong, nonatomic) UIActivityIndicatorView *activityIndicator;
@property (strong, nonatomic) UIAlertController *alert;


@end

@implementation NHViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.activityIndicator = [[UIActivityIndicatorView alloc] initWithFrame:CGRectMake(100, 100, 100, 100)];
    self.alert = [UIAlertController alertControllerWithTitle:@"连接服务器失败" message:nil preferredStyle:UIAlertControllerStyleAlert];

    [self.view addSubview:self.activityIndicator];
    self.activityIndicator.center = CGPointMake(KWidth/2, KHeight/2);
    self.activityIndicator.activityIndicatorViewStyle = UIActivityIndicatorViewStyleGray;
    self.tableArray = [NSMutableArray array];
    [self startRequest];
    // Do any additional setup after loading the view.
}
- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    UILabel *navL = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 100, 44)];
    navL.text = @"待支付订单";
    navL.textAlignment = NSTextAlignmentCenter;
    navL.font = [UIFont systemFontOfSize:16];
    self.navigationItem.title = @"";
    self.navigationItem.titleView = navL;
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return [_tableArray count];
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *CellIdentifier = @"LoanTableViewCell";
    LoanTableViewCell *cell = (LoanTableViewCell*)[tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil) {
        cell= (LoanTableViewCell *)[[[NSBundle  mainBundle]  loadNibNamed:@"LoanTableViewCell" owner:self options:nil]  lastObject];
    }
    if (indexPath.row == [_tableArray count] - 1) {
        cell.first.hidden = YES;
        cell.last.hidden = NO;
    }
    NSDictionary *dic = [_tableArray objectAtIndex:indexPath.row];
    cell.shop.text = [dic objectForKey:@"bankName"];
    cell.type.text = [dic objectForKey:@"storeName"];
    cell.money.text = [NSString stringWithFormat:@"￥%@0000",[dic objectForKey:@"amount"]];
    [cell.money setTextColor:[UIColor redColor]];
    cell.pic.image = [UIImage imageNamed:@"农行"];
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    return cell;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    return 92;
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    [_activityIndicator startAnimating];

    AFHTTPRequestOperationManager *manager = [AFHTTPRequestOperationManager manager];
    // 设置请求格式
    manager.requestSerializer = [AFJSONRequestSerializer serializer];
    [manager.requestSerializer setValue:@"application/json" forHTTPHeaderField:@"Content-Type"];
    // 设置返回格式
    manager.responseSerializer = [AFHTTPResponseSerializer serializer];
    NSNumber *number = [[_tableArray objectAtIndex:indexPath.row] objectForKey:@"applyId"];
    
    [manager POST:GETNOPAYORDERURL parameters:@{@"applyId":number} success:^(AFHTTPRequestOperation *operation, id responseObject) {
        [_activityIndicator stopAnimating];
        NSDictionary *dic = [NSJSONSerialization JSONObjectWithData:responseObject options:NSJSONReadingMutableContainers error:nil];
        BOOL returnFormNH = [[dic objectForKey:@"status"] boolValue];
        if (returnFormNH) {
            WebViewController *web = [[WebViewController alloc] init];
            web.payUrl = [NSString stringWithFormat:@"%@",[[dic objectForKey:@"applyInfo"] objectForKey:@"payUrl"]];
            [self.navigationController pushViewController:web animated:YES];
        } else {
            [self presentViewController:_alert animated:true completion:nil];
            [NSTimer scheduledTimerWithTimeInterval:1 target:self selector:@selector(dismissViewController) userInfo:nil repeats:NO];
        }
    } failure:^(AFHTTPRequestOperation *operation, NSError *error) {
        [_activityIndicator stopAnimating];
        [self presentViewController:_alert animated:true completion:nil];
        [NSTimer scheduledTimerWithTimeInterval:1 target:self selector:@selector(dismissViewController) userInfo:nil repeats:NO];
    }];
}
- (void)startRequest {
    [_activityIndicator startAnimating];
    AFHTTPRequestOperationManager *manager = [AFHTTPRequestOperationManager manager];
    // 设置请求格式
    manager.requestSerializer = [AFJSONRequestSerializer serializer];
    [manager.requestSerializer setValue:@"application/json" forHTTPHeaderField:@"Content-Type"];
    // 设置返回格式
    manager.responseSerializer = [AFHTTPResponseSerializer serializer];
    
    [manager POST:NOPAYORDER parameters:@{@"userId":[[NSUserDefaults standardUserDefaults] objectForKey:@"userId"]} success:^(AFHTTPRequestOperation *operation, id responseObject) {
        [_activityIndicator stopAnimating];
        
        NSDictionary *dic = [NSJSONSerialization JSONObjectWithData:responseObject options:NSJSONReadingMutableContainers error:nil];
        [self.tableArray removeAllObjects];
        [self.tableArray addObjectsFromArray:[dic objectForKey:@"result"]];
        [_table reloadData];
        NSLog(@"%@",dic);
        
    } failure:^(AFHTTPRequestOperation *operation, NSError *error) {
        [_activityIndicator stopAnimating];
        [self presentViewController:_alert animated:true completion:nil];
        [NSTimer scheduledTimerWithTimeInterval:1 target:self selector:@selector(dismissViewController) userInfo:nil repeats:NO];
    }];
}
- (void)dismissViewController {
    [_alert dismissViewControllerAnimated:YES completion:nil];
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
