//
//  NoCostViewController.m
//  红
//
//  Created by 焦钟培 on 15/12/17.
//  Copyright © 2015年 焦钟培. All rights reserved.
//

#import "NoCostViewController.h"
#import "NoCostTableViewCell.h"
#import "CostDetailViewController.h"
#import "AFNetworking.h"
#import "UserSheet.h"
#import "AboutViewController.h"
#import "AppDelegate.h"

@interface NoCostViewController ()<UITableViewDataSource, UITableViewDelegate,UIPickerViewDataSource, UIPickerViewDelegate, doneSelect>
@property (nonatomic, strong) NSMutableArray *provincesArray;
@property (strong, nonatomic) IBOutlet UILabel *nillLable;
@property (nonatomic, strong) NSMutableArray *citysArray;
@property (nonatomic, strong) NSMutableArray *nameArray;
@property (nonatomic, strong) UIView *CPView;
@property (strong, nonatomic) UIButton *selectButton;
@property (nonatomic, strong) UIPickerView *picker;
@property (strong, nonatomic) IBOutlet UIView *selectView;
@property (nonatomic, strong) NSMutableArray *picArray;

@property (strong, nonatomic) UIActivityIndicatorView *activityIndicator;

@property (nonatomic, strong) NSMutableArray *tableArray;
@property (strong, nonatomic) IBOutlet UITableView *table;
@end

@implementation NoCostViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.nillLable.text = @"该商场还未开通服务\n请查看其他商场哦！";

    self.activityIndicator = [[UIActivityIndicatorView alloc] initWithFrame:CGRectMake(100, 100, 100, 100)];
    [self.view addSubview:self.activityIndicator];
    self.activityIndicator.center = CGPointMake(KWidth/2, KHeight/2);
    self.activityIndicator.activityIndicatorViewStyle = UIActivityIndicatorViewStyleGray;
    
    self.button.layer.cornerRadius = 11;
    self.button.layer.masksToBounds = YES;
    self.button.layer.borderWidth = 1;
    self.button.layer.borderColor = [[Comment getColor:@"FECFD5"] CGColor];
    self.tableArray = [NSMutableArray array];
    [self startRequest];
    self.provincesArray = [NSMutableArray array];
    self.citysArray = [NSMutableArray array];
    self.nameArray = [NSMutableArray array];
    self.picker = [[UIPickerView alloc] initWithFrame:CGRectMake(0, 0, KWidth, 200)];
    self.picker.dataSource = self;
    self.picker.delegate = self;
    self.CPView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, 100, 36)];
    [self.selectView addSubview:_CPView];
    _CPView.center = CGPointMake(KWidth/2, 18);
    self.selectButton = [[UIButton alloc] initWithFrame:CGRectMake(0, 0, KWidth, 36)];
    [_selectButton addTarget:self action:@selector(selectButtonAction:) forControlEvents:UIControlEventTouchUpInside];
    [_selectView addSubview:_selectButton];
    [self createSelect];
    // Do any additional setup after loading the view.
}
- (void)startRequest {
    [self.activityIndicator startAnimating];
    NSString *postUrl = GETBYSTOREURL;
    NSDictionary *dic = @{@"storeId":[NSNumber numberWithInteger:[_storeId integerValue]],@"isZero":@true};
    AFHTTPRequestOperationManager *manager = [AFHTTPRequestOperationManager manager];
    // 设置请求格式
    manager.requestSerializer = [AFJSONRequestSerializer serializer];
    [manager.requestSerializer setValue:@"application/json" forHTTPHeaderField:@"Content-Type"];
    // 设置返回格式
    manager.responseSerializer = [AFHTTPResponseSerializer serializer];
    [manager POST:postUrl parameters:dic success:^(AFHTTPRequestOperation *operation, id responseObject) {
        [self.activityIndicator stopAnimating];
        NSDictionary *dic = [NSJSONSerialization JSONObjectWithData:responseObject options:NSJSONReadingMutableContainers error:nil];
        NSLog(@"%@",dic);
        NSString *result = [[NSString alloc] initWithData:responseObject encoding:NSUTF8StringEncoding];
        NSLog(@"%@", result);
        [self.tableArray removeAllObjects];
        [self.tableArray addObjectsFromArray:[dic objectForKey:@"bankProduct"]];
        [_table reloadData];
        
        AppDelegate *myDelegate = [[UIApplication sharedApplication] delegate];
        NSData *data = [NSKeyedArchiver archivedDataWithRootObject:dic];
        NSArray *array = NSSearchPathForDirectoriesInDomains(NSLibraryDirectory, NSUserDomainMask, YES);
        NSString * string = [NSString stringWithFormat:@"%@/%@%@%@",[array firstObject],[GETBYSTOREURL stringByReplacingOccurrencesOfString:@"/" withString:@""],@"0",myDelegate.shop];
        [data writeToFile:string atomically:YES];
        if ([_tableArray count]==0) {
            self.nillLable.hidden = NO;
        } else {
            self.nillLable.hidden = YES;
        }
    } failure:^(AFHTTPRequestOperation *operation, NSError *error) {
        NSLog(@"1");
        [self.activityIndicator stopAnimating];

        NSFileManager * file = [NSFileManager defaultManager];
        NSArray * array = NSSearchPathForDirectoriesInDomains(NSLibraryDirectory, NSUserDomainMask, YES);
        AppDelegate *myDelegate = [[UIApplication sharedApplication] delegate];
        NSString * string = [NSString stringWithFormat:@"%@/%@%@%@",[array firstObject],[GETBYSTOREURL stringByReplacingOccurrencesOfString:@"/" withString:@""],@"0",myDelegate.shop];
        BOOL judge = [file fileExistsAtPath:string];
        //判断一个文件是否存在
        [self.tableArray removeAllObjects];
        if (judge) {
            NSData * data = [NSData dataWithContentsOfFile:string];
            NSDictionary *dic = [NSKeyedUnarchiver unarchiveObjectWithData:data];
            [self.tableArray addObjectsFromArray:[dic objectForKey:@"bankProduct"]];
            [_table reloadData];
            if ([_tableArray count]==0) {
                self.nillLable.hidden = NO;
                
            } else {
                self.nillLable.hidden = YES;
            }

        } else {
            self.nillLable.hidden = NO;

        }
    }];
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return [_tableArray count] * 2
    ;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    if (indexPath.row % 2 ==  0) {
        static NSString *CellIdentifier = @"UITableViewCell";
        UITableViewCell *cell = (UITableViewCell*)[tableView dequeueReusableCellWithIdentifier:CellIdentifier];
        if (cell == nil)
        {
            cell= [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:CellIdentifier];
        }
        cell.backgroundColor = [UIColor clearColor];
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        return cell;
    }
    static NSString *CellIdentifier = @"NoCostTableViewCell";
    NoCostTableViewCell *cell = (NoCostTableViewCell*)[tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil)
    {
        cell= (NoCostTableViewCell *)[[[NSBundle  mainBundle]  loadNibNamed:@"NoCostTableViewCell" owner:self options:nil]  lastObject];
    }
    NSDictionary * dicN = [[_tableArray objectAtIndex:indexPath.row/2] objectForKey:@"bank"];
    NSDictionary * dicD = [[_tableArray objectAtIndex:indexPath.row/2] objectForKey:@"bankProduct"];
    if (![[dicD objectForKey:@"hasBankPay"] isEqual:@YES]) {
        cell.pic.hidden = YES;
    }
    cell.bank.text = [NSString stringWithFormat:@"零利息-最高可贷%@万",[dicD objectForKey:@"maxAmount"]];
    cell.detail.text = [NSString stringWithFormat:@"合作金融机构%@",[dicN objectForKey:@"name"]];
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    return cell;
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    if (indexPath.row == 0) {
        return 12.5;
    }
    if (indexPath.row % 2 == 0) {
        return 15;
    }
    return 100;
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"Main" bundle:nil];
    CostDetailViewController *dev = [storyboard instantiateViewControllerWithIdentifier:@"CostDetailViewController"];
    NSDictionary * bankDic = [[_tableArray objectAtIndex:indexPath.row/2] objectForKey:@"bank"];
    NSDictionary * productDic = [[_tableArray objectAtIndex:indexPath.row/2] objectForKey:@"bankProduct"];
    NSDictionary * returnMethodsDic = [[[_tableArray objectAtIndex:indexPath.row/2] objectForKey:@"returnMethods"] firstObject];
    NSArray * returnMethodsArray = [[_tableArray objectAtIndex:indexPath.row/2] objectForKey:@"returnMethods"];
    dev.returnMonthsArray = [NSMutableArray arrayWithArray:returnMethodsArray];
    dev.isZore = YES;
    dev.hasBankPay = [[productDic objectForKey:@"hasBankPay"] boolValue];
    dev.bankID = [NSString stringWithFormat:@"%@",[bankDic objectForKey:@"id"]];
    AppDelegate *myDelegate = [[UIApplication sharedApplication] delegate];
    dev.headerDetails = [[NSString stringWithFormat:@"商场地址：%@\n%@",myDelegate.shopAddress,[productDic objectForKey:@"description"]] stringByReplacingOccurrencesOfString:@"|" withString:@"\n"];
    dev.minAmount = [NSString stringWithFormat:@"%@",[productDic objectForKey:@"minAmount"]];
    dev.maxAmount = [NSString stringWithFormat:@"%@",[productDic objectForKey:@"maxAmount"]];
    dev.storeId = _storeId;
    dev.interest = [NSString stringWithFormat:@"%@",[returnMethodsDic objectForKey:@"interest"]];
    dev.returnType = [NSString stringWithFormat:@"%@",[productDic objectForKey:@"typeId"]];
    dev.bankName = [bankDic objectForKey:@"name"];
    
    [self.navigationController pushViewController:dev animated:YES];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}
/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/
- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [self.navigationController.navigationBar setBackgroundImage:[UIImage imageNamed:@"nav"] forBarMetrics:UIBarMetricsDefault];
    self.navigationController.navigationBar.barStyle = UIBarStyleBlackTranslucent;
    self.navigationController.navigationBar.shadowImage = [[UIImage alloc] init];
    [self.navigationController.navigationBar setTintColor:[UIColor whiteColor]];
    UILabel *navL = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 100, 44)];
    navL.font = [UIFont systemFontOfSize:16];
    navL.textAlignment = NSTextAlignmentCenter;

    self.navigationItem.title = @"";
    self.navigationItem.titleView = navL;
}
- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    [self.navigationController.navigationBar setBackgroundImage:[UIImage imageNamed:@""] forBarMetrics:UIBarMetricsDefault];
    self.navigationController.navigationBar.barStyle = UIBarStyleDefault;
    [self.navigationController.navigationBar setTintColor:[Comment getColor:@"4999F5"]];
}
- (IBAction)buttonAction:(id)sender {
    UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"Main" bundle:nil];
    AboutViewController *dev = [storyboard instantiateViewControllerWithIdentifier:@"AboutViewController"];
    dev.navStr = @"零利息介绍";
    dev.title = @"        “零利息家居贷”是“星易∙家居贷”系列产品之一由红星美凯龙与金融机构联合，向具有实际家装需求的客户提供家居信贷专项授信，金融机构将授信金额受托支付至红星美凯龙星易通汇账户后，红星美凯龙将同等金额的通汇卡提供给客户，以通汇卡作为消费支付载体，再由客户向金融机构分期偿还本金及费用/利息的业务。\n        零利息家居贷产品特点\n        1，0首付，0利息，0手续费\n        2，红星美凯龙补贴2%手续费\n        3，产品无抵押、无担保、纯信用\n        4，额度高，放款快，种类多\n        5，贷款转存通汇卡、红星美凯龙指定门店购物消费";
    [self.navigationController pushViewController:dev animated:YES];
}
- (void)createSelect {
    for (UIView *view in _CPView.subviews) {
        [view removeFromSuperview];
    }
    AppDelegate *myDelegate = [[UIApplication sharedApplication] delegate];
    UILabel *cityL = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 10, 36)];
    cityL.font = [UIFont systemFontOfSize:14];
    cityL.text = myDelegate.city;
    [cityL sizeToFit];
    cityL.center = CGPointMake(cityL.center.x, 18);
    [_CPView addSubview:cityL];
    
    UIView *backView = [[UIView alloc] initWithFrame:CGRectMake(cityL.frame.size.width + 15, 6, 2, 24)];
    backView.backgroundColor = [Comment getColor:@"CECFD0"];
    [_CPView addSubview:backView];
    
    UILabel *shopL = [[UILabel alloc] initWithFrame:CGRectMake(cityL.frame.size.width + 32, 0, 10, 36)];
    shopL.font = [UIFont systemFontOfSize:14];
    shopL.text = myDelegate.shop;
    [shopL sizeToFit];
    shopL.center = CGPointMake(shopL.center.x, 18);
    [_CPView addSubview:shopL];
    
    UIImageView *imageView = [[UIImageView alloc] initWithFrame:CGRectMake(cityL.frame.size.width + 37 + shopL.frame.size.width, 13, 15, 8)];
    imageView.image = [UIImage imageNamed:@"三角图标"];
    [_CPView addSubview:imageView];
    cityL.textColor = [Comment getColor:@"666666"];
    shopL.textColor = [Comment getColor:@"666666"];
    _CPView.frame =CGRectMake(0, 0, cityL.frame.size.width + 37 + shopL.frame.size.width + 15, 36);
    _CPView.center = CGPointMake(KWidth/2, 18);
    
}
- (IBAction)selectButtonAction:(id)sender {
    [self getValue];
}
- (void)getValue {
    NSFileManager * file = [NSFileManager defaultManager];
    NSArray * array = NSSearchPathForDirectoriesInDomains(NSLibraryDirectory, NSUserDomainMask, YES);
    NSString * string = [NSString stringWithFormat:@"%@/%@",[array firstObject],[GETSTORES stringByReplacingOccurrencesOfString:@"/" withString:@""]];
    BOOL judge = [file fileExistsAtPath:string];
    //判断一个文件是否存在
    if (judge) {
        NSData * data = [NSData dataWithContentsOfFile:string];
        NSDictionary *dic = [NSKeyedUnarchiver unarchiveObjectWithData:data];
        [self.provincesArray addObjectsFromArray:[dic objectForKey:@"provinces"]];
        [_citysArray addObjectsFromArray:[[_provincesArray objectAtIndex:0] objectForKey:@"citys"]];
        [_nameArray addObjectsFromArray:[[_citysArray objectAtIndex:0] objectForKey:@"stores"]];
        UserSheet *sheet = [[UserSheet alloc] initWithView:_picker AndHeight:244];
        sheet.doneDelegate = self;
        [self selectPicker];
        [sheet showInView:self.view];
    
    }
}
- (void)selectPicker {
    AppDelegate *myDelegate = [[UIApplication sharedApplication] delegate];
    for (int i = 0; i < [_provincesArray count]; i++) {
        
        if ([myDelegate.state isEqualToString:[[_provincesArray objectAtIndex:i] objectForKey:@"provinceName"]]) {
            [_picker selectRow:i inComponent:0 animated:YES];
            
            [_citysArray removeAllObjects];
            [_citysArray addObjectsFromArray:[[_provincesArray objectAtIndex:i] objectForKey:@"citys"]];
            [_picker reloadComponent:1];
            [_nameArray removeAllObjects];
            [_nameArray addObjectsFromArray:[[_citysArray objectAtIndex:0] objectForKey:@"stores"]];
            [_picker reloadComponent:2];
            
            NSArray *array = [[_provincesArray objectAtIndex:i] objectForKey:@"citys"];
            for (int j = 0; j < [array count]; j++) {
                if ([myDelegate.city isEqualToString:[[array objectAtIndex:j] objectForKey:@"cityName"]]) {
                    [_picker selectRow:j inComponent:1 animated:YES];
                    [_nameArray removeAllObjects];
                    [_nameArray addObjectsFromArray:[[_citysArray objectAtIndex:j] objectForKey:@"stores"]];
                    [_picker reloadComponent:2];
                }
            }
        }
    }
}
- (NSInteger)numberOfComponentsInPickerView:(UIPickerView*)pickerView {
    return 3;
}

- (NSInteger)pickerView:(UIPickerView *)pickerView numberOfRowsInComponent:(NSInteger)component {
    if (component == 0) {
        return [_provincesArray count];
    }
    if (component == 1) {
        return [_citysArray count];
    }
    return [_nameArray count];
}

- (NSString *)pickerView:(UIPickerView *)pickerView titleForRow:(NSInteger)row forComponent:(NSInteger)component {
    if (component == 0) {
        return [[_provincesArray objectAtIndex:row] objectForKey:@"provinceName"];
    }
    if (component == 1) {
        return [[_citysArray objectAtIndex:row] objectForKey:@"cityName"];
    }
    return [[_nameArray objectAtIndex:row] objectForKey:@"name"];
}
- (void)pickerView:(UIPickerView *)pickerView didSelectRow: (NSInteger)row inComponent:(NSInteger)component {
    if (component == 0) {
        NSInteger selecRow = [_picker selectedRowInComponent:0];
        [_citysArray removeAllObjects];
        [_citysArray addObjectsFromArray:[[_provincesArray objectAtIndex:selecRow] objectForKey:@"citys"]];
        [pickerView reloadComponent:1];
        [_nameArray removeAllObjects];
        [_nameArray addObjectsFromArray:[[_citysArray objectAtIndex:0] objectForKey:@"stores"]];
        [pickerView reloadComponent:2];
    }
    if (component == 1) {
        NSInteger selecRow = [_picker selectedRowInComponent:1];
        [_nameArray removeAllObjects];
        [_nameArray addObjectsFromArray:[[_citysArray objectAtIndex:selecRow] objectForKey:@"stores"]];
        [pickerView reloadComponent:2];
    }
}
- (void)done {
    
    NSInteger selecRowP = [_picker selectedRowInComponent:0];
    NSInteger selecRowC = [_picker selectedRowInComponent:1];
    NSInteger selecRowN = [_picker selectedRowInComponent:2];
    AppDelegate *myDelegate = [[UIApplication sharedApplication] delegate];
    myDelegate.state = [[_provincesArray objectAtIndex:selecRowP] objectForKey:@"provinceName"];
    
    myDelegate.city = [[[[_provincesArray objectAtIndex:selecRowP] objectForKey:@"citys"] objectAtIndex:selecRowC] objectForKey:@"cityName"];
    myDelegate.shop = [[[[[[_provincesArray objectAtIndex:selecRowP] objectForKey:@"citys"] objectAtIndex:selecRowC] objectForKey:@"stores"] objectAtIndex:selecRowN] objectForKey:@"name"];
    myDelegate.shopId = [[[[[[_provincesArray objectAtIndex:selecRowP] objectForKey:@"citys"] objectAtIndex:selecRowC] objectForKey:@"stores"] objectAtIndex:selecRowN] objectForKey:@"id"];
    myDelegate.shopAddress = [[[[[[_provincesArray objectAtIndex:selecRowP] objectForKey:@"citys"] objectAtIndex:selecRowC] objectForKey:@"stores"] objectAtIndex:selecRowN] objectForKey:@"address"];

    _storeId = [NSString stringWithFormat:@"%@",[[[[[[_provincesArray objectAtIndex:selecRowP] objectForKey:@"citys"] objectAtIndex:selecRowC] objectForKey:@"stores"] objectAtIndex:selecRowN] objectForKey:@"id"]];
    [self createSelect];
    [self startRequest];
}
- (UIView *)pickerView:(UIPickerView *)pickerView viewForRow:(NSInteger)row forComponent:(NSInteger)component reusingView:(UIView *)view{
    UILabel* pickerLabel = (UILabel*)view;
    if (!pickerLabel){
        pickerLabel = [[UILabel alloc] init];
        pickerLabel.adjustsFontSizeToFitWidth = YES;
        pickerLabel.textAlignment = NSTextAlignmentCenter;
        [pickerLabel setBackgroundColor:[UIColor clearColor]];
        [pickerLabel setFont:[UIFont boldSystemFontOfSize:15]];
    }
    // Fill the label text here
    pickerLabel.text=[self pickerView:pickerView titleForRow:row forComponent:component];
    return pickerLabel;
}

@end
