//
//  PaymentViewController.m
//  红
//
//  Created by 焦钟培 on 15/12/27.
//  Copyright © 2015年 焦钟培. All rights reserved.
//

#import "PaymentViewController.h"
#import "AFNetworking.h"
#import "PayResultViewController.h"
#import "ZXingObjC.h"

@interface PaymentViewController ()
@property (strong, nonatomic) IBOutlet UIImageView *image;
@property (strong, nonatomic) IBOutlet UIImageView *tImage;
@property (strong, nonatomic) IBOutlet UIView *backView;
@property (strong, nonatomic) UIActivityIndicatorView *activityIndicator;
@property (nonatomic) NSInteger timer;
@end

@implementation PaymentViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.backView.hidden = YES;
    self.timer = 60;
    self.activityIndicator = [[UIActivityIndicatorView alloc] initWithFrame:CGRectMake(100, 100, 100, 100)];
    [self.view addSubview:self.activityIndicator];
    self.activityIndicator.center = CGPointMake(KWidth/2, KHeight/2);
    self.activityIndicator.activityIndicatorViewStyle = UIActivityIndicatorViewStyleGray;
    UILabel *navL = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 100, 44)];
    navL.text = @"付款";
    navL.textAlignment = NSTextAlignmentCenter;
    navL.font = [UIFont systemFontOfSize:16];
    self.navigationItem.title = @"";
    self.navigationItem.titleView = navL;
    [self startRequest];
}
- (void)startRequest {
    NSDictionary *dic = @{@"id":[NSNumber numberWithInteger:[[[NSUserDefaults standardUserDefaults] objectForKey:@"userId"] integerValue]],@"userCardId":[[NSUserDefaults standardUserDefaults] objectForKey:@"userCardId"]};
    AFHTTPRequestOperationManager *manager = [AFHTTPRequestOperationManager manager];

// 设置请求格式
    manager.requestSerializer = [AFJSONRequestSerializer serializer];

// 设置返回格式
    manager.responseSerializer = [AFHTTPResponseSerializer serializer];
    [self.activityIndicator startAnimating];
    [NSTimer scheduledTimerWithTimeInterval:1 target:self selector:@selector(timerNum) userInfo:nil repeats:NO];
    [manager POST:SETPAYCODE parameters:dic success:^(AFHTTPRequestOperation *operation, id responseObject) {
        [self.activityIndicator stopAnimating];
        NSDictionary *dic = [NSJSONSerialization JSONObjectWithData:responseObject options:NSJSONReadingMutableContainers error:nil];
        NSLog(@"%@",dic);
        for (NSString *keyStr in dic.allKeys) {
            if ([keyStr isEqualToString:@"payCode"]) {
                self.backView.hidden = NO;
                NSError *error = nil;
                ZXMultiFormatWriter *write = [ZXMultiFormatWriter writer];
                ZXBitMatrix *result = [write encode:[dic objectForKey:@"payCode"] format:kBarcodeFormatCode128 width:_tImage.frame.size.width  height:_tImage.frame.size.height error:&error];
                
                if (result) {
                    CGImageRef image = [[ZXImage imageWithMatrix:result] cgimage];
                    UIImage *img = [UIImage imageWithCGImage:image];
//                    UIImage *imagev = [Comment OriginImage:img scaleToSize:CGSizeMake(280, 80)];
                    _tImage.image = img;
//                    _tImage.contentMode = UIViewContentModeScaleAspectFit;//图片填充方式
                }else{
                    NSString *errorMessage = [error localizedDescription];
                }
                UIImage *image = [Comment createNonInterpolatedUIImageFormQRForStringe:[dic objectForKey:@"payCode"] withSize:_image.frame.size.width];
                //        _tImage.image = [Comment generateBarCode:[dic objectForKey:@"payCode"] width:240 height:40];
                _payCode = [dic objectForKey:@"payCode"];
                _image.image = [Comment addIconToQRCodeImage:image withIcon:[UIImage imageNamed:@"家居贷logo"] withIconSize:CGSizeMake(50, 50)];
                [NSTimer scheduledTimerWithTimeInterval:5.0 target:self selector:@selector(startGetPayResultRequest) userInfo:nil repeats:NO];
                break;
            }
        }
    } failure:^(AFHTTPRequestOperation *operation, NSError *error) {
        [self.activityIndicator stopAnimating];
        NSString *cancelButtonTitle = NSLocalizedString(@"确定", nil);
        UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"提示" message:@"网络异常" preferredStyle:UIAlertControllerStyleAlert];
        // Create the actions.
        UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:cancelButtonTitle style:UIAlertActionStyleDefault handler:^(UIAlertAction *action) {
            
        }];
        [alertController addAction:cancelAction];
        //弹出提示框；
        [self presentViewController:alertController animated:true completion:nil];
    }];
        
}
- (void)timerNum {
    [NSTimer scheduledTimerWithTimeInterval:1 target:self selector:@selector(timerNum) userInfo:nil repeats:NO];
    if (_timer == 0) {
        return;
    }
    _timer--;
}


- (void)startGetPayResultRequest {
    if (_timer == 0) {
        return;
    }
    NSDictionary *dic = @{@"id":[NSNumber numberWithInteger:[[[NSUserDefaults standardUserDefaults] objectForKey:@"userId"] integerValue]],@"userCardId":[[NSUserDefaults standardUserDefaults] objectForKey:@"userCardId"],@"payCode":_payCode};
    AFHTTPRequestOperationManager *manager = [AFHTTPRequestOperationManager manager];
    
    //    // 设置请求格式
    manager.requestSerializer = [AFJSONRequestSerializer serializer];
    //    // 设置返回格式
    manager.responseSerializer = [AFHTTPResponseSerializer serializer];
    
    [manager POST:GETPAYRESULT parameters:dic success:^(AFHTTPRequestOperation *operation, id responseObject) {
        NSDictionary *dic = [NSJSONSerialization JSONObjectWithData:responseObject options:NSJSONReadingMutableContainers error:nil];
        NSString * str = [dic objectForKey:@"status"];
        if ([str isEqualToString:@""] || [str isEqualToString:@"6"]) {
            [NSTimer scheduledTimerWithTimeInterval:5.0 target:self selector:@selector(startGetPayResultRequest) userInfo:nil repeats:NO];
            return ;
        }
        
        UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"Accounts" bundle:nil];
       PayResultViewController *dev = [storyboard instantiateViewControllerWithIdentifier:@"PayResultViewController"];
        if ([str isEqualToString:@"0"]) {
            dev.payResult = 1;
            dev.payAccount = [dic objectForKey:@"posSeq"];
            dev.payMoney = [NSString stringWithFormat:@"%@",[dic objectForKey:@"txnAmt"]];
            dev.payTime = [dic objectForKey:@"time"];
        } else {
            dev.payResult = 0;
        }
        [self.navigationController pushViewController:dev animated:YES];

        NSLog(@"%@",dic);

    } failure:^(AFHTTPRequestOperation *operation, NSError *error) {
        [NSTimer scheduledTimerWithTimeInterval:5.0 target:self selector:@selector(startGetPayResultRequest) userInfo:nil repeats:NO];
    }];
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/
- (void)createrAlert: (NSString *)titil {
    UIApplication *application = [UIApplication sharedApplication];
    UIWindow *window = [application.windows objectAtIndex:0];
    UIView *backView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, KWidth, KHeight)];
    backView.backgroundColor = [UIColor grayColor];
    backView.alpha = 0.6;
    backView.tag = 1;
    [window addSubview:backView];
    
    UIView *backWView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, 300, 180)];
    backWView.center = CGPointMake(KWidth/2, KHeight/2);
    backWView.backgroundColor = [UIColor whiteColor];
    backWView.tag = 2;
    [window addSubview:backWView];
    
    UILabel *lable = [[UILabel alloc] initWithFrame:CGRectMake(0, 20, 300, 60)];
    lable.font = [UIFont systemFontOfSize:22];
    lable.backgroundColor = [UIColor groupTableViewBackgroundColor];
    lable.textAlignment = NSTextAlignmentCenter;
    lable.text = titil;
    [backWView addSubview:lable];
    
    UIButton *button = [[UIButton alloc] initWithFrame:CGRectMake(50, 100, 200, 40)];
    button.backgroundColor = [Comment getColor:@"489604"];
    [button setTitle:@"跳转支付结果" forState:UIControlStateNormal];
    button.layer.masksToBounds = YES;
    button.layer.cornerRadius = 2;
    [button setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    [button addTarget:self action:@selector(pushResultController) forControlEvents:UIControlEventTouchUpInside];
    [backWView addSubview:button];
}
- (void)pushResultController {
    UIApplication *application = [UIApplication sharedApplication];
    UIWindow *window = [application.windows objectAtIndex:0];
    for (UIView * view in window.subviews) {
        if (view.tag == 1 || view.tag == 2) {
            [view removeFromSuperview];
        }
    }
}

@end
