//
//  PushPasswordViewController.m
//  红
//
//  Created by 焦钟培 on 16/1/4.
//  Copyright © 2016年 焦钟培. All rights reserved.
//

#import "PushPasswordViewController.h"
#import "LoginViewController.h"
#import "AFNetworking.h"
#import "NSString+CommentString.h"

@interface PushPasswordViewController ()<UITextFieldDelegate>
@property (strong, nonatomic) IBOutlet UITextField *firstField;
@property (strong, nonatomic) IBOutlet UITextField *lastField;

@property (strong, nonatomic) UIActivityIndicatorView *activityIndicator;

@end

@implementation PushPasswordViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.activityIndicator = [[UIActivityIndicatorView alloc] initWithFrame:CGRectMake(100, 100, 100, 100)];
    [self.view addSubview:self.activityIndicator];
    self.activityIndicator.center = CGPointMake(KWidth/2, KHeight/2);
    self.activityIndicator.activityIndicatorViewStyle = UIActivityIndicatorViewStyleGray;
    
    _firstField.delegate = self;
    _lastField.delegate = self;
    // Do any additional setup after loading the view.
}
- (BOOL)textFieldShouldReturn:(UITextField *)textField {
    [self.lastField resignFirstResponder];
    [self.firstField resignFirstResponder];
    return NO;
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}
- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [self.navigationController.navigationBar setBackgroundImage:[Comment imageWithColor:[UIColor groupTableViewBackgroundColor]] forBarMetrics:UIBarMetricsDefault];
    self.navigationController.navigationBar.barStyle = UIBarStyleDefault;
    self.navigationController.navigationBar.shadowImage = [[UIImage alloc] init];
    UILabel *navL = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 100, 44)];
    navL.font = [UIFont systemFontOfSize:16];
    navL.textAlignment = NSTextAlignmentCenter;
    navL.text = @"忘记密码";
    self.navigationItem.title = @"";
    self.navigationItem.titleView = navL;
//    UIView *newView = [[UIView alloc] initWithFrame:CGRectMake(0, -20, KWidth, 20)];
//    newView.backgroundColor = [UIColor blackColor];
//    newView.tag = 1000;
//    [self.navigationController.navigationBar addSubview:newView];
}
- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    UIView *newView = [self.navigationController.navigationBar viewWithTag:1000];
    [newView removeFromSuperview];
    [self.navigationController.navigationBar setBackgroundImage:[UIImage imageNamed:@""] forBarMetrics:UIBarMetricsDefault];
    self.navigationController.navigationBar.barStyle = UIBarStyleDefault;
    [self.navigationController.navigationBar setTintColor:[Comment getColor:@"4999F5"]];

}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/
- (IBAction)buttonAction:(id)sender {
    if ([_firstField.text isEqualToString:_lastField.text] && _lastField.text.length != 0 && _firstField.text.length != 0) {
        [self startHTTP];
        
    } else {
        NSString *cancelButtonTitle = NSLocalizedString(@"确定", nil);
        UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"提示" message:@"密码输入错误" preferredStyle:UIAlertControllerStyleAlert];
        // Create the actions.
        UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:cancelButtonTitle style:UIAlertActionStyleDefault handler:^(UIAlertAction *action) {
            
        }];
        [alertController addAction:cancelAction];
        //弹出提示框；
        [self presentViewController:alertController animated:true completion:nil];
    }
}
- (void)startHTTP {
    [self.activityIndicator startAnimating];
    AFHTTPRequestOperationManager *manager = [AFHTTPRequestOperationManager manager];
    // 设置请求格式
    manager.requestSerializer = [AFJSONRequestSerializer serializer];
    [manager.requestSerializer setValue:@"application/json" forHTTPHeaderField:@"Content-Type"];
    // 设置返回格式
    manager.responseSerializer = [AFHTTPResponseSerializer serializer];
    [manager POST:FORGETPASSWORD parameters:@{@"phone":_phoneNum,@"password":[_firstField.text md5String],@"authCode":_authCode} success:^(AFHTTPRequestOperation *operation, id responseObject) {
        [self.activityIndicator stopAnimating];
        NSDictionary *dic = [NSJSONSerialization JSONObjectWithData:responseObject options:NSJSONReadingMutableContainers error:nil];
        NSLog(@"%@",dic);
        NSString *result = [[NSString alloc] initWithData:responseObject encoding:NSUTF8StringEncoding];
        id message = [dic objectForKey:@"message"];
        if ([message isKindOfClass:[NSString class]]) {
            NSString *cancelButtonTitle = NSLocalizedString(@"确定", nil);
            UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"提示" message:[dic objectForKey:@"message"] preferredStyle:UIAlertControllerStyleAlert];
            // Create the actions.
            UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:cancelButtonTitle style:UIAlertActionStyleDefault handler:^(UIAlertAction *action) {
                
            }];
            [alertController addAction:cancelAction];
            //弹出提示框；
            [self presentViewController:alertController animated:true completion:nil];
        } else {
            [self.navigationController popToViewController:[self.navigationController.viewControllers objectAtIndex:[self.navigationController.viewControllers count]- 3] animated:NO];
        }

        
    } failure:^(AFHTTPRequestOperation *operation, NSError *error) {
        [self.activityIndicator stopAnimating];
        NSString *cancelButtonTitle = NSLocalizedString(@"确定", nil);
        UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"提示" message:@"网络异常" preferredStyle:UIAlertControllerStyleAlert];
        // Create the actions.
        UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:cancelButtonTitle style:UIAlertActionStyleDefault handler:^(UIAlertAction *action) {
            
        }];
        [alertController addAction:cancelAction];
        //弹出提示框；
        [self presentViewController:alertController animated:true completion:nil];
    }];
}

@end
