//
//  RegisterViewController.m
//  红
//
//  Created by 焦钟培 on 15/12/15.
//  Copyright © 2015年 焦钟培. All rights reserved.
//

#import "RegisterViewController.h"
#import "AFNetworking.h"
#import "NSString+CommentString.h"

@interface RegisterViewController ()<UITextFieldDelegate>
@property (strong, nonatomic) UIAlertController *alert;
@property (strong, nonatomic) IBOutlet UITextField *phoneNum;
@property (strong, nonatomic) IBOutlet UIButton *agree;
@property (strong, nonatomic) IBOutlet UITextField *securityCode;
@property (strong, nonatomic) IBOutlet UILabel *count;
@property (strong, nonatomic) IBOutlet UITextField *firstPassword;
@property (strong, nonatomic) IBOutlet UITextField *LastPassword;
@property (nonatomic)NSInteger timer;
@property (strong, nonatomic) UIActivityIndicatorView *activityIndicator;

@property (strong, nonatomic) UIView *doneView;

@end

@implementation RegisterViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.activityIndicator = [[UIActivityIndicatorView alloc] initWithFrame:CGRectMake(100, 100, 100, 100)];
    [self.view addSubview:self.activityIndicator];
    self.activityIndicator.center = CGPointMake(KWidth/2, KHeight/2);
    self.activityIndicator.activityIndicatorViewStyle = UIActivityIndicatorViewStyleGray;
    
    self.count.layer.cornerRadius = 2;
    self.count.layer.masksToBounds = YES;
    self.count.layer.borderWidth = 0.5;
    self.count.layer.borderColor = [[Comment getColor:@"e5e5e5" ] CGColor];
    self.phoneNum.delegate = self;
    self.firstPassword.delegate = self;
    self.LastPassword.delegate = self;
    self.securityCode.delegate = self;
    [self registerForKeyboardNotifications];
    self.doneView = [UIView new];
    _doneView.backgroundColor = [Comment getColor:@"D0D4DA"];
    _doneView.hidden = YES;
    _doneView.frame = CGRectMake(0, KHeight - 246, KWidth, 30);
    [self.view addSubview:_doneView];
    [self.view addSubview:_doneView];
    UIView *upLine = [[UIView alloc] initWithFrame:CGRectMake(0, 0, KWidth, 1)];
    upLine.backgroundColor = [Comment getColor:@"CECFD0"];
    [_doneView addSubview:upLine];
    UIView *downLine = [[UIView alloc] initWithFrame:CGRectMake(0, 29, KWidth, 1)];
    downLine.backgroundColor = [UIColor lightGrayColor];
    [_doneView addSubview:downLine];
    UIButton *doneButton = [[UIButton alloc] initWithFrame:CGRectMake(KWidth - 50, 5, 40, 20)];
//    doneButton.layer.cornerRadius = 2;
//    doneButton.layer.masksToBounds = YES;
//    doneButton.layer.borderColor = [[UIColor blackColor] CGColor];
//    doneButton.layer.borderWidth = 0.5;
    [doneButton setTitleColor:[Comment getColor:@"007aff"] forState:UIControlStateNormal];

    [doneButton setTitle:@"完成" forState:UIControlStateNormal];
    [doneButton addTarget:self action:@selector(responderKeyBoard) forControlEvents:UIControlEventTouchUpInside];
    [_doneView addSubview:doneButton];
    // Do any additional setup after loading the view.
}
- (void)responderKeyBoard {
    _doneView.hidden = YES;
    [self.firstPassword resignFirstResponder];
    [self.phoneNum resignFirstResponder];
    [self.LastPassword resignFirstResponder];
    [self.securityCode resignFirstResponder];

}

    // Do any additional setup after loading the view.

//- (void)viewWillAppear:(BOOL)animated {
//    [self.navigationController.navigationBar setBackgroundImage:[UIImage imageNamed:@"nav"] forBarMetrics:UIBarMetricsDefault];
//    self.navigationController.navigationBar.barStyle = UIBarStyleBlackTranslucent;
//}
//- (void)viewWillDisappear:(BOOL)animated {
//    [self.navigationController.navigationBar setBackgroundImage:nil forBarMetrics:UIBarMetricsDefault];
//    self.navigationController.navigationBar.barStyle = UIBarStyleDefault;
//}
- (BOOL)textFieldShouldReturn:(UITextField *)textField {
    [self.LastPassword resignFirstResponder];
    [self.firstPassword resignFirstResponder];
    if (textField.tag == 4) {
        if (![_firstPassword.text isEqualToString:_LastPassword.text]) {
            [self createrAlertMessage:@"输入相同密码"];
        }
    }
    return NO;
}

- (void)textFieldDidEndEditing:(UITextField *)textField {
    if (textField.tag == 1) {
        [self startHTTPUrl:@"http://192.168.10.181:8080/jjd-background/api/user/byPhone" parameters:@{@"phone":textField.text} isJudge:YES];
    }
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}
- (void)createrAlertMessage: (NSString *)message {
    //初始化提示框；
    self.alert = [UIAlertController alertControllerWithTitle:@"提示" message:message preferredStyle:  UIAlertControllerStyleAlert];
    
    //弹出提示框；
    [self presentViewController:_alert animated:true completion:nil];
    
    if ([message isEqualToString:@"注册成功"]) {
        [NSTimer scheduledTimerWithTimeInterval:2 target:self selector:@selector(dismissAndPushViewController) userInfo:nil repeats:NO];
    } else {
        [NSTimer scheduledTimerWithTimeInterval:2 target:self selector:@selector(dismissViewController) userInfo:nil repeats:NO];
    }
}
- (void)dismissAndPushViewController {
    [_alert dismissViewControllerAnimated:YES completion:nil];
    [self.navigationController popViewControllerAnimated:YES];
}
- (void)dismissViewController {
    [_alert dismissViewControllerAnimated:YES completion:nil];
}
- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [self.navigationController.navigationBar setBackgroundImage:[Comment imageWithColor:[UIColor groupTableViewBackgroundColor]] forBarMetrics:UIBarMetricsDefault];
    self.navigationController.navigationBar.barStyle = UIBarStyleDefault;
    self.navigationController.navigationBar.shadowImage = [[UIImage alloc] init];
    UILabel *navL = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 100, 44)];
    navL.font = [UIFont systemFontOfSize:16];
    navL.textAlignment = NSTextAlignmentCenter;
    navL.text = @"注册家居贷";
    self.navigationItem.title = @"";
    self.navigationItem.titleView = navL;
//    UIView *newView = [[UIView alloc] initWithFrame:CGRectMake(0, -20, KWidth, 20)];
//    newView.backgroundColor = [UIColor blackColor];
//    newView.tag = 1000;
//    [self.navigationController.navigationBar addSubview:newView];
}
- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    UIView *newView = [self.navigationController.navigationBar viewWithTag:1000];
    [newView removeFromSuperview];
    [self.navigationController.navigationBar setBackgroundImage:[UIImage imageNamed:@""] forBarMetrics:UIBarMetricsDefault];
    self.navigationController.navigationBar.barStyle = UIBarStyleDefault;
    [self.navigationController.navigationBar setTintColor:[Comment getColor:@"4999F5"]];
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/
- (IBAction)securityCodeAction:(id)sender {
    UIButton *button = (UIButton *)sender;
    button.tag = 1000;
    button.enabled = NO;
    self.timer = 60;
    self.count.text = [NSString stringWithFormat:@"%ld",(long)_timer];
    [self startCount];
}
- (void)startCount {
    [self startHTTPUrl:CREATESENDURL parameters:@{@"phone":_phoneNum.text} isJudge:NO];
    [self changeCountValue];

}

- (void)changeCountValue {
    
    _timer--;
    if (_timer == 0) {
        UIButton *button = (UIButton *)[self.view viewWithTag:1000];
        button.enabled = YES;
        _count.text = @"获取验证码";
        return;
    } else {
        [NSTimer scheduledTimerWithTimeInterval:1 target:self selector:@selector(changeCountValue) userInfo:nil repeats:NO];
    }
    self.count.text = [NSString stringWithFormat:@"%ld",(long)_timer];
}
- (IBAction)agreeAction:(id)sender {
    if (_agree.selected) {
        _agree.selected = NO;
    } else {
        _agree.selected = YES;
    }
}
- (IBAction)registerAction:(id)sender {
    
    if (![_firstPassword.text isEqualToString:_LastPassword.text]) {
        [self createrAlertMessage:@"输入相同密码"];
        return;
    }
    if (_phoneNum.text.length != 11) {
        [self createrAlertMessage:@"输入正确地手机号"];
        return;
    }

    NSString *password = [_firstPassword.text md5String];
    NSDictionary *dic = @{@"password":password,@"phone":_phoneNum.text,@"authCode":_securityCode.text};
    [self startHTTPUrl:CREATEURL parameters:dic isJudge:YES];
}
- (NSString *)startHTTPUrl:(NSString *)url parameters: (NSDictionary *)parameters isJudge: (BOOL)isJudge {
    [self.activityIndicator startAnimating];
    AFHTTPRequestOperationManager *manager = [AFHTTPRequestOperationManager manager];
    // 设置请求格式
    manager.requestSerializer = [AFJSONRequestSerializer serializer];
    [manager.requestSerializer setValue:@"application/json" forHTTPHeaderField:@"Content-Type"];
    // 设置返回格式
    manager.responseSerializer = [AFHTTPResponseSerializer serializer];
    [manager POST:url parameters:parameters success:^(AFHTTPRequestOperation *operation, id responseObject) {
        [self.activityIndicator stopAnimating];
        NSDictionary *dic = [NSJSONSerialization JSONObjectWithData:responseObject options:NSJSONReadingMutableContainers error:nil];
        NSLog(@"%@",dic);
        NSString *result = [[NSString alloc] initWithData:responseObject encoding:NSUTF8StringEncoding];

        if (isJudge) {
            id message = [dic objectForKey:@"message"];
            if ([message isKindOfClass:[NSString class]]) {
                
                [self createrAlertMessage:[dic objectForKey:@"message"]];
            } else {
                [self createrAlertMessage:@"注册成功"];
            }
        }
        NSLog(@"%@", result);
    } failure:^(AFHTTPRequestOperation *operation, NSError *error) {
        [self.activityIndicator stopAnimating];
        NSString *cancelButtonTitle = NSLocalizedString(@"确定", nil);
        UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"提示" message:@"网络异常" preferredStyle:UIAlertControllerStyleAlert];
        // Create the actions.
        UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:cancelButtonTitle style:UIAlertActionStyleDefault handler:^(UIAlertAction *action) {
            
        }];
        [alertController addAction:cancelAction];
        //弹出提示框；
        [self presentViewController:alertController animated:true completion:nil];
    }];
    return @"";
}
- (void) registerForKeyboardNotifications
{
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(keyboardWasShown:) name:UIKeyboardDidShowNotification object:nil];
    
    [[NSNotificationCenter defaultCenter]  addObserver:self selector:@selector(keyboardWasHidden:) name:UIKeyboardDidHideNotification object:nil];
}

- (void) keyboardWasShown:(NSNotification *) notif
{
    _doneView.hidden = NO;
    NSDictionary *info = [notif userInfo];
    NSValue *value = [info objectForKey:UIKeyboardFrameBeginUserInfoKey];
    CGSize keyboardSize = [value CGRectValue].size;
    
    NSLog(@"keyBoard:%f", keyboardSize.height);
}
- (void) keyboardWasHidden:(NSNotification *) notif
{
    _doneView.hidden = YES;
    NSDictionary *info = [notif userInfo];
    NSValue *value = [info objectForKey:UIKeyboardFrameBeginUserInfoKey];
    CGSize keyboardSize = [value CGRectValue].size;
    NSLog(@"keyboardWasHidden keyBoard:%f", keyboardSize.height);
}

@end
