//
//  SettingViewController.m
//  红
//
//  Created by 焦钟培 on 15/12/27.
//  Copyright © 2015年 焦钟培. All rights reserved.
//

#import "SettingViewController.h"
#import "AccountsTableViewCell.h"
#import "OutTableViewCell.h"
#import "LoginPasswordViewController.h"
#import "PayPasswordViewController.h"


@interface SettingViewController ()<UITableViewDataSource, UITableViewDelegate>

@property (nonatomic, strong)NSMutableArray *tableArray;

@end

@implementation SettingViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.tableArray = [NSMutableArray arrayWithObjects:@"",@"修改登录密码",@"设置支付密码",@"",@"",nil];
    UILabel *navL = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 100, 44)];
    navL.font = [UIFont systemFontOfSize:16];
    navL.text = @"设置";
    navL.textAlignment = NSTextAlignmentCenter;
    
    self.navigationItem.title = @"";
    self.navigationItem.titleView = navL;
    // Do any additional setup after loading the view.
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return [_tableArray count];
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    if (indexPath.row == 4) {
        static NSString *CellIdentifier = @"OutTableViewCell";
        OutTableViewCell *cell = (OutTableViewCell*)[tableView dequeueReusableCellWithIdentifier:CellIdentifier];
        if (cell == nil)
        {
            cell= (OutTableViewCell *)[[[NSBundle  mainBundle]  loadNibNamed:@"OutTableViewCell" owner:self options:nil]  lastObject];
        }
        cell.backgroundColor = [UIColor clearColor];
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        [cell.button addTarget:self action:@selector(outButtonAction) forControlEvents:UIControlEventTouchUpInside];
        return cell;
    }
    
    if (indexPath.row == 0 || indexPath.row == 3) {
        static NSString *CellIdentifier = @"UITableViewCell";
        UITableViewCell *cell = (UITableViewCell*)[tableView dequeueReusableCellWithIdentifier:CellIdentifier];
        if (cell == nil)
        {
            cell= [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:CellIdentifier];
        }
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        if (indexPath.row == 3) {
            cell.selectionStyle = UITableViewCellSelectionStyleNone;
            UIView *view = [[UIView alloc] initWithFrame:CGRectMake(0, 16, KWidth, 1)];
            view.backgroundColor = [Comment getColor:@"CECFD0"];
            [cell addSubview:view];
        } else {
            cell.backgroundColor = [UIColor clearColor];
        }
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        return cell;
    }

    static NSString *CellIdentifier = @"AccountsTableViewCell";
    AccountsTableViewCell *cell = (AccountsTableViewCell*)[tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil)
    {
        cell= (AccountsTableViewCell *)[[[NSBundle  mainBundle]  loadNibNamed:@"AccountsTableViewCell" owner:self options:nil]  lastObject];
    }
    cell.title.text = [_tableArray objectAtIndex:indexPath.row];
    if (indexPath.row == 2) {
        cell.lastView.hidden = YES;
        cell.firstView.hidden = YES;
        cell.pic.image = [UIImage imageNamed:@"设置支付密码icon"];

    }
    if (indexPath.row == 1) {
        cell.pic.image = [UIImage imageNamed:@"修改登录密码icon"];
    }
    cell.selectionStyle = UITableViewCellSelectionStyleNone;

    return cell;
    
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    if (indexPath.row == 0) {
        return 20;
    }
    if (indexPath.row == 4) {
        return 120;
    }
    if (indexPath.row == 3) {
        return 17;
    }
    return 65;
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"Accounts" bundle:nil];
    LoginPasswordViewController *loginDev = [storyboard instantiateViewControllerWithIdentifier:@"LoginPasswordViewController"];
    PayPasswordViewController *payDev = [storyboard instantiateViewControllerWithIdentifier:@"PayPasswordViewController"];
    switch (indexPath.row) {
        case 0:
            
            break;
        case 1:
            [self.navigationController pushViewController:loginDev animated:YES];
            break;
        case 2:
            [self.navigationController pushViewController:payDev animated:YES];
            break;
        case 3:
            
            break;
            
        default:
            break;
    }
}
- (void)outButtonAction {
    [[NSUserDefaults standardUserDefaults] setObject:@"no" forKey:@"islogin"];
    [[NSUserDefaults standardUserDefaults] setObject:nil forKey:@"userId"];
    [self.navigationController popToRootViewControllerAnimated:YES];
    
}
- (void)createAlert {
    UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"文本对话框" message:@"登录和密码对话框示例" preferredStyle:UIAlertControllerStyleAlert];
    [alertController addTextFieldWithConfigurationHandler:^(UITextField *textField){
        textField.placeholder = @"登录";
    }];
    [alertController addTextFieldWithConfigurationHandler:^(UITextField *textField) {
        textField.placeholder = @"密码";
        textField.secureTextEntry = YES;
    }];
    UIAlertAction *okAction = [UIAlertAction actionWithTitle:@"好的" style:UIAlertActionStyleDefault handler:^(UIAlertAction *action) {
        UITextField *login = alertController.textFields.firstObject;
        UITextField *password = alertController.textFields.lastObject;
    }];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
