//
//  UserSheet.m
//  红
//
//  Created by 焦钟培 on 15/12/21.
//  Copyright © 2015年 焦钟培. All rights reserved.
//

#import "UserSheet.h"
#import "AppDelegate.h"
#define WINDOW_COLOR [UIColor colorWithRed:0 green:0 blue:0 alpha:0.4]
#define ANIMATE_DURATION  0.25f

@implementation UserSheet
-(id)initWithView:(UIView *)view AndHeight:(float)height {
    self = [super init];
    if (self) {
        //初始化背景视图，添加手势
        self.frame = CGRectMake(0, 0, [UIScreen mainScreen].bounds.size.width, [UIScreen mainScreen].bounds.size.height);
        self.backgroundColor = WINDOW_COLOR;
        UITapGestureRecognizer *tapGesture = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(tappedCancel)];
        [self addGestureRecognizer:tapGesture];
        //生成LZWActionSheetView
        self.backGroundView = [[UIView alloc] initWithFrame:CGRectMake(0, ([UIScreen mainScreen].bounds.size.height - 200), 320, height)];
        self.backGroundView.backgroundColor = [UIColor whiteColor];
        button = [[UIButton alloc] initWithFrame:CGRectMake(0, height - 44, KWidth, 44)];
        button.backgroundColor = [UIColor whiteColor];
        [button setTitle:@"确认" forState:UIControlStateNormal];
        button.layer.borderWidth = 0.5;
        button.layer.borderColor = [[UIColor blackColor] CGColor];
        [button setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
        [button addTarget:self action:@selector(done) forControlEvents:UIControlEventTouchUpInside];
        
        UITapGestureRecognizer *tapGesture1 = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(tappedBackGroundView)];
        [self.backGroundView addGestureRecognizer:tapGesture1];
        
        
        [self addSubview:self.backGroundView];
        [self.backGroundView addSubview:button];
        [self.backGroundView addSubview:view];
        
        [UIView animateWithDuration:0.2f animations:^{
            [self.backGroundView setFrame:CGRectMake(0, [UIScreen mainScreen].bounds.size.height-height, [UIScreen mainScreen].bounds.size.width, height)];
            
        } completion:^(BOOL finished) {
            
        }];
        
        
    }
    
    return self;
}

- (void)tappedCancel {
    [UIView animateWithDuration:ANIMATE_DURATION animations:^{
        [self.backGroundView setFrame:CGRectMake(0, [UIScreen mainScreen].bounds.size.height, [UIScreen mainScreen].bounds.size.width, 0)];
        self.alpha = 0;
    } completion:^(BOOL finished) {
        if (finished) {
            [self removeFromSuperview];
        }
    }];
}
-(void)showInView:(UIView *)view{
    [[UIApplication sharedApplication].delegate.window addSubview:self];
    
}
- (void)tappedBackGroundView {
    
}

-(void)done {
    [self.doneDelegate done];
    [self tappedCancel];
}

-(void)docancel {
    [self tappedCancel];
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
