// pages/add_record/index.js
Page({
  

  /**
   * 页面的初始数据
   */
  data: {
    radioValues: [
      { 'value': '饮食', 'selected': true },
      { 'value': '睡觉', 'selected': false },
      { 'value': 'WC', 'selected': false },
    ],
    clazz: [],
    controlIndex:0,
    categorys: ['早餐', '午餐', '晚餐', '上午加餐', '下午加餐', '喝水', '牛奶'],
    selectIndex:0,
    inputModel: [
      
    ]

  },

  tapCategory: function(e) {

    this.setData({
      selectIndex: e.target.dataset.index,
    })
  },

  indexChanged: function(e){
		// 点中的是组中第个元素
		var index = e.target.dataset.index;
    
		// 读取原始的数组
		var radioValues = this.data.radioValues;
		for (var i = 0; i < radioValues.length; i++){
			// 全部改为非选中
			radioValues[i].selected = false;
			// 当前那个改为选中
			radioValues[index].selected = true;
		}

    // console.log(radioValues)
		// 写回数据
		this.setData({
			radioValues: radioValues,
      controlIndex: index
		});
		// clazz状态
		this.clazzStatus();
	},
	onLoad: function(){
		// onLoad 比 onReady 更早调用，后者为选中时屏幕闪动一下
		this.clazzStatus();
	},
	clazzStatus: function(){
		/* 此方法分别被加载时调用，点击某段时调用 */
		// class样式表如"selected last","selected"
		var clazz = [];
		// 参照数据源
		var radioValues = this.data.radioValues;
		for (var i = 0; i < radioValues.length; i++){
			// 默认为空串，即普通按钮
			var cls = '';
			// 高亮，追回selected
			if (radioValues[i].selected) {
				cls += 'selected ';
			}
			// 最后个元素, 追加last
			if (i == radioValues.length - 1) {
				cls += 'last ';
			}
			//去掉尾部空格
			cls = cls.replace(/(\s*$)/g,'');
			clazz[i] = cls;
		}

    // console.log(clazz)
		// 写回数据
		this.setData({
			clazz: clazz
		});
	},

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  }
})