// pages/home/parents/index.js

const request = require('../../../api/parrent.js')
const app = getApp()


Page({

  /**
   * 页面的初始数据
   */
  data: {
    page: 0,
    pageSize: 15,
    records: [],
    recordTypes: app.globalData.recordTypes,
    eatStates: app.globalData.eatStates
    
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function(options) {
    const that = this
    

    if (app.globalData.login.students.length == 0) {
      wx.showToast({
        title: '无学生信息, 请联系管理员',
        icon: 'none'
      })
      return
    }
    let student = app.globalData.login.students[0]
    var studentId = student.id
    this.setData({
      student:student
    })

    request.queryStudentRecord(that.data.page, that.data.pageSize, studentId).then(res => {
      console.log(res)
      let resData = res


      var record = resData['records']
      var templist = this.data.records
      for (var i = 0; i < record.length; i++) {
        var item = record[i]

        var dateStr = item.recordDate.substr(0, 10)
        let show_day = new Array('周日', '周一', '周二', '周三', '周四', '周五', '周六');
        let date = new Date(dateStr);
        var num = date.getDay()
        item.recordDate = dateStr + " " + show_day[date.getDay()]

        // 饮食
        var dietRecords = item['dietRecord']

        for (var j = 0; j < dietRecords.length; j++) {
          var diet = dietRecords[j]
          diet.z_recordType = that.data.recordTypes[diet.recordType]
          diet.z_eatState = that.data.eatStates[diet.eatState]
          if (diet.recordType == 'diet_milk') {
            diet.z_eatState = diet.value + "毫升"
          }
          if (diet.recordType == 'diet_water') {
            diet.z_eatState = diet.value + "次"
          }
        }

        // 睡觉
        var sleepRecord = item["sleepRecord"]
        for (var j = 0; j < sleepRecord.length; j++) {
          var r = sleepRecord[j]
          r.z_recordType = that.data.recordTypes[r.recordType]

        }

        // wc
        var wcRecord = item["wcRecord"]
        for (var j = 0; j < wcRecord.length; j++) {
          var r = wcRecord[j]
          r.z_recordType = that.data.recordTypes[r.recordType]

        }

        console.log(item)
        templist.push(item)
      }


      this.setData({
        records: templist,
        page: resData['paging']['page']
      })

    })

  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function() {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function() {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function() {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function() {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function() {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function() {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function() {

  }
})