// pages/home/reviewer/index.js
const request = require('../../../api/teacher.js')
const app = getApp()
Page({

  /**
   * 页面的初始数据
   */
  data: {
    selectIndex: 0,
    teacherId: "",
    classList: [],
    classId: "",
    records: [],
    
  },

  tapClass: function(e) {
    console.log(e)
    this.setData({
        selectIndex: e.target.dataset.index,
        classId: e.currentTarget.id
      }),
      this.querySignSummary()
  },

  tapStudent: function(e) {
    wx.navigateTo({
      url: '/pages/review_student/index?signSummaryId=' + e.currentTarget.id
    })
  },

  querySignSummary: function() {
    request.querySignSummaryByClass(this.data.classId).then(res => {
      console.log(res)
      for (var i = 0; i < res.length; i++) {
        var item = res[i]
        item.signDate = item.signDate.substr(0, 10)
      }
      this.setData({
        records: res
      })
    }).catch(err => {
      wx.showToast({
        title: err.message,
        icon: 'none',
        duration: 2000
      })
    })
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function(options) {
    this.setData({
      teacherId: app.globalData.login.user.id,
      classList: app.globalData.login.classes,
      reviewerName: app.globalData.login.user.name,

    })

    if (this.data.classList.length > 0) {
      this.data.classId = this.data.classList[0].id
    }
    this.querySignSummary()
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function() {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function() {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function() {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function() {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function() {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function() {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function() {

  }
})