// pages/home/sign/index.js

const req = require('../../../api/teacher.js')
const app = getApp()
Page({

  /**
   * 页面的初始数据
   */
  data: {
    selectTags: {},
    classId: ""

  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function(options) {
    let classId = options.classId
    req.getAllStudent(classId).then(res => {
      console.log(res)
      this.setData({
        records: res,
        classId:classId
      })
    })



  },
  tapBox: function(e) {
    console.log(e)
    let selected = !e.currentTarget.dataset.check
    let tags = this.data.selectTags

    tags[e.currentTarget.dataset.cellindex] = selected
    this.setData({
      selectTags: tags
    })

  },
  operateTap: function(event) {
    console.log(event._relatedInfo.anchorTargetText)
    let records = this.data.records

    var studentIds = []
    for (var i = 0; i < records.length; i++) {
      let item = records[i]
      if (this.data.selectTags[i]) {
        studentIds.push(item.id)
      }
    }
    console.log(studentIds)

    req.signIn(app.globalData.login.user.id, this.data.classId, studentIds).then(res => {
      wx.showToast({
        title: '签到成功~',
        duration: 1500
      })
      setTimeout(() => {
        wx.navigateBack({
          delta: 1
        })
      }, 1500)
    })
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function() {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function() {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function() {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function() {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function() {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function() {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function() {

  }
})