// pages/home/teacher/index.js
const request = require('../../../api/teacher.js')
const utils = require('../../../utils/util.js')
const app = getApp()
Page({

  /**
   * 页面的初始数据
   */
  data: {
    signIcon: "/src/img/signin.png",
    userIcon: "/src/img/defaut_teacher_icon.png",
    records: [],
    userName:'',
    subTitle:'共20人'

  },

  previewPic: function(e) {
    var current = this.data.records[e.target.dataset.index].arrPic[e.target.dataset.picIndex]
    wx.previewImage({
      current: current,
      urls: this.data.records[e.target.dataset.index].arrPic
    })

  },

  tapCell: function(e) {
    console.log(e)
    let index = e.currentTarget.dataset.index
    let student = this.data.records[index]
    wx.navigateTo({
      url: '/pages/add_record/index?studentIds=' + JSON.stringify([student.id]) + '&pictureIds=' + JSON.stringify(student.arrIds),
    })

  },

  operateTap: function(event) {
    console.log(event._relatedInfo.anchorTargetText)
    var studentIds = []
    for (var i = 0; i < this.data.records.length; i++) {
      studentIds.push(this.data.records[i].id)
    }
    wx.navigateTo({
      url: '/pages/add_record/index?studentIds=' + JSON.stringify(studentIds),
    })
  },

  signTap: function(e) {
    if (app.globalData.login.classes.length == 0) {
      wx.showToast({
        title: '无班级信息, 请联系管理员',
        icon: 'none'
      })
      return
    }
    var signSummary = app.globalData.login.classes[0].id
    wx.navigateTo({
      url: '/pages/home/sign/index?classId=' + signSummary,
    })
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function(options) {
    this.setData({
      userName: app.globalData.login.user.userName,
    })

  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function() {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function() {
    // 设置日期
    let date = new Date()
    let dateStr = utils.formatDate(date)
    this.setData({
      dateStr: dateStr
    })

    if (app.globalData.login.classes.length == 0) {
      wx.showToast({
        title: '无班级信息, 请联系管理员',
        icon: 'none'
      })
      return
    }
    var signSummary = app.globalData.login.classes[0].id

    // request.querySignSummary("4028048267a65d0f0167a69ae1910058", "4028048267a5969b0167a5b22f3807f8").then(res => {
    request.querySignSummary(app.globalData.login.user.id, signSummary).then(res => {
      console.log(res)

      for (var i = 0; i < res.length; i++) {
        var item = res[i]
        item.signDate = item.signDate.substr(0, 10)
        var arrPic = []
        let arrIds = []
        if (item.picture != null && item.picture != '') {
          arrIds = item.picture.split(",")
          for (var j = 0; j < arrIds.length; j++) {

            let id = arrIds[j]
            arrPic.push(utils.handleImgShow(id))
          }
        }
        console.log(arrPic)
        item.arrIds = arrIds
        item.arrPic = arrPic

      }
      this.setData({
        records: res
      })

    })

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function() {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function() {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function() {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function() {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function() {

  }
})