// pages/login/index.js
var request = require('../../api/request.js')
const app = getApp()

Page({

  /**
   * 页面的初始数据
   */
  data: {
    mobile: ''

  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    
  },

  inputAction: function (e) {
    console.log(e.detail.value)
    this.setData({
      mobile: e.detail.value
    })
  },

  operateTap: function (event) {
    let mobile = this.data.mobile
    if (mobile.length == 0) {
      wx.showToast({
        title: '请输入手机号',
        icon: 'none'
      })
      return
    }
    request.kg_login(true, mobile).then(res=>{
      console.log(res)
      app.globalData.login = res
      //1是老师,2是家长

      if (res.user.userType == 1) {
        //审核老师
        if (res.user.isAudit == "Y"){
          wx.redirectTo({
            url: '/pages/home/reviewer/index',
          })
          // 带班老师
        }else{
          wx.redirectTo({
            url: '/pages/home/teacher/index',
          })
        }
      }else if (res.user.userType == 2) {
        wx.redirectTo({
          url: '/pages/home/parents/index',
        })
      }else{
        wx.showToast({
          title: '错误的用户类型',
          icon: 'none'
        })
      }

    }).catch(function (err) {
      wx.showToast({
        title: err.message,
        icon: 'none',
        duration: 2000
      });
    });

  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  }
})