// pages/review_student/index.js
const request = require('../../api/teacher.js')

Page({

  /**
   * 页面的初始数据
   */
  data: {
    signSummaryId: "",
    recordDetail: {},
    showAuditBtn: true,
    recordTypes: {
      "diet_morning": '早餐',
      "diet_afternoon": "午餐",
      "diet_milk": "牛奶",
      "diet_evening": "晚餐",
      "diet_morning_more": "上午加餐",
      "diet_afternoon_more": "下午加餐",
      "diet_water": "喝水",
      "diet_milk": "饮用牛奶",
      "sleep_time": "睡觉时间",
      "wc_pee": "小便",
      "wc_poo": "便",
      "wc_diaper": "换尿布"
    },
    eatStates: {
      "less": "少",
      "normal": "正常",
      "more": "多"
    }
  },

  //加载详情
  getRecordDetailForSignId: function() {
    request.getRecordDetailForSignId(this.data.signSummaryId).then(res => {
      console.log(res)
      if (res) {
        var dateStr = res.recordDate.substr(0, 10)
        let show_day = new Array('周日', '周一', '周二', '周三', '周四', '周五', '周六');
        let date = new Date(dateStr);
        var num = date.getDay()
        res.recordDate = dateStr + " " + show_day[date.getDay()]

        // 饮食
        var dietRecords = res['dietRecord']
        for (var j = 0; j < dietRecords.length; j++) {
          var diet = dietRecords[j]
          diet.z_recordType = this.data.recordTypes[diet.recordType]
          diet.z_eatState = this.data.eatStates[diet.eatState]
        }

        // 睡觉
        var sleepRecord = res.sleepRecord
        for (var j = 0; j < sleepRecord.length; j++) {
          var r = sleepRecord[j]
          r.z_recordType = this.data.recordTypes[r.recordType]
        }

        // wc
        var wcRecord = res.wcRecord
        for (var j = 0; j < wcRecord.length; j++) {
          var r = wcRecord[j]
          r.z_recordType = this.data.recordTypes[r.recordType]
        }
        if (res.state == "finish") {
          this.setData({
            showAuditBtn: false
          })
        }
        this.setData({
          recordDetail: res
        })
      }

    }).catch(err => {
      wx.showToast({
        title: err.message,
        icon: 'none',
        duration: 2000
      })
    })
  },

  auditSignSummary: function(signSummaryId) {
    console.log(signSummaryId)
    request.auditSignSummary(signSummaryId).then(res => {
      this.setData({
        showAuditBtn: false
      })
      wx.showToast({
        title: '审核成功!',
        icon: 'none',
        duration: 2000
      })
    }).catch(err => {
      wx.showToast({
        title: err.message,
        icon: 'none',
        duration: 2000
      })
    })

  },

  operateTap: function(e) {
    this.auditSignSummary(this.data.signSummaryId)
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function(options) {
    this.data.signSummaryId = options.signSummaryId;
    this.getRecordDetailForSignId()
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function() {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function() {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function() {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function() {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function() {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function() {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function() {

  }
})