
var request = require('./request.js')
const app = getApp()
module.exports = {

  queryStudentRecord(pageNumber, pageSize, studentId) {
    var params = {
      pageNumber: pageNumber,
      pageSize: pageSize,
      studentId: studentId
    }
    return request.post('/wxsite/parents/queryStudentRecord.do', params)
  },

  changePassword(oldPassword, newPassword) {

    var param = {
      oldPassword: oldPassword,
      newPassword: newPassword,
      userId: app.globalData.login.user.id
    }

    return request.post('/wxsite/wxa/user/changePassword.do', param)
  },

  updateStudentPicture(studentId, pictureId) {
    var param = {
      studentId: studentId,
      pictureId: pictureId
    }
    return request.post('/wxsite/parents/updateStudentPicture.do', param)
  },
/**
 * 获取食谱
 */
  getRecipe() {
    return request.get("/wxsite/parents/getCurrentRecipe.do?orgCode=" + app.globalData.login.user.sysOrgCode)
  },
  
  getSchedule(classId) {
    var url = "/wxsite/parents/getCurrentSchedule.do?orgCode=" + app.globalData.login.user.sysOrgCode
    return request.get(url)
  }
}
