var request = require('./request.js')

module.exports = {
// 查询当天签到记录
  querySignSummary(teacherId, classId) {
    var params = {
      teacherId: teacherId,
      classId: classId
    }

    return request.get('/wxsite/teacher/querySignSummary.do', params)
  },
  // 审核老师当天签到记录
  querySignSummaryByClass(classId) {
    var params = {
      classId: classId
    }

    return request.get('/wxsite/teacher/querySignSummaryByClassId.do', params)
  },
  // 获取所有学生
  getAllStudent(classId) {
    var params = {
      classId: classId
    }
    return request.get('/wxsite/teacher/getAllStudent.do', params)
  },
  // 签到接口
  signIn(teacherId, classId, signStudents) {
    var params = {
      teacherId: teacherId,
      classId: classId,
      signStudents: signStudents
    }
    return request.post('/wxsite/teacher/signin.do', params)
  },


  //根据签到表Id获取记录明细
  getRecordDetailForSignId(signSummaryId) {
    var params = {
      signSummaryId: signSummaryId
    }
    return request.get('/wxsite/teacher/getRecordDetailForSignId.do', params)
  },

  //根据记录类型查询记录流水, 在记录的时候是否需要先查询下当天的之前的记录
  queryRecordList(recordCategory, recordType, signSummaryIds) {
    var params = {
      recordCategory: recordCategory,
      recordType: recordType,
      signSummaryIds: signSummaryIds
    }
    return request.post('/wxsite/teacher/queryRecordList.do', params)
  },

  //审核签到汇总表
  auditSignSummary(signSummaryId) {
    return request.post('/wxsite/teacher/auditSignSummary.do?signSummaryId=' + signSummaryId)
  },
// 重置单据状态到未审核状态
  resetSignSummary(signSummaryId) {
    return request.get('/wxsite/teacher/editRecord.do?signSummaryId=' + signSummaryId)
  },

  // 添加、修改记录明细
  setRecord(signSummaryId, recordList, pictureIds, remark, picRemark) {
    var params = {
      recordList: recordList
    }

    if (signSummaryId != null) {
      params.pictureList = [{
        signSummaryId: signSummaryId,
        pictures: pictureIds.join(','),
        remark:remark,
        pictureRemark: picRemark
      }]
    }

    return request.post('/wxsite/teacher/setRecord.do', params)

  },

  deleteRecord(recordId){
    let params = {
      recordId: recordId
    }

    return request.post('/wxsite/teacher/deleteRecord.do', params)
  }
}