// pages/home/reviewer/index.js
const request = require('../../../api/teacher.js')
const app = getApp()
const utils = require('../../../utils/util.js')

Page({

  /**
   * 页面的初始数据
   */
  data: {
    selectIndex: 0,
    teacherId: "",
    classList: [],
    classId: "",
    records: [],
    userIcon: ""
    
  },

  tapClass: function(e) {
    console.log(e)
    this.setData({
        selectIndex: e.target.dataset.index,
        classId: e.currentTarget.id
      }),
    this.querySignSummary()
  },


  tapStudent: function(e) {
    let student = this.data.records[e.currentTarget.dataset.index]


    wx.navigateTo({
      url: '/pages/review_student/index?signSummaryId=' + student.id + '&pictureIds=' + JSON.stringify(student.arrIds) + '&remark=' + (student.remark ? student.remark : '') + '&picRemark=' + (student.pictureRemark ? student.pictureRemark : '') + '&studentName=' + student.signStudentName + '&sex=' + student.signStudentSex + '&studentPicture=' + student.studentPicture
    })
  },

  previewPic: function (e) {
    var current = this.data.records[e.target.dataset.index].arrPic[e.target.dataset.picIndex]
    wx.previewImage({
      current: current,
      urls: this.data.records[e.target.dataset.index].arrPic
    })

  },

  querySignSummary: function() {
    request.querySignSummaryByClass(this.data.classId).then(res => {
      console.log(res)
      for (var i = 0; i < res.length; i++) {
        var item = res[i]
        item.signDate = item.signDate.substr(0, 10)
        let paymentType = app.globalData.studentPaymentTypes[item.studentPaymentType]
        item.signStudentName = item.signStudentName + ' (' + paymentType + ')'
        //图片
        var arrPic = []
        let arrIds = []
        if (item.picture != null && item.picture != '') {
          arrIds = item.picture.split(",")
          for (var j = 0; j < arrIds.length; j++) {

            let id = arrIds[j]
            arrPic.push(utils.handleImgShow(id))
          }
        }
        console.log(arrPic)
        item.arrIds = arrIds
        item.arrPic = arrPic
      }
      this.setData({
        records: res
      })
    }).catch(err => {
      wx.showToast({
        title: err.message,
        icon: 'none',
        duration: 2000
      })
    })
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function(options) {
    // 设置日期
    let date = new Date()
    let dateStr = utils.formatDate(date)
    this.setData({
      teacherId: app.globalData.login.user.id,
      classList: app.globalData.login.classes,
      reviewerName: app.globalData.login.user.name,
      userIcon: app.globalData.login.wxaUser.avatarUrl,
      kindergarten: app.globalData.login.preschoolName,
      dateStr: dateStr

    })

    if (this.data.classList.length > 0) {
      this.data.classId = this.data.classList[0].id
    }
    
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function() {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function() {
    this.querySignSummary()
  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function() {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function() {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function() {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function() {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function() {

  }
})