// pages/home/schedule/schedule.js
const utils = require('../../../utils/util.js')
const req = require('../../../api/parrent.js')
const app = getApp()

Page({

  /**
   * 页面的初始数据
   */
  data: {
    current: {
      // poster: ' ',
      name: ' ',
      author: '比来童园',
      src: ' ',
    },
    image: '',
    innerAudioContext: {},
    isPlaying: false,
    btnImage: '/src/img/play.png'

  },

  tapCover: function() {
    console.log("tapCoverView")
    wx.showToast({
      title: 'tapCoverView',
    })
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function(options) {
    const that = this
    if (app.globalData.login.students.length == 0) {
      wx.showToast({
        title: '无学生信息, 请联系管理员',
        icon: 'none'
      })
      return
    }
    let student = app.globalData.login.students[0]
    var classId = student.classId

    req.getSchedule(classId).then(res => {

      var url = utils.handleImgShow(res.attachment)
      console.log(url)
      
      const innerAudioContext = wx.createInnerAudioContext()
      this.data.innerAudioContext = innerAudioContext
      innerAudioContext.src = res.musicUrl
      innerAudioContext.loop = true
      innerAudioContext.onPlay(() => {
        
      })
      innerAudioContext.onPause(() => {
        
      })
      innerAudioContext.onError((res) => {
        console.log(res.errMsg)
        console.log(res.errCode)
      })
      innerAudioContext.onEnded((res) => {
        
      })

      this.setData({
        image: url,
        current: {
          name: res.musicName,
        }
      })

    }).catch(function(err) {
      wx.showToast({
        title: err.message,
        icon: 'none',
        duration: 2000
      });
    });
  },

  tapPlayButton: function() {
    this.data.isPlaying = !this.data.isPlaying
    let btnImage = '/src/img/play.png'
    if (this.data.isPlaying) {
      this.data.innerAudioContext.play()
      btnImage = '/src/img/stop.png'
      wx.showToast({
        title: '开始播放',
        icon: 'none'
      })
    } else {
      this.data.innerAudioContext.pause()
      wx.showToast({
        title: '已暂停',
        icon: 'none'
      })
    }

    this.setData({
      btnImage: btnImage
    })
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function() {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function() {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function() {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function() {
    this.data.innerAudioContext.destroy()

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function() {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function() {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function() {

  }
})